import eq from './eq.js';

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 * 获取在键值对的“数组”中找到“键”的索引。
 * @private
 * @param {Array} array 要检查的数组.
 * @param {*} key 搜索的关键key.
 * @returns {number} 返回匹配值的索引，否则为“-1”.
 */
function assocIndexOf(array, key) {
	let { length } = array;
	while (length--) {
		if (eq(array[length][0], key)) {
			return length;
		}
	}
	return -1;
}

export default assocIndexOf;
