/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 * 没有值检查的“assignValue”和“assignMergeValue”的基本实现。
 * @private
 * @param {Object} object 要修改的对象.
 * @param {string} key 要分配的属性的键.
 * @param {*} value 要分配的值.
 */
function baseAssignValue(object, key, value) {
	if (key == '__proto__') {
		Object.defineProperty(object, key, {
			configurable: true,
			enumerable: true,
			value: value,
			writable: true,
		});
	} else {
		object[key] = value;
	}
}

export default baseAssignValue;
