import cloneArrayBuffer from './cloneArrayBuffer.js';

/**
 * Creates a clone of `typedArray`.
 * 创建“typedArray”的克隆
 * @private
 * @param {Object} typedArray 要克隆的类型化数组.
 * @param {boolean} [isDeep] 指定深度克隆.
 * @returns {Object} 返回克隆的类型化数组.
 */
function cloneTypedArray(typedArray, isDeep) {
	const buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
	return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

export default cloneTypedArray;
