import assignValue from './assignValue.js';
import baseAssignValue from './baseAssignValue.js';

/**
 * Copies properties of `source` to `object`.
 * 将“源”的属性复制到“对象”。
 * @private
 * @param {Object} source 要从中复制属性的对象。
 * @param {Array} props 要复制的属性标识符。
 * @param {Object} [object={}] 要将属性复制到的对象。
 * @param {Function} [customizer] 自定义复制值的函数。
 * @returns {Object} 返回的对象。
 */
function copyObject(source, props, object, customizer) {
	const isNew = !object;
	object || (object = {});

	for (const key of props) {
		let newValue = customizer
			? customizer(object[key], source[key], key, object, source)
			: undefined;

		if (newValue === undefined) {
			newValue = source[key];
		}
		if (isNew) {
			baseAssignValue(object, key, newValue);
		} else {
			assignValue(object, key, newValue);
		}
	}
	return object;
}

export default copyObject;
