import copyObject from './copyObject.js';
import getSymbols from './getSymbols.js';

/**
 * Copies own symbols of `source` to `object`.
 * 将自己的“源”符号复制到“对象”。
 * @private
 * @param {Object} source 要从中复制符号的对象.
 * @param {Object} [object={}] 要将符号复制到的对象.
 * @returns {Object} 返回对象.
 */
function copySymbols(source, object) {
	return copyObject(source, getSymbols(source), object);
}

export default copySymbols;
