import getSymbolsIn from './getSymbolsIn.js';

/**
 * Creates an array of own and inherited enumerable property names and symbols of `object`.
 * 创建一个包含自己的和继承的可枚举属性名和“对象”符号的数组。
 * @private
 * @param {Object} object 要查询的对象.
 * @returns {Array} 返回属性名和符号的数组。
 */
function getAllKeysIn(object) {
	const result = [];
	for (const key in object) {
		result.push(key);
	}
	if (!Array.isArray(object)) {
		result.push(...getSymbolsIn(object));
	}
	return result;
}

export default getAllKeysIn;
