import getSymbols from './getSymbols.js';

/**
 * Creates an array of the own and inherited enumerable symbols of `object`.
 * 创建自己的和继承的“对象”可枚举符号的数组。
 * @private
 * @param {Object} object 要查询的对象.
 * @returns {Array} 返回符号数组。
 */
function getSymbolsIn(object) {
	const result = [];
	while (object) {
		result.push(...getSymbols(object));
		object = Object.getPrototypeOf(Object(object));
	}
	return result;
}

export default getSymbolsIn;
