import isPrototype from './isPrototype.js';

/**
 * Initializes an object clone.
 * 初始化对象克隆。
 * @private
 * @param {Object} object 要克隆的对象。
 * @returns {Object} 返回初始化的克隆。
 */
function initCloneObject(object) {
	return typeof object.constructor === 'function' && !isPrototype(object)
		? Object.create(Object.getPrototypeOf(object))
		: {};
}

export default initCloneObject;
