import isLength from './isLength.js';

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 * 检查' value '是否类似于数组。如果值是类数组的，则认为它是类数组的
 * 不是一个函数，有一个“值”。这是一个大于或的整数
 * 等于' 0 '，小于或等于' Number.MAX_SAFE_INTEGER '。
 * @since 4.0.0
 * @category Lang
 * @param {*} value 要检查的值.
 * @returns {boolean} 如果' value '类似于数组，则返回' true '，否则返回' false '。
 * @example
 *
 * isArrayLike([1, 2, 3])
 * // => true
 *
 * isArrayLike(document.body.children)
 * // => true
 *
 * isArrayLike('abc')
 * // => true
 *
 * isArrayLike(Function)
 * // => false
 */
function isArrayLike(value) {
	return value != null && typeof value !== 'function' && isLength(value.length);
}

export default isArrayLike;
