import arrayLikeKeys from './arrayLikeKeys.js';
import isArrayLike from './isArrayLike.js';

/**
 * Creates an array of the own enumerable property names of `object`.
 * 创建自己的可枚举属性名' object '的数组。
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 * *注:**非对象值被强制到对象。看到
 * 规范[ES] (http://ecma-international.org/ecma-262/7.0/ # sec-object.keys)
 * 了解详情。
 * @since 0.1.0
 * @category Object
 * @param {Object} object 要查询的对象。
 * @returns {Array} 返回属性名数组。
 * @see values, valuesIn
 * @example
 *
 * function Foo() {
 *   this.a = 1
 *   this.b = 2
 * }
 *
 * Foo.prototype.c = 3
 *
 * keys(new Foo)
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * keys('hi')
 * // => ['0', '1']
 */
function keys(object) {
	return isArrayLike(object) ? arrayLikeKeys(object) : Object.keys(Object(object));
}

export default keys;
