/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 * 创建一个自己的和继承的可枚举属性名'对象'的数组。
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object 要查询的对象。
 * @returns {Array} 返回属性名数组。
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
	const result = [];
	for (const key in object) {
		result.push(key);
	}
	return result;
}

export default keysIn;
