import freeGlobal from './freeGlobal.js';

/** Detect free variable `exports`. */
/** 检测自由变量“导出” */
const freeExports = typeof exports === 'object' && exports !== null && !exports.nodeType && exports;

/** Detect free variable `module`. */
/** 检测自由变量“模块”。 */
const freeModule =
	freeExports && typeof module === 'object' && module !== null && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
/** 检测流行的CommonJS扩展“module.exports” */
const moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
/** 从Node.js中检测自由变量“进程”。 */
const freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
/** 用于访问更快的Node.js助手。 */
const nodeTypes = (() => {
	try {
		/* Detect public `util.types` helpers for Node.js v10+. */
		/* 检测公共的实效。键入Node.js v10+的帮助程序。 */
		/* Node.js deprecation code: DEP0103. */
		/* 弃用代码:DEP0103。 */
		const typesHelper = freeModule && freeModule.require && freeModule.require('util').types;
		return typesHelper
			? typesHelper
			: /* Legacy process.binding('util') for Node.js earlier than v10. */
			  /* Node.js的遗留进程绑定('util')早于v10。 */
			  freeProcess && freeProcess.binding && freeProcess.binding('util');
	} catch (e) {}
})();

export default nodeTypes;
