import moment from 'moment';
import { message } from 'antd';
import baseClone from './deepclone/baseClone';
import empty from './deepclone/isEmpty';
import intersection from './deepclone/intersection';
import { isJSON } from '@/webPublic/one_stop_public/2022beidianke/isJSON';
export { isJSON };

/**
 * 校验 开始时间必须在结束时间之前的函数
 * */
export function checkDate(endTime = '2019-01-01', startTime = '2018-12-31') {
	return moment(endTime).isAfter(moment(startTime));
}

/**
 * 去除字符串中的所有html 标签
 * */
export function matchReg(str) {
	let reg = /<\/?.+?\/?>/g;
	return str.replace(reg, '').replace(/&nbsp;/g, ' ');
}

export function countSpecialField(filedSpanBig, nameSpanBig) {
	let style = {};
	if (document.body.clientWidth > 1400) {
		if (filedSpanBig === 5) {
			// 当设置一行排列5个字段时 自定义宽度为20%
			style = { width: '20%' };
		}
		if (filedSpanBig === 1 && nameSpanBig === 2) {
			// 当一行显示一个字段 然后名字又特别长时 使用这个width
			style = { width: '6%' };
		}
	}
	return style;
}

/**
 * 获取表单元素中每个元素的值,
 * @param type
 * @param e
 * @param other
 * @returns {*|boolean}
 */
export function getFormElemValue(type, e, other) {
	let value = e;

	switch (type) {
		case 'input':
			value = e.target.value;
			break;
		case 'checkbox':
			value = e.target.checked;
			break;
		case 'textarea':
			value = e.target.value;
			break;
		case 'buttonUpload':
			value = e.url;
			break;
		default:
			break;
	}

	return value;
}

/**
 * 生成随机字符串
 * */
export function randomStr() {
	return Math.random()
		.toString(36)
		.substr(2);
}

/**
 * 随机生成数字
 * @param {最小数} minNum
 * @param {最大数} maxNum
 */
export function randomNum(minNum, maxNum) {
	switch (arguments.length) {
		case 1:
			return parseInt(Math.random() * minNum + 1, 10);
			break;
		case 2:
			return parseInt(Math.random() * (maxNum - minNum + 1) + minNum, 10);
			break;
		default:
			return 0;
			break;
	}
}
export function mustHaveValue(configFields, data) {
	for (let item of configFields) {
		if (item.required && !data[item.key] && data[item.key] !== false && data[item.key] !== 0) {
			message.warning(`${item.name}是必填项请填写`);
			return false;
		}
	}
	return true;
}

// 徐立 深克隆函数
export function cloneDeep(value) {
	const CLONE_DEEP_FLAG = 1;
	const CLONE_SYMBOLS_FLAG = 4;
	return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
}

// 徐立 判断对象是否为空
export const isEmpty = empty;

/**
 * @description                       将函数转成防抖动函数
 * @param  {Function}                 需要转成防抖动函数的函数
 * @param  {number}                   延迟时间（毫秒数）
 * @param  {boolean}                  是否执行第一次
 * @return {undefined}                无返回值
 */
export function debounce(fn, delay = 600, runFirstFn = true) {
	let timer = null;

	return function(...rest) {
		// 清除定时器
		clearTimeout(timer);
		if (runFirstFn) {
			fn.apply(this, rest);
			runFirstFn = false;
			return;
		}

		// 设置定时器
		timer = setTimeout(fn.bind(this, ...rest), delay);
	};
}
/**
 * 比较传入的多个数组,返回所有数组中相同内容的数组
 */
export const compareArray = intersection;
/**
 * 比较2个数组是否相等
 */
export function ArrayIsEqual(arr1, arr2) {
	//判断2个数组是否相等
	if (arr1 === arr2) {
		//如果2个数组对应的指针相同，那么肯定相等，同时也对比一下类型
		return true;
	} else {
		if (arr1.length != arr2.length) {
			return false;
		} else {
			//长度相同
			for (let i in arr1) {
				//循环遍历对比每个位置的元素
				if (arr1[i] != arr2[i]) {
					//只要出现一次不相等，那么2个数组就不相等
					return false;
				}
			} //for循环完成，没有出现不相等的情况，那么2个数组相等
			return true;
		}
	}
}

/**
 * 16进制颜色字符串转RGB
 * @param color {Sting}
 * @returns {number[]}
 */
export function stringToRGB(color) {
	let r, g, b;
	if (color.length === 4) {
		//4位颜色处理,简写模式
		r = parseInt(color.substring(1, 2) + color.substring(1, 2), 16);
		g = parseInt(color.substring(2, 3) + color.substring(2, 3), 16);
		b = parseInt(color.substring(3) + color.substring(3), 16);
	} else {
		//7位颜色字符串处理
		r = parseInt(color.substring(1, 3), 16);
		g = parseInt(color.substring(3, 5), 16);
		b = parseInt(color.substring(5), 16);
	}
	return [r, g, b];
}
/**
 * 255RGB转16进制颜色字符串
 * @param r {Number} 0-255红色分量
 * @param g {Number} 0-255绿色分量
 * @param b {Number} 0-255蓝色分量
 * @returns {string} 16进制颜色字符串
 */
export function rgbToString(r, g, b) {
	return '#' + r.toString(16) + g.toString(16) + b.toString(16);
}
/**
 * 字符串rgba转为对象返回
 * @param rgba {String} 字符串类型的rgba(0,0,0,0)
 */
export function rgbaToObject(rgba) {
	// 判断是否为字符串
	if (typeof rgba === 'string') {
		let rIndex = rgba.indexOf(',');
		let r = rgba.slice(5, rIndex);
		let residueStr = rgba.slice(rIndex + 1);
		let gIndex = residueStr.indexOf(',');
		let g = residueStr.slice(0, gIndex);
		residueStr = residueStr.slice(gIndex + 1);
		let bIndex = residueStr.indexOf(',');
		let b = residueStr.slice(0, bIndex);
		residueStr = residueStr.slice(bIndex + 1);
		let aIndex = residueStr.indexOf(')');
		let a = residueStr.slice(0, aIndex);
		return {
			r: +r,
			g: +g,
			b: +b,
			a: +a,
		};
	} else {
		console.log('这不是个字符串');
	}
}
/**
 * 将rgba转为十六进制显示
 * @param color {String} rgba(0,0,0,1)
 * @returns string #ff4400
 */
export function rgbaToString(color) {
	var values = color
		.replace(/rgba?\(/, '')
		.replace(/\)/, '')
		.replace(/[\s+]/g, '')
		.split(',');
	var a = parseFloat(values[3] || 1),
		r = Math.floor(a * parseInt(values[0]) + (1 - a) * 255),
		g = Math.floor(a * parseInt(values[1]) + (1 - a) * 255),
		b = Math.floor(a * parseInt(values[2]) + (1 - a) * 255);
	return (
		'#' +
		('0' + r.toString(16)).slice(-2) +
		('0' + g.toString(16)).slice(-2) +
		('0' + b.toString(16)).slice(-2)
	);
}
