import {
	isNaN,
	isEqual,
	findIndex,
	chunk,
	drop,
	camelCase,
	endsWith,
	pick,
	words,
	compact,
	concat,
	difference,
	differenceBy,
	differenceWith,
	dropRight,
	dropRightWhile,
	dropWhile,
	fill,
	findLastIndex,
	head,
	flatten,
	flattenDeep,
	flattenDepth,
	fromPairs,
	indexOf,
	initial,
	intersection,
	intersectionBy,
	intersectionWith,
	join,
	last,
	lastIndexOf,
	nth,
	pull,
	pullAll,
	pullAllBy,
	pullAllWith,
	remove,
	reverse,
	slice,
	sortedIndex,
	sortedIndexBy,
	sortedIndexOf,
	sortedLastIndex,
	sortedLastIndexBy,
	sortedLastIndexOf,
	sortedUniq,
	sortedUniqBy,
	tail,
	take,
	takeRight,
	takeRightWhile,
	takeWhile,
	union,
	unionBy,
	unionWith,
	uniq,
	uniqBy,
	uniqWith,
	unzip,
	unzipWith,
	without,
	xor,
	xorBy,
	xorWith,
	zip,
	zipObject,
	zipObjectDeep,
	zipWith,
	countBy,
	forEach,
	forEachRight,
	every,
} from 'lodash';
import moment from 'moment';
import { openToast } from '../location/Notification';
import { showToast } from '../location/Toast';
// 图片引入
import Compatibility from '../assets/Compatibility.png';
import Compatibility2 from '../assets/Compatibility2.png';
import Dimensions from '../assets/Dimensions.png';
import Dimensions2 from '../assets/Dimensions2.png';
import Database from '../assets/Database.png';
import Database2 from '../assets/Database2.png';
import DateImg from '../assets/Date.png';
import DateImg2 from '../assets/Date2.png';
import Finance from '../assets/Finance.png';
import Finance2 from '../assets/Finance2.png';
import MessageImg from '../assets/Message.png';
import MessageImg2 from '../assets/Message2.png';
import Logic from '../assets/Logic.png';
import Logic2 from '../assets/Logic2.png';
import Find from '../assets/Find.png';
import Find2 from '../assets/Find2.png';
import MathImg from '../assets/Math.png';
import MathImg2 from '../assets/Math2.png';
import Statistics from '../assets/Statistics.png';
import Statistics2 from '../assets/Statistics2.png';
import TextImg from '../assets/Text.png';
import TextImg2 from '../assets/Text2.png';
import Project from '../assets/Project.png';
import Project2 from '../assets/Project2.png';
import Column from '../assets/Column.png';
import Column2 from '../assets/Column2.png';
import PieImg from '../assets/Pie.png';
import PieImg2 from '../assets/Pie2.png';
import Radar from '../assets/Radar.png';
import Radar2 from '../assets/Radar2.png';
import Bubble from '../assets/Bubble.png';
import Bubble2 from '../assets/Bubble2.png';
import Splashes from '../assets/Splashes.png';
import Splashes2 from '../assets/Splashes2.png';
import Dendrogram from '../assets/Dendrogram.png';
import Dendrogram2 from '../assets/Dendrogram2.png';
import Box from '../assets/Box.png';
import Box2 from '../assets/Box2.png';
import Rising from '../assets/Rising.png';
import Rising2 from '../assets/Rising2.png';
import Line from '../assets/Line.png';
import Line2 from '../assets/Line2.png';
import Straight from '../assets/Straight.png';
import Straight2 from '../assets/Straight2.png';
import ArrayPng from '../assets/Array.png';
import Array2Png from '../assets/Array2.png';
import NumberPng from '../assets/Number.png';
import Number2Png from '../assets/Number2.png';
import ObjectPng from '../assets/Object.png';
import Object2Png from '../assets/Object2.png';
import StringPng from '../assets/String.png';
import String2Png from '../assets/String2.png';
let isArray = Array.isArray;
/**
 * 函数集
 */
const List = [
	{
		name: '数组操作函数',
		images: ArrayPng,
		pitchImages: Array2Png,
		children: [
			{
				name: '数组合并数组', // 函数代表名
				funcName: '将传入2个数组进行合并,返回一个合并后数组', // 函数名字
				function: MERGEARRAY, // 当前函数
				callKey: 'MERGEARRAY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入合并数组', // 第一个参数代表含义
					},
					{
						text: '传入合并数组', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78], // 传入函数中的值
						text: '[23,98,78]', // 展示页面所用值
					},
					{
						value: [32, 51, 79], // 传入函数中的值
						text: '[32,51,79]', // 展示页面所用值
					},
				],
			},
			{
				name: '筛选非假值数组', // 函数代表名
				funcName:
					'创建一个新数组，包含原数组中所有的非假值元素。例如false, null, 0, "", undefined, 和 NaN 都是被认为是“假值”。', // 函数名字
				function: ArrayScreenFalse, // 当前函数
				callKey: 'ArrayScreenFalse',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要筛选数组', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78, false, ''], // 传入函数中的值
						text: '[23,98,78,false,""]', // 展示页面所用值
					},
				],
			},
			{
				name: '数组链接数组或值', // 函数代表名
				funcName: '创建一个新数组，将array与任何数组 或 值连接在一起。', // 函数名字
				function: ArrayConcatData, // 当前函数
				callKey: 'ArrayConcatData',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要连接数组', // 第一个参数代表含义
					},
					{
						text: '传入需要连接的数组或值',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78], // 传入函数中的值
						text: '[23,98,78]', // 展示页面所用值
					},
					{
						value: '8', // 传入函数中的值
						text: '8', // 展示页面所用值
					},
				],
			},
			{
				name: '排除数组指定值', // 函数代表名
				funcName:
					'创建一个新数组，这个数组中的值，为第一个数字（array 参数）排除了给定数组中的值。', // 函数名字
				function: ArrayDifference, // 当前函数
				callKey: 'ArrayDifference',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的数组。', // 第一个参数代表含义
					},
					{
						text: '排除的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [3, 2, 1], // 传入函数中的值
						text: '[3, 2, 1]', // 展示页面所用值
					},
					{
						value: [4, 2], // 传入函数中的值
						text: '[4, 2]', // 展示页面所用值
					},
				],
			},
			{
				name: '排除数组指定值(指定规则)', // 函数代表名
				funcName:
					'它接受一个 iteratee （注：迭代器）， 调用array 和 values 中的每个元素以产生比较的标准。 结果值是从第一数组中选择。', // 函数名字
				function: ArrayDifferenceBy, // 当前函数
				callKey: 'ArrayDifferenceBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的数组。', // 第一个参数代表含义
					},
					{
						text: '排除的值。',
					},
					{
						text: 'iteratee 调用每个元素。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 2 }, { x: 1 }], // 传入函数中的值
						text: '[{ x: 2 }, { x: 1 }]', // 展示页面所用值
					},
					{
						value: [{ x: 1 }], // 传入函数中的值
						text: '[{ x: 1 }]', // 展示页面所用值
					},
					{
						value: 'x',
						text: 'x', // 展示页面所用值
					},
				],
			},
			{
				name: '筛选数组中不相同的值', // 函数代表名
				funcName: '比较array，values中的元素。 结果值是从第一数组中选择。', // 函数名字
				function: ArrayDifferenceWith, // 当前函数
				callKey: 'ArrayDifferenceWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的数组。', // 第一个参数代表含义
					},
					{
						text: '排除的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 1, y: 2 }, { x: 2, y: 1 }], // 传入函数中的值
						text: "[{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]", // 展示页面所用值
					},
					{
						value: [{ x: 1, y: 2 }], // 传入函数中的值
						text: "[{ 'x': 1, 'y': 2 }]", // 展示页面所用值
					},
				],
			},
			{
				name: '数组指定切片', // 函数代表名
				funcName: '将传入数组按照传入长度进行切片,返回一个切片后数组', // 函数名字
				function: REMOVEARRAYDROP, // 当前函数
				callKey: 'REMOVEARRAYDROP',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要切片数组', // 第一个参数代表含义
					},
					{
						text: '传入切片长度', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78, 65, 32, 11, 12], // 传入函数中的值
						text: '[23,98,78,65,32,11,12]', // 展示页面所用值
					},
					{
						value: 2, // 传入函数中的值
						text: '2', // 展示页面所用值
					},
				],
			},
			{
				name: '数组从尾部指定切片', // 函数代表名
				funcName: '创建一个切片数组，去除array尾部的n个元素。（n默认值为1。）', // 函数名字
				function: ArrayDropRight, // 当前函数
				callKey: 'ArrayDropRight',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要查询的数组。', // 第一个参数代表含义
					},
					{
						text: '要去除的元素个数。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 3], // 传入函数中的值
						text: '[1, 2, 3]', // 展示页面所用值
					},
					{
						value: 2, // 传入函数中的值
						text: '2', // 展示页面所用值
					},
				],
			},
			{
				name: '数组从尾部指定规则切片', // 函数代表名
				funcName: '创建一个切片数组，从尾部去除array中从 predicate 返回假值开始到尾部的部分。', // 函数名字
				function: ArrayDropRightWhile, // 当前函数
				callKey: 'ArrayDropRightWhile',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要查询的数组。', // 第一个参数代表含义
					},
					{
						text: '筛选规则,这个函数会在每一次迭代调用。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', active: false },
							{ user: 'fred', active: true },
							{ user: 'pebbles', active: false },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney',  'active': true },
                            { 'user': 'fred',    'active': false },
                            { 'user': 'pebbles', 'active': false }
                          ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return !o.active;
						}, // 传入函数中的值
						text: `function(o) { return !o.active; }`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组指定规则切片', // 函数代表名
				funcName: '创建一个切片数组，去除array中从 predicate 返回假值开始到尾部的部分。', // 函数名字
				function: ArrayDropWhile, // 当前函数
				callKey: 'ArrayDropWhile',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要查询的数组。', // 第一个参数代表含义
					},
					{
						text: '筛选规则,这个函数会在每一次迭代调用。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', active: false },
							{ user: 'fred', active: true },
							{ user: 'pebbles', active: false },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney',  'active': true },
                            { 'user': 'fred',    'active': false },
                            { 'user': 'pebbles', 'active': false }
                          ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return !o.active;
						}, // 传入函数中的值
						text: `function(o) { return !o.active; }`, // 展示页面所用值
					},
				],
			},
			{
				name: '填充数组', // 函数代表名
				funcName:
					'使用 value 值来填充（替换） array，从start位置开始, 到end位置结束（但不包含end位置）。', // 函数名字
				function: ArrayFill, // 当前函数
				callKey: 'ArrayFill',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要填充改变的数组。', // 第一个参数代表含义
					},
					{
						text: '填充(替换)给 array 的值。', // 第二个参数代表含义
					},
					{
						text: '开始位置（默认0） 可不传',
					},
					{
						text: '结束位置(默认全部)  可不传',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 3], // 传入函数中的值
						text: `[1, 2, 3]`, // 展示页面所用值
					},
					{
						value: 'a', // 传入函数中的值
						text: 'a', // 展示页面所用值
					},
				],
			},
			{
				name: '数组指定查找,返回下标', // 函数代表名
				funcName:
					'该方法返回第一个通过 predicate 判断为真值的元素的索引值（index），而不是元素本身。', // 函数名字
				function: ArrayFindIndex, // 当前函数
				callKey: 'ArrayFindIndex',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要搜索的数组。', // 第一个参数代表含义
					},
					{
						text: '这个函数会在每一次迭代调用。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'fred', active: false },
							{ user: 'barney', active: false },
							{ user: 'pebbles', active: true },
						], // 传入函数中的值
						text: `[
                            { 'user': 'fred',    'active': false },
                            { 'user': 'barney',  'active': false },
                            { 'user': 'pebbles', 'active': true }
                        ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return o.user == 'barney';
						}, // 传入函数中的值
						text: "function(o) { return o.user == 'barney'; }", // 展示页面所用值
					},
				],
			},
			{
				name: '数组从末尾指定查找,返回下标', // 函数代表名
				funcName:
					'该方法从末尾查询返回第一个通过 predicate 判断为真值的元素的索引值（index），而不是元素本身。', // 函数名字
				function: ArrayFindLastIndex, // 当前函数
				callKey: 'ArrayFindLastIndex',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要搜索的数组。', // 第一个参数代表含义
					},
					{
						text: '这个函数会在每一次迭代调用。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', active: true },
							{ user: 'fred', active: false },
							{ user: 'pebbles', active: false },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney',  'active': true },
                            { 'user': 'fred',    'active': false },
                            { 'user': 'pebbles', 'active': false }
                            ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return o.user == 'pebbles';
						}, // 传入函数中的值
						text: "function(o) { return o.user == 'pebbles'}", // 展示页面所用值
					},
				],
			},
			{
				name: '数组首数据获取,返回下标', // 函数代表名
				funcName: '获取数组 array 的第一个元素。', // 函数名字
				function: ArrayHead, // 当前函数
				callKey: 'ArrayHead',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要查询的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 3], // 传入函数中的值
						text: `[1, 2, 3]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组嵌套深度减少一级', // 函数代表名
				funcName: '减少一级array嵌套深度。', // 函数名字
				function: ArrayFlatten, // 当前函数
				callKey: 'ArrayFlatten',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 需要减少嵌套层级的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, [[3], [4], [5]]], // 传入函数中的值
						text: `[1, 2, [[3],[4],[5]]]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组嵌套深度指定减少', // 函数代表名
				funcName: '减少指定层级array嵌套深度。', // 函数名字
				function: ArrayFlattenDepth, // 当前函数
				callKey: 'ArrayFlattenDepth',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 需要减少嵌套层级的数组。', // 第一个参数代表含义
					},
					{
						text: '2',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, [[3], [4], [5]]], // 传入函数中的值
						text: `[1, 2, [[3],[4],[5]]]`, // 展示页面所用值
					},
					{
						value: 2,
						text: 2,
					},
				],
			},
			{
				name: '数组清除嵌套深度', // 函数代表名
				funcName: '将array递归为一维数组。', // 函数名字
				function: ArrayFlattenDeep, // 当前函数
				callKey: 'ArrayFlattenDeep',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 需要处理嵌套的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [[1], [2], [[3, 6], [4], [5]]], // 传入函数中的值
						text: `[[1], [2], [[3,6],[4],[5]]]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组pairs格式化为对象', // 函数代表名
				funcName: '将数组pairs格式化为对象', // 函数名字
				function: ArrayFromPairs, // 当前函数
				callKey: 'ArrayFromPairs',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 键值对pairs。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [['fred', 30], ['barney', 40]], // 传入函数中的值
						text: `[['fred', 30], ['barney', 40]]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组查找', // 函数代表名
				funcName:
					'返回首次 value 在数组array中被找到的 索引值， 如果 fromIndex 为负值，将从数组array尾端索引进行匹配。', // 函数名字
				function: ArrayIndexOf, // 当前函数
				callKey: 'ArrayIndexOf',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '  需要查找的数组。', // 第一个参数代表含义
					},
					{
						text: '需要查找的值。',
					},
					{
						text: '开始查询的位置。 可不传',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 1, 2], // 传入函数中的值
						text: `[1, 2, 1, 2]`, // 展示页面所用值
					},
					{
						value: 2,
						text: 2,
					},
				],
			},
			{
				name: '数组删除最后一个元素', // 函数代表名
				funcName:
					'获取数组array中除了最后一个元素之外的所有元素（注：去除数组array中的最后一个元素）。', // 函数名字
				function: ArrayInitial, // 当前函数
				callKey: 'ArrayInitial',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '  需要查找的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 1, 2], // 传入函数中的值
						text: `[1, 2, 1, 2]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组相同对比', // 函数代表名
				funcName: '创建唯一值的数组，这个数组包含所有给定数组都包含的元素，', // 函数名字
				function: ArrayIntersection, // 当前函数
				callKey: 'ArrayIntersection',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '  待检查的数组', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [[2, 1], [4, 2], [1, 2]], // 传入函数中的值
						text: `[[2, 1], [4, 2], [1, 2]]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组指定规则做相同对比', // 函数代表名
				funcName:
					'它接受一个 iteratee 调用每一个arrays的每个值以产生一个值，通过产生的值进行了比较。结果值是从第一数组中选择。', // 函数名字
				function: ArrayIntersectionBy, // 当前函数
				callKey: 'ArrayIntersectionBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '  待检查的数组', // 第一个参数代表含义
					},
					{
						text: 'iteratee（迭代器）调用每个元素。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [[{ x: 1 }], [{ x: 2 }, { x: 1 }]], // 传入函数中的值
						text: `[[{ x: 1 }], [{ x: 2 }, { x: 1 }]]`, // 展示页面所用值
					},
					{
						value: 'x',
						text: 'x',
					},
				],
			},
			{
				name: '数组按照指定格式转换字符串', // 函数代表名
				funcName: '将 array 中的所有元素转换为由 separator 分隔的字符串。', // 函数名字
				function: ArrayJoin, // 当前函数
				callKey: 'ArrayJoin',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '待转换的数组', // 第一个参数代表含义
					},
					{
						text: '分隔元素',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['a', 'b', 'c'], // 传入函数中的值
						text: `['a', 'b', 'c']`, // 展示页面所用值
					},
					{
						value: '~',
						text: '~',
					},
				],
			},
			{
				name: '数组获取最后一个参数', // 函数代表名
				funcName: '获取array中的最后一个元素。', // 函数名字
				function: ArrayLast, // 当前函数
				callKey: 'ArrayLast',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '待检索的数组', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['a', 'b', 'c'], // 传入函数中的值
						text: `['a', 'b', 'c']`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组反向查找', // 函数代表名
				funcName: '它是从右到左遍历array的元素。返回查找到的元素', // 函数名字
				function: ArrayLastIndexOf, // 当前函数
				callKey: 'ArrayLastIndexOf',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '待检索的数组', // 第一个参数代表含义
					},
					{
						text: '要搜索的值。',
					},
					{
						text: '开始搜索的索引值。(默认最后位) 可不传',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 1, 2], // 传入函数中的值
						text: `[1, 2, 1, 2]`, // 展示页面所用值
					},
					{
						value: 1,
						text: 1,
					},
				],
			},
			{
				name: '数组获取指定参数', // 函数代表名
				funcName: '获取array数组的第n个元素。如果n为负数，则返回从数组结尾开始的第n个元素。', // 函数名字
				function: ArrayNth, // 当前函数
				callKey: 'ArrayNth',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要查询的数组。', // 第一个参数代表含义
					},
					{
						text: '要返回元素的索引值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 3, 1, 2], // 传入函数中的值
						text: `[1, 3, 1, 2]`, // 展示页面所用值
					},
					{
						value: 1,
						text: 1,
					},
				],
			},
			{
				name: '数组删除指定元素', // 函数代表名
				funcName:
					'移除数组array中所有和给定值相等的元素，使用 SameValueZero 进行全等比较。 会修改传入数组', // 函数名字
				function: ArrayPull, // 当前函数
				callKey: 'ArrayPull',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要修改的数组。', // 第一个参数代表含义
					},
					{
						text: '需要删除的值 可多个',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [3, 53, 87, 2], // 传入函数中的值
						text: `[3, 53, 87, 2]`, // 展示页面所用值
					},
					{
						value: 2,
						text: 2,
					},
				],
			},
			{
				name: '数组删除指定元素(删除值为数组包裹)',
				funcName:
					'移除数组array中所有和给定值相等的元素，使用 SameValueZero 进行全等比较。区别是这个方法接收一个要移除值的数组。 会修改传入数组', // 函数名字
				function: ArrayPullAll, // 当前函数
				callKey: 'ArrayPullAll',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要修改的数组。', // 第一个参数代表含义
					},
					{
						text: '需要删除的值数组',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [3, 53, 87, 2], // 传入函数中的值
						text: `[3, 53, 87, 2]`, // 展示页面所用值
					},
					{
						value: [2, 53],
						text: '[2,53]',
					},
				],
			},
			{
				name: '数组删除指定元素(支持对象)', // 函数代表名
				funcName:
					'这个方法接受一个 iteratee（迭代函数） 调用 array 和 values的每个值以产生一个值，通过产生的值进行了比较。 会修改传入数组', // 函数名字
				function: ArrayPullAllBy, // 当前函数
				callKey: 'ArrayPullAllBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要修改的数组。', // 第一个参数代表含义
					},
					{
						text: '要移除值的数组。',
					},
					{
						text: 'iteratee（迭代器）调用每个元素。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 1 }, { x: 2 }, { x: 3 }, { y: 1 }], // 传入函数中的值
						text: `[{ 'x': 1 }, { 'x': 2 }, { 'x': 3 }, { 'y': 1 }];`, // 展示页面所用值
					},
					{
						value: [{ x: 3 }, { y: 1 }],
						text: `[{'x':3},{'y':1}]`,
					},
					{
						value: 'x',
						text: 'x',
					},
				],
			},
			{
				name: '数组删除指定元素(支持对象,且不需要迭代器)', // 函数代表名
				funcName:
					'调用 array 和 values的每个值以产生一个值，通过产生的值进行了比较。 会修改传入数组', // 函数名字
				function: ArrayPullAllWith, // 当前函数
				callKey: 'ArrayPullAllWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要修改的数组。', // 第一个参数代表含义
					},
					{
						text: '要移除值的数组。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 1 }, { x: 2 }, { x: 3 }, { y: 1 }], // 传入函数中的值
						text: `[{ 'x': 1 }, { 'x': 2 }, { 'x': 3 }, { 'y': 1 }];`, // 展示页面所用值
					},
					{
						value: [{ x: 3 }, { y: 1 }],
						text: `[{'x':3},{'y':1}]`,
					},
				],
			},
			{
				name: '数组移除指定下标数据', // 函数代表名
				funcName: '根据索引 indexes，移除array中对应的元素，并返回被移除元素的数组。', // 函数名字
				function: ArrayPullAt, // 当前函数
				callKey: 'ArrayPullAt',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要修改的数组。', // 第一个参数代表含义
					},
					{
						text: '要移除元素的索引。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [5, 10, 15, 20], // 传入函数中的值
						text: `[5, 10, 15, 20]`, // 展示页面所用值
					},
					{
						value: 1,
						text: 1,
					},
				],
			},
			{
				name: '数组指定规则删除元素', // 函数代表名
				funcName: '移除数组中predicate（断言）返回为真值的所有元素，并返回移除元素组成的数组。', // 函数名字
				function: ArrayRemove, // 当前函数
				callKey: 'ArrayRemove',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要修改的数组。', // 第一个参数代表含义
					},
					{
						text: ' 每次迭代调用的函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 3, 4, 5, 6], // 传入函数中的值
						text: `[1, 2, 3, 4,5,6]`, // 展示页面所用值
					},
					{
						value: function(n) {
							return n % 2 == 0;
						},
						text: `function(n) {
                            return n % 2 == 0;
                            }`,
					},
				],
			},
			{
				name: '数组反转', // 函数代表名
				funcName:
					'反转array，使得第一个元素变为最后一个元素，第二个元素变为倒数第二个元素，依次类推。返回新数组', // 函数名字
				function: ArrayReverse, // 当前函数
				callKey: 'ArrayReverse',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要修改的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 3, 4], // 传入函数中的值
						text: `[1, 2, 3, 4]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组指定裁剪', // 函数代表名
				funcName: '裁剪数组array，从 start 位置开始到end结束，但不包括 end 本身的位置。', // 函数名字
				function: ArraySlice, // 当前函数
				callKey: 'ArraySlice',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要裁剪数组。', // 第一个参数代表含义
					},
					{
						text: '开始位置。(默认为0)',
					},
					{
						text: '结束位置。(默认为最后)',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2, 3, 4], // 传入函数中的值
						text: `[1, 2, 3, 4]`, // 展示页面所用值
					},
					{
						value: 0,
						text: 0,
					},
					{
						value: 2,
						text: 2,
					},
				],
			},
			{
				name: '数组插入值判定', // 函数代表名
				funcName:
					'使用二进制的方式检索来决定 value值 应该插入到数组中 尽可能小的索引位置，以保证array的排序。', // 函数名字
				function: ArraySortedIndex, // 当前函数
				callKey: 'ArraySortedIndex',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的排序数组。', // 第一个参数代表含义
					},
					{
						text: '要评估的值',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 20, 30, 40], // 传入函数中的值
						text: `[10, 20, 30, 40]`, // 展示页面所用值
					},
					{
						value: 22,
						text: 22,
					},
				],
			},
			{
				name: '数组指定迭代器插入值判断', // 函数代表名
				funcName:
					'它接受一个 iteratee （迭代函数），调用每一个数组（array）元素，返回结果和value 值比较来计算排序', // 函数名字
				function: ArraySortedIndexBy, // 当前函数
				callKey: 'ArraySortedIndexBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的排序数组。', // 第一个参数代表含义
					},
					{
						text: '要评估的值。',
					},
					{
						text: '迭代函数，调用每个元素。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 4 }, { x: 6 }], // 传入函数中的值
						text: `[{ 'x': 4 }, { 'x': 6 }]`, // 展示页面所用值
					},
					{
						value: { x: 5 },
						text: `{ 'x': 5 }`,
					},
					{
						value: function(o) {
							return o.x;
						},
						text: `function(o) { return o.x; }`,
					},
				],
			},
			{
				name: '排序数组二进制查找', // 函数代表名
				funcName:
					'这个方法类似 indexOf，除了它是在已经排序的数组array上执行二进制检索。不存在返回-1', // 函数名字
				function: ArraySortedIndexOf, // 当前函数
				callKey: 'ArraySortedIndexOf',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要搜索的数组。', // 第一个参数代表含义
					},
					{
						text: '搜索的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 20, 30, 40], // 传入函数中的值
						text: `[10, 20, 30, 40]`, // 展示页面所用值
					},
					{
						value: 20,
						text: 20,
					},
				],
			},
			{
				name: '排序数组查找最后一次出现索引',
				funcName: '它返回 value值 在 array 中尽可能大的索引位置（index）。不存在返回-1', // 函数名字
				function: ArraySortedLastIndex, // 当前函数
				callKey: 'ArraySortedLastIndex',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要搜索的数组。', // 第一个参数代表含义
					},
					{
						text: '搜索的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 20, 20, 30, 40], // 传入函数中的值
						text: `[10, 20, 20, 30, 40]`, // 展示页面所用值
					},
					{
						value: 20,
						text: 20,
					},
				],
			},
			{
				name: '排序数组反向指定规则插入',
				funcName:
					'它接受一个 iteratee （迭代函数），调用每一个数组（array）元素，返回结果和value 值比较来计算排序。返回因插入的下标', // 函数名字
				function: ArraySortedLastIndexBy, // 当前函数
				callKey: 'ArraySortedLastIndexBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的排序数组。', // 第一个参数代表含义
					},
					{
						text: '要评估的值。',
					},
					{
						text: '迭代函数，调用每个元素',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 4 }, { x: 5 }], // 传入函数中的值
						text: `[{ 'x': 4 }, { 'x': 5 }]`, // 展示页面所用值
					},
					{
						value: { x: 4.5 },
						text: `{ 'x': 4.5 }`,
					},
					{
						value: function(o) {
							return o.x;
						},
						text: `function(o) { return o.x; }`,
					},
				],
			},
			{
				name: '排序数组反向二进制查找',
				funcName: '它是在已经排序的数组array上执行反向二进制检索。不存在返回-1', // 函数名字
				function: ArraySortedLastIndexOf, // 当前函数
				callKey: 'ArraySortedLastIndexOf',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要搜索的数组。', // 第一个参数代表含义
					},
					{
						text: '搜索的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 20, 20, 30, 40], // 传入函数中的值
						text: `[10, 20, 20, 30, 40]`, // 展示页面所用值
					},
					{
						value: 20,
						text: 20,
					},
				],
			},
			{
				name: '数组去重',
				funcName: '它会优化排序数组,返回一个不重复数组', // 函数名字
				function: ArraySortedUniq, // 当前函数
				callKey: 'ArraySortedUniq',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要搜索的数组。', // 第一个参数代表含义
					},
					{
						text: '搜索的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 10, 20, 20, 30, 30, 40, 40], // 传入函数中的值
						text: `[10, 10, 20, 20, 30, 30, 40, 40]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组去重(指定规则)',
				funcName: '它会根据指定规则优化排序数组。,返回一个不重复数组', // 函数名字
				function: ArraySortedUniqBy, // 当前函数
				callKey: 'ArraySortedUniqBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的数组。', // 第一个参数代表含义
					},
					{
						text: '迭代函数，调用每个元素。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1.1, 1.2, 2.3, 2.4], // 传入函数中的值
						text: `[1.1, 1.2, 2.3, 2.4]`, // 展示页面所用值
					},
					{
						value: Math.floor,
						text: 'Math.floor',
					},
				],
			},
			{
				name: '数组(除第一个数据)数据获取',
				funcName: '获取除了array数组第一个元素以外的全部元素。', // 函数名字
				function: ArrayTail, // 当前函数
				callKey: 'ArrayTail',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 10, 20, 20, 30, 30, 40, 40], // 传入函数中的值
						text: `[10, 10, 20, 20, 30, 30, 40, 40]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组指定数量元素提取',
				funcName: '创建一个数组切片，从array数组的起始元素开始提取n个元素。', // 函数名字
				function: ArrayTake, // 当前函数
				callKey: 'ArrayTake',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检索的数组', // 第一个参数代表含义
					},
					{
						text: '要提取的元素个数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 10, 20, 20, 30, 30, 40, 40], // 传入函数中的值
						text: `[10, 10, 20, 20, 30, 30, 40, 40]`, // 展示页面所用值
					},
					{
						value: 5,
						text: 5,
					},
				],
			},
			{
				name: '数组(从最后开始)指定数量元素提取',
				funcName: '创建一个数组切片，从array数组的最后一个元素开始提取n个元素。', // 函数名字
				function: ArrayTakeRight, // 当前函数
				callKey: 'ArrayTakeRight',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组。', // 第一个参数代表含义
					},
					{
						text: '要提取的元素个数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 10, 20, 20, 30, 30, 40, 40], // 传入函数中的值
						text: `[10, 10, 20, 20, 30, 30, 40, 40]`, // 展示页面所用值
					},
					{
						value: 5,
						text: 5,
					},
				],
			},
			{
				name: '数组指定规则元素提取',
				funcName: '从array数组的起始元素开始提取元素，直到 规则 返回假值。', // 函数名字
				function: ArrayTakeWhile, // 当前函数
				callKey: 'ArrayTakeWhile',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检索的数组。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', active: true },
							{ user: 'fred', active: false },
							{ user: 'pebbles', active: false },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney',  'active': true },
                            { 'user': 'fred',    'active': false },
                            { 'user': 'pebbles', 'active': false }
                          ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return o.active;
						},
						text: `function(o) { return o.active; }`,
					},
				],
			},
			{
				name: '数组(从最后开始)指定规则元素提取',
				funcName: '从array数组的最后一个元素开始提取元素，直到规则返回假值。', // 函数名字
				function: ArrayTakeRightWhile, // 当前函数
				callKey: 'ArrayTakeRightWhile',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检索的数组。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', active: true },
							{ user: 'fred', active: false },
							{ user: 'pebbles', active: false },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney',  'active': true },
                            { 'user': 'fred',    'active': false },
                            { 'user': 'pebbles', 'active': false }
                          ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return !o.active;
						},
						text: `function(o) { return !o.active; }`,
					},
				],
			},
			{
				name: '多个数组去重合并',
				funcName: '创建一个按顺序排列的唯一值的数组。所有给定数组的元素值做等值比较。', // 函数名字
				function: ArrayUnion, // 当前函数
				callKey: 'ArrayUnion',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组。可传多个', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [10, 10, 20, 20, 30, 30, 40, 40], // 传入函数中的值
						text: `[10, 10, 20, 20, 30, 30, 40, 40]`, // 展示页面所用值
					},
					{
						value: [10, 25, 30, 35, 40, 45],
						text: `[10,25,30,35,40,45]`,
					},
					{
						value: [10, 25, 30, 35, 40, 45],
						text: `[10,25,30,35,40,45]`,
					},
				],
			},
			{
				name: '多个数组按照规则去重合并(支持对象)',
				funcName:
					'它接受一个 iteratee （迭代函数），调用每一个数组（array）的每个元素以产生唯一性计算的标准。', // 函数名字
				function: ArrayUnionBy, // 当前函数
				callKey: 'ArrayUnionBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 需要合并的数组组,', // 第一个参数代表含义
					},
					{
						text: '迭代函数，调用每个元素。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [[{ x: 1 }], [{ x: 2 }, { x: 1 }]], // 传入函数中的值
						text: `[[{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }]]`, // 展示页面所用值
					},
					{
						value: 'x',
						text: `x`,
					},
				],
			},
			{
				name: '多个数组去重合并(支持对象)',
				funcName: '它接受一个 comparator 调用比较arrays数组的每一个元素。 ', // 函数名字
				function: ArrayUnionWith, // 当前函数
				callKey: 'ArrayUnionWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 需要合并的数组,', // 第一个参数代表含义
					},
					{
						text: ' 需要合并的数组,', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 1, y: 2 }, { x: 3, y: 1 }], // 传入函数中的值
						text: `[{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]`, // 展示页面所用值
					},
					{
						value: [{ x: 1, y: 2 }, { x: 2, y: 1 }],
						text: `[{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]`,
					},
				],
			},
			{
				name: '数组去重(简版)',
				funcName: '创建一个去重后的array数组副本。只有第一次出现的元素才会被保留。', // 函数名字
				function: ArrayUniq, // 当前函数
				callKey: 'ArrayUniq',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组。,', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [2, 1, 2], // 传入函数中的值
						text: `[2, 1, 2]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组对象自动去重',
				funcName: '它接受一个 comparator 调用比较arrays数组的每一个元素', // 函数名字
				function: ArrayUniqWith, // 当前函数
				callKey: 'ArrayUniqWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 1, y: 2 }, { x: 2, y: 1 }, { x: 1, y: 2 }], // 传入函数中的值
						text: `[{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 2 }]`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组重组',
				funcName:
					'它接收分组元素的数组，并且创建一个数组，分组元素到打包前的结构。返回数组的第一个元素包含所有的输入数组的第一元素，第一个元素包含了所有的输入数组的第二元素，依此类推。）', // 函数名字
				function: ArrayUnzip, // 当前函数
				callKey: 'ArrayUnzip',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要重组的数组。', // 第一个参数代表含义
					},
					{
						text: ' 要重组的数组。', // 第一个参数代表含义
					},
					{
						text: ' 要重组的数组。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['fred', 'barney'], // 传入函数中的值
						text: `['fred', 'barney']`, // 展示页面所用值
					},
					{
						value: [30, 40],
						text: `[30, 40]`,
					},
					{
						value: [true, false],
						text: `[true, false]`,
					},
				],
			},
			{
				name: '数组指定规则重组',
				funcName: '它接受一个iteratee指定重组值应该如何被组合。', // 函数名字
				function: ArrayUnzipWidth, // 当前函数
				callKey: 'ArrayUnzipWidth',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要处理的分组元素数组。', // 第一个参数代表含义
					},
					{
						text: '这个函数用来组合重组的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [[1, 10, 100], [2, 20, 200]], // 传入函数中的值
						text: `[[1, 10, 100], [2, 20, 200]]`, // 展示页面所用值
					},
					{
						value: function(num, num1) {
							return num + num1;
						},
						text: `function(num,num1) {
                            return num+num1
                        }`,
					},
				],
			},
			{
				name: '数组剔除指定参数',
				funcName: '创建一个剔除所有给定值的新数组', // 函数名字
				function: ArrayWithout, // 当前函数
				callKey: 'ArrayWithout',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组。', // 第一个参数代表含义
					},
					{
						text: '要剔除的值。 可多个',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [2, 1, 2, 3], // 传入函数中的值
						text: `[2, 1, 2, 3]`, // 展示页面所用值
					},
					{
						value: 1,
						text: 1,
					},
					{
						value: 2,
						text: 2,
					},
				],
			},
			{
				name: '数组过滤',
				funcName:
					'创建一个给定数组唯一值的数组，返回值的顺序取决于他们数组的出现顺序,返回过滤后的新数组', // 函数名字
				function: ArrayXor, // 当前函数
				callKey: 'ArrayXor',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要过滤的数组。', // 第一个参数代表含义
					},
					{
						text: '要过滤的数组。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [2, 1], // 传入函数中的值
						text: `[2, 1]`, // 展示页面所用值
					},
					{
						value: [2, 3],
						text: `[2, 3]`,
					},
					{
						value: [3, 4],
						text: `[3, 4]`,
					},
				],
			},
			{
				name: '数组指定规则过滤',
				funcName:
					'它接受 迭代器，这个迭代器 调用每一个 arrays（数组）的每一个值，以生成比较的新值。', // 函数名字
				function: ArrayXorBy, // 当前函数
				callKey: 'ArrayXorBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组组。', // 第一个参数代表含义
					},
					{
						text: ' 调用每一个元素的迭代函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [[{ x: 1 }], [{ x: 2 }, { x: 1 }]], // 传入函数中的值
						text: `[[{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }]]`, // 展示页面所用值
					},
					{
						value: 'x',
						text: `x`,
					},
				],
			},
			{
				name: '数组过滤(支持对象)',
				funcName: '接收对象进行相同筛选，以调用比较数组的元素。', // 函数名字
				function: ArrayXorBy, // 当前函数
				callKey: 'ArrayXorBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: ' 要检查的数组组。', // 第一个参数代表含义
					},
					{
						text: ' 调用每一个元素的迭代函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ x: 1, y: 2 }, { x: 2, y: 1 }], // 传入函数中的值
						text: `[{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]`, // 展示页面所用值
					},
					{
						value: 'x',
						text: `x`,
					},
				],
			},
			{
				name: '多数组合并',
				funcName:
					'创建一个分组元素的数组，数组的第一个元素包含所有给定数组的第一个元素，数组的第二个元素包含所有给定数组的第二个元', // 函数名字
				function: ArrayZip, // 当前函数
				callKey: 'ArrayZip',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要处理的数组。传多个', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['fred', 'barney'], // 传入函数中的值
						text: `['fred', 'barney']`, // 展示页面所用值
					},
					{
						value: [30, 40],
						text: `[30, 40]`,
					},
					{
						value: [true, false],
						text: `[true, false]`,
					},
				],
			},
			{
				name: '数组合并为对象',
				funcName:
					'它接受2个数组，第一个数组中的值作为属性标识符（属性名），第二个数组中的值作为相应的属性值。', // 函数名字
				function: ArrayZipObject, // 当前函数
				callKey: 'ArrayZipObject',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '作为对象标识符数组', // 第一个参数代表含义
					},
					{
						text: '作为属性值数组',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['name', 'age', 'year'], // 传入函数中的值
						text: `['name', 'age', 'year']`, // 展示页面所用值
					},
					{
						value: ['张三', 18, 2018],
						text: `['张三', 18, 2018]`,
					},
				],
			},
			{
				name: '数组合并为指定路径对象',
				funcName:
					'它支持属性路径接受2个数组，第一个数组中的值作为属性标识符（属性名），第二个数组中的值作为相应的属性值。', // 函数名字
				function: ArrayZipObjectDeep, // 当前函数
				callKey: 'ArrayZipObjectDeep',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '作为对象标识符数组', // 第一个参数代表含义
					},
					{
						text: '作为属性值数组',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['a.b[0].c', 'a.b[1].d'], // 传入函数中的值
						text: `['a.b[0].c', 'a.b[1].d']`, // 展示页面所用值
					},
					{
						value: [1, 2],
						text: `[1, 2]`,
					},
				],
			},
			{
				name: '数组指定规则合成',
				funcName:
					'它接受一个 iteratee（迭代函数），来 指定分组的值应该如何被组合。 该iteratee调用每个组的元素', // 函数名字
				function: ArrayZipWith, // 当前函数
				callKey: 'ArrayZipWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要处理的数组组。', // 第一个参数代表含义
					},
					{
						text: '函数用来组合分组的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [[1, 2], [10, 20], [100, 200], [40, 60]], // 传入函数中的值
						text: `[[1, 2], [10, 20], [100, 200],[40,60]]`, // 展示页面所用值
					},
					{
						value: function(...ary) {
							let num = 0;
							ary.map((item) => {
								num += item;
							});
							return num;
						},
						text: `function(...ary) {
                            let num = 0
                            ary.map(item=>{
                                num+=item
                            })
                            return num
                          }`,
					},
				],
			},
		],
	},
	{
		name: '集合操作函数',
		images: ObjectPng,
		pitchImages: Object2Png,
		children: [
			{
				name: '集合指定规则生成对象', // 函数代表名
				funcName:
					'创建一个组成对象，key（键）是经过 iteratee（迭代函数） 执行处理collection中每个元素后返回的结果，每个key（键）对应的值是 iteratee（迭代函数）返回该key（键）的次数', // 函数名字
				function: CollectCountBy, // 当前函数
				callKey: 'CollectCountBy',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的数组。', // 第一个参数代表含义
					},
					{
						text: '一个迭代函数', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['one', 'two', 'three'], // 传入函数中的值
						text: `['one', 'two', 'three']`, // 展示页面所用值
					},
					{
						value: 'length', // 传入函数中的值
						text: 'length', // 展示页面所用值
					},
				],
			},
			{
				name: '集合制定规则遍历', // 函数代表名
				funcName:
					'调用 iteratee 遍历 collection(集合) 中的每个元素，如果迭代函数（iteratee）显式的返回 false ，迭代会提前退出。', // 函数名字
				function: CollectForEach, // 当前函数
				callKey: 'CollectForEach',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '函数用来组合分组的值。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { a: 1, b: 2 }, // 传入函数中的值
						text: `{ 'a': 1, 'b': 2 }`, // 展示页面所用值
					},
					{
						value: function(value, key) {
							console.log(value, key);
						}, // 传入函数中的值
						text: `function(value, key) {
                            console.log(value,key);
                            }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合制定规则反向遍历', // 函数代表名
				funcName:
					'调用 iteratee 反方向遍历 collection(集合) 中的每个元素，如果迭代函数（iteratee）显式的返回 false ，迭代会提前退出。', // 函数名字
				function: CollectForEachRight, // 当前函数
				callKey: 'CollectForEachRight',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '函数用来组合分组的值。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { a: 1, b: 2 }, // 传入函数中的值
						text: `{ 'a': 1, 'b': 2 }`, // 展示页面所用值
					},
					{
						value: function(value, key) {
							console.log(value, key);
						}, // 传入函数中的值
						text: `function(value, key) {
                            console.log(value,key);
                            }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合指定规则断言', // 函数代表名
				funcName:
					'通过 predicate（断言函数） 检查 collection（集合）中的 所有 元素是否都返回真值。一旦 predicate（断言函数） 返回假值，迭代就马上停止。', // 函数名字
				function: CollectEvery, // 当前函数
				callKey: 'CollectEvery',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '函数用来组合分组的值。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', age: 36, active: false },
							{ user: 'fred', age: 40, active: false },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney', 'age': 36, 'active': false },
                            { 'user': 'fred',   'age': 40, 'active': false }
                            ]`, // 展示页面所用值
					},
					{
						value: { user: 'barney', active: false }, // 传入函数中的值
						text: `{ 'user': 'barney', 'active': false }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合指定规则筛选', // 函数代表名
				funcName:
					'遍历 collection（集合）元素，返回 predicate（断言函数）返回真值 的所有元素的数组。', // 函数名字
				function: CollectFilter, // 当前函数
				callKey: 'CollectFilter',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', age: 36, active: true },
							{ user: 'fred', age: 40, active: false },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney', 'age': 36, 'active': true },
                            { 'user': 'fred',   'age': 40, 'active': false }
                        ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return !o.active;
						}, // 传入函数中的值
						text: `function(o) { return !o.active; }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合指定规则筛选第一个符合对象', // 函数代表名
				funcName:
					'遍历 collection（集合）元素，返回 predicate（断言函数）第一个返回真值的第一个元素。', // 函数名字
				function: CollectFind, // 当前函数
				callKey: 'CollectFind',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。', // 第二个参数代表含义
					},
					{
						text: '开始搜索的索引位置。不传为从头开始',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', age: 36, active: true },
							{ user: 'fred', age: 40, active: false },
							{ user: 'pebbles', age: 1, active: true },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney',  'age': 36, 'active': true },
                            { 'user': 'fred',    'age': 40, 'active': false },
                            { 'user': 'pebbles', 'age': 1,  'active': true }
                          ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return o.age < 30;
						}, // 传入函数中的值
						text: `function(o) { return o.age < 30; }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合指定规则筛选从右至左第一个符合对象', // 函数代表名
				funcName:
					'遍历 collection（集合）元素，从右至左返回 predicate（断言函数）第一个返回真值的第一个元素。', // 函数名字
				function: CollectFindLast, // 当前函数
				callKey: 'CollectFindLast',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。', // 第二个参数代表含义
					},
					{
						text: '开始搜索的索引位置。不传为从右至左开始',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ user: 'barney', age: 36, active: true },
							{ user: 'fred', age: 40, active: false },
							{ user: 'pebbles', age: 1, active: true },
						], // 传入函数中的值
						text: `[
                            { 'user': 'barney',  'age': 36, 'active': true },
                            { 'user': 'fred',    'age': 40, 'active': false },
                            { 'user': 'pebbles', 'age': 1,  'active': true }
                          ]`, // 展示页面所用值
					},
					{
						value: function(o) {
							return o.age < 30;
						}, // 传入函数中的值
						text: `function(o) { return o.age < 30; }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合进行一层扁平化合并', // 函数代表名
				funcName:
					'创建一个扁平化（注：同阶数组）的数组，这个数组的值来自collection（集合）中的每一个值经过 iteratee（迭代函数） 处理后返回的结果，并且扁平化合并。', // 函数名字
				function: CollectFlatMap, // 当前函数
				callKey: 'CollectFlatMap',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2], // 传入函数中的值
						text: `[1, 2]`, // 展示页面所用值
					},
					{
						value: function duplicate(n) {
							return [n, n];
						}, // 传入函数中的值
						text: `function duplicate(n) {
                            return [n, n];
                          }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合进行多层扁平化合并', // 函数代表名
				funcName:
					'创建一个扁平化（注：同阶数组）的数组，这个数组的值来自collection（集合）中的每一个值经过 iteratee（迭代函数） 处理后返回的结果，并且多层扁平化合并。', // 函数名字
				function: CollectFlatMapDeep, // 当前函数
				callKey: 'CollectFlatMapDeep',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2], // 传入函数中的值
						text: `[1, 2]`, // 展示页面所用值
					},
					{
						value: function duplicate(n) {
							return [[[n, n]]];
						}, // 传入函数中的值
						text: `function duplicate(n) {
                            return [[[n, n]]];
                          }`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合指定层数扁平化合并', // 函数代表名
				funcName:
					'创建一个扁平化（注：同阶数组）的数组，这个数组的值来自collection（集合）中的每一个值经过 iteratee（迭代函数） 处理后返回的结果，并且根据指定的 depth（递归深度）继续扁平化递归映射结果', // 函数名字
				function: CollectFlatMapDepth, // 当前函数
				callKey: 'CollectFlatMapDepth',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '一个用来迭代的集合。', // 第一个参数代表含义
					},
					{
						text: '每次迭代调用的函数。', // 第二个参数代表含义
					},
					{
						text: '最大递归深度。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [1, 2], // 传入函数中的值
						text: `[1, 2]`, // 展示页面所用值
					},
					{
						value: function duplicate(n) {
							return [[[n, n]]];
						}, // 传入函数中的值
						text: `function duplicate(n) {
                            return [[[n, n]]];
                          }`, // 展示页面所用值
					},
					{
						value: 2,
						text: 2,
					},
				],
			},
		],
	},
	{
		name: '对象操作函数',
		images: ObjectPng,
		pitchImages: Object2Png,
		children: [],
	},
	{
		name: '数据断言转换函数',
		images: ObjectPng,
		pitchImages: Object2Png,
		children: [
			{
				name: '数组判断并转换', // 函数代表名
				funcName: ' 如果 value 不是数组, 那么强制转为数组。', // 函数名字
				function: LangCastArray, // 当前函数
				callKey: 'LangCastArray',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要处理的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { a: 1 }, // 传入函数中的值
						text: `{ 'a': 1 }`, // 展示页面所用值
					},
				],
			},
			{
				name: '浅拷贝', // 函数代表名
				funcName:
					' 创建一个 value 的浅拷贝。不支持error objects、functions, DOM nodes, 以及 WeakMaps 会返回空对象。', // 函数名字
				function: LangClone, // 当前函数
				callKey: 'LangClone',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要拷贝的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { a: 1 }, // 传入函数中的值
						text: `{ 'a': 1 }`, // 展示页面所用值
					},
				],
			},
			{
				name: '深拷贝', // 函数代表名
				funcName: '递归拷贝数据', // 函数名字
				function: LangCloneDeep, // 当前函数
				callKey: 'LangCloneDeep',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要拷贝的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [{ a: 1 }, { b: 2 }], // 传入函数中的值
						text: `[{ 'a': 1 }, { 'b': 2 }]`, // 展示页面所用值
					},
				],
			},
			{
				name: '浅克隆页面元素', // 函数代表名
				funcName:
					'递归拷贝数据,它接受一个 customizer 定制返回的克隆值。 如果 customizer 返回 undefined 将会使用拷贝方法代替处理', // 函数名字
				function: LangCloneWith, // 当前函数
				callKey: 'LangCloneWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要拷贝的值', // 第一个参数代表含义
					},
					{
						text: '用来自定义克隆的函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: document.body, // 传入函数中的值
						text: `document.body`, // 展示页面所用值
					},
					{
						value: function customizer(value) {
							if (isElement(value)) {
								return value.cloneNode(false);
							}
						},
						text: `function customizer(value) {
                            if (isElement(value)) {
                                return value.cloneNode(false);
                            }
                        }`,
					},
				],
			},
			{
				name: '深度克隆页面元素', // 函数代表名
				funcName: '它会递归克隆 value。支持页面元素', // 函数名字
				function: LangCloneDeepWith, // 当前函数
				callKey: 'LangCloneDeepWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '用来递归克隆的值', // 第一个参数代表含义
					},
					{
						text: '用来自定义克隆的函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: document.body, // 传入函数中的值
						text: `document.body`, // 展示页面所用值
					},
					{
						value: function customizer(value) {
							if (isElement(value)) {
								return value.cloneNode(true);
							}
						},
						text: `function customizer(value) {
                            if (isElement(value)) {
                              return value.cloneNode(true);
                            }
                          }`,
					},
				],
			},
			{
				name: '对象数据断言', // 函数代表名
				funcName: '通过调用断言对象的属性与 对象 的相应属性值，检查对象是否符合 断言。', // 函数名字
				function: LangConformsTo, // 当前函数
				callKey: 'LangConformsTo',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的对象。', // 第一个参数代表含义
					},
					{
						text: '要断言属性是否符合的对象。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { a: 1, b: 2 }, // 传入函数中的值
						text: `{ 'a': 1, 'b': 2 }`, // 展示页面所用值
					},
					{
						value: {
							b: function(n) {
								return n > 1;
							},
						},
						text: `{ 'b': function(n) { return n > 1; } }`,
					},
				],
			},
			{
				name: '数据相等比较', // 函数代表名
				funcName: '比较两者的值，来确定它们是否相等。如果两个值相等返回 true ，否则返回 false 。', // 函数名字
				function: LangEq, // 当前函数
				callKey: 'LangEq',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要比较的值。', // 第一个参数代表含义
					},
					{
						text: '另一个要比较的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: NaN, // 传入函数中的值
						text: `NaN`, // 展示页面所用值
					},
					{
						value: NaN,
						text: `NaN`,
					},
				],
			},
			{
				name: '类数组(伪数组)断言', // 函数代表名
				funcName: '检查 value 是否是一个类 arguments 对象(伪数组)。', // 函数名字
				function: LangIsArguments, // 当前函数
				callKey: 'LangIsArguments',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: (function() {
							return arguments;
						})(), // 传入函数中的值
						text: `function() { return arguments; }()`, // 展示页面所用值
					},
				],
			},
			{
				name: '数组断言', // 函数代表名
				funcName: '检查 value 是否是 Array 类对象。', // 函数名字
				function: LangIsArray, // 当前函数
				callKey: 'LangIsArray',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: (function() {
							return arguments;
						})(), // 传入函数中的值
						text: `function() { return arguments; }()`, // 展示页面所用值
					},
				],
			},
			{
				name: 'ArrayBuffer(数组缓冲)断言', // 函数代表名
				funcName: '检查 value 是否是 Array 类对象。', // 函数名字
				function: LangIsArrayBuffer, // 当前函数
				callKey: 'LangIsArrayBuffer',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: new ArrayBuffer(2), // 传入函数中的值
						text: `new ArrayBuffer(2)`, // 展示页面所用值
					},
				],
			},
			{
				name: '布尔值断言', // 函数代表名
				funcName: '检查 value 是否是原始 boolean 类型或者对象。', // 函数名字
				function: LangIsBooean, // 当前函数
				callKey: 'LangIsBooean',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: false, // 传入函数中的值
						text: `false`, // 展示页面所用值
					},
				],
			},
			{
				name: 'date(时间)对象断言', // 函数代表名
				funcName: '检查 value 是否是 Date 对象。', // 函数名字
				function: LangIsDate, // 当前函数
				callKey: 'LangIsDate',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 'Mon April 23 2012', // 传入函数中的值
						text: `Mon April 23 2012`, // 展示页面所用值
					},
				],
			},
			{
				name: 'DOM元素断言', // 函数代表名
				funcName: '检查 value 是否是可能是 DOM 元素。', // 函数名字
				function: LangIsElement, // 当前函数
				callKey: 'LangIsElement',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: document.body, // 传入函数中的值
						text: `document.body`, // 展示页面所用值
					},
				],
			},
			{
				name: '集合空断言', // 函数代表名
				funcName: '检查 value 是否为一个空对象，集合，映射或者set。', // 函数名字
				function: LangIsEmpty, // 当前函数
				callKey: 'LangIsEmpty',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值。', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: null, // 传入函数中的值
						text: `null`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断对象是否完全相等', // 函数代表名
				funcName: '执行深比较来确定两者的值是否相等。', // 函数名字
				function: LangIsEqual, // 当前函数
				callKey: 'LangIsEqual',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '用来比较的值。', // 第一个参数代表含义
					},
					{
						text: '另一个用来比较的值。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { a: 1 }, // 传入函数中的值
						text: `{ 'a': 1 }`, // 展示页面所用值
					},
					{
						value: { a: 1 },
						text: `{ 'a': 1 }`,
					},
				],
			},
			{
				name: '指定规则进行对象是否相等判断', // 函数代表名
				funcName:
					'它接受一个对比函数用来定制比较值。如果对比函数返回 undefined 将会比较处理方法代替。', // 函数名字
				function: LangIsEqualWith, // 当前函数
				callKey: 'LangIsEqualWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '用来比较的值。', // 第一个参数代表含义
					},
					{
						text: '另一个用来比较的值。',
					},
					{
						text: '用来定制比较值的函数。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['hello', 'goodbye'], // 传入函数中的值
						text: `['hello', 'goodbye']`, // 展示页面所用值
					},
					{
						value: ['hi', 'goodbye'],
						text: `['hi', 'goodbye']`,
					},
					{
						value: function customizer(objValue, othValue) {
							function isGreeting(value) {
								return /^h(?:i|ello)$/.test(value);
							}
							if (isGreeting(objValue) && isGreeting(othValue)) {
								return true;
							}
						},
						text: `function customizer(objValue, othValue) {
                            function isGreeting(value) {
                                return /^h(?:i|ello)$/.test(value);
                            }
                            if (isGreeting(objValue) && isGreeting(othValue)) {
                                return true;
                            }
                        }`,
					},
				],
			},
			{
				name: '判断是否为error对象', // 函数代表名
				funcName:
					'检查 value 是否是 Error, EvalError, RangeError, ReferenceError, SyntaxError, TypeError, 或者 URIError对象。', // 函数名字
				function: LangIsError, // 当前函数
				callKey: 'LangIsError',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: new Error(), // 传入函数中的值
						text: `new Error`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断数据是否为原始有限数值', // 函数代表名
				funcName: '检查 value 是否是原始有限数值。', // 函数名字
				function: LangIsFinite, // 当前函数
				callKey: 'LangIsFinite',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 56, // 传入函数中的值
						text: `56`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断数据是否为整数', // 函数代表名
				funcName: '检查 value 是否为一个整数。', // 函数名字
				function: LangIsInteger, // 当前函数
				callKey: 'LangIsInteger',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 6.25, // 传入函数中的值
						text: `6.25`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断数据是否为Map 对象', // 函数代表名
				funcName: '检查 value 是否为Map 对象', // 函数名字
				function: LangIsMap, // 当前函数
				callKey: 'LangIsMap',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: new Map(), // 传入函数中的值
						text: `new Map`, // 展示页面所用值
					},
				],
			},
			{
				name: '深度比较对象指定key值value是否相同', // 函数代表名
				funcName: '执行一个深度比较，来确定 object 是否含有和 source 完全相等的属性值。', // 函数名字
				function: LangIsMatch, // 当前函数
				callKey: 'LangIsMatch',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
					{
						text: '属性值相匹配的对象。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { a: 1, b: 2 }, // 传入函数中的值
						text: `{ 'a': 1, 'b': 2 }`, // 展示页面所用值
					},
					{
						value: { b: 2 },
						text: `{ 'b': 2 }`,
					},
				],
			},
			{
				name: '指定规则,深度比较对象指定key值value是否相同', // 函数代表名
				funcName:
					'它接受一个对比函数定制比较的值。 如果对比函数返回 undefined 将会比较处理方法代替', // 函数名字
				function: LangIsMatchWith, // 当前函数
				callKey: 'LangIsMatchWith',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的对象。', // 第一个参数代表含义
					},
					{
						text: '属性值相匹配的对象。',
					},
					{
						text: '这个函数用来定制比较。',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { greeting: 'hello' }, // 传入函数中的值
						text: `{ 'greeting': 'hello' }`, // 展示页面所用值
					},
					{
						value: { greeting: 'hi' },
						text: `{ 'greeting': 'hi' }`,
					},
					{
						value: function customizer(objValue, srcValue) {
							function isGreeting(value) {
								return /^h(?:i|ello)$/.test(value);
							}
							if (isGreeting(objValue) && isGreeting(srcValue)) {
								return true;
							}
						},
						text: `function customizer(objValue, srcValue) {
                            function isGreeting(value) {
                                return /^h(?:i|ello)$/.test(value);
                            }
                            if (isGreeting(objValue) && isGreeting(srcValue)) {
                                return true;
                            }
                        }`,
					},
				],
			},
			{
				name: '判断数据是否为NaN对象', // 函数代表名
				funcName: '检查 value 是否是 NaN。', // 函数名字
				function: LangIsNaN, // 当前函数
				callKey: 'LangIsNaN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: NaN, // 传入函数中的值
						text: `NaN`, // 展示页面所用值
					},
				],
			},
			// {
			//     name:'判断数据是否为原生函数', // 函数代表名
			//     funcName: '检查 value 是否是一个原生函数。', // 函数名字
			//     function: LangIsNative, // 当前函数
			//     callKey: 'LangIsNative',
			//     params: [ // 函数所需要传入值内容 为空为不传值
			//         {
			//             text:'要检查的值', // 第一个参数代表含义
			//         }
			//     ],
			//     demo: [ // 展示给用户看的案例传入值
			//         {
			//             value:Array.prototype.push,// 传入函数中的值
			//             text:`Array.prototype.push`, // 展示页面所用值
			//         }
			//     ],
			// },
			{
				name: '判断数据是否已经定义', // 函数代表名
				funcName: '检查 value 是否是 null 或者 undefined。', // 函数名字
				function: LangIsNil, // 当前函数
				callKey: 'LangIsNil',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: undefined, // 传入函数中的值
						text: `undefined`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断数据是否为null', // 函数代表名
				funcName: '检查 value 是否是 null ', // 函数名字
				function: LangIsNull, // 当前函数
				callKey: 'LangIsNull',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: undefined, // 传入函数中的值
						text: `undefined`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断数据是否为数字(number)', // 函数代表名
				funcName: '检查 value 是否是原始Number数值型 或者 对象。', // 函数名字
				function: LangIsNumber, // 当前函数
				callKey: 'LangIsNumber',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 585, // 传入函数中的值
						text: `585`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断数据是否为对象', // 函数代表名
				funcName: '检查 value 是否是对象。', // 函数名字
				function: LangIsObject, // 当前函数
				callKey: 'LangIsObject',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: {}, // 传入函数中的值
						text: `{}`, // 展示页面所用值
					},
				],
			},
			{
				name: '判断数据是否为正则表达式', // 函数代表名
				funcName: '检查 value 是否为正则表达式对象。', // 函数名字
				function: LangIsRegExp, // 当前函数
				callKey: 'LangIsRegExp',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: /^[0-9]*[1-9][0-9]*$/, // 传入函数中的值
						text: `/^[0-9]*[1-9][0-9]*$/`, // 展示页面所用值
					},
				],
			},
			{
				name: '将数据转为数组', // 函数代表名
				funcName: '转换 value 为一个数组。', // 函数名字
				function: LangToArray, // 当前函数
				callKey: 'LangToArray',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '23gfdojbn', // 传入函数中的值
						text: `23gfdojbn`, // 展示页面所用值
					},
				],
			},
			{
				name: '将数据转为整数', // 函数代表名
				funcName: '转换 value 为一个数组。', // 函数名字
				function: LangToInteger, // 当前函数
				callKey: 'LangToInteger',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '3.8', // 传入函数中的值
						text: `3.8`, // 展示页面所用值
					},
				],
			},
			{
				name: '将数据转为字符串', // 函数代表名
				funcName:
					'转换 value 为字符串。 null 和 undefined 将返回空字符串。-0 将被转换为字符串"-0"。', // 函数名字
				function: LangToString, // 当前函数
				callKey: 'LangToString',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '要检查的值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 2342, // 传入函数中的值
						text: `2342`, // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '数字操作函数',
		images: NumberPng,
		pitchImages: Number2Png,
		children: [
			{
				name: '兼容合并数组', // 函数代表名
				funcName: '将传入2个数组进行合并,返回一个合并后数组', // 函数名字
				function: MERGEARRAY, // 当前函数
				callKey: 'MERGEARRAY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入合并数组', // 第一个参数代表含义
					},
					{
						text: '传入合并数组', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78], // 传入函数中的值
						text: '[23,98,78]', // 展示页面所用值
					},
					{
						value: [32, 51, 79], // 传入函数中的值
						text: '[32,51,79]', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '字符串操作函数',
		images: StringPng,
		pitchImages: String2Png,
		children: [
			{
				name: '兼容合并数组', // 函数代表名
				funcName: '将传入2个数组进行合并,返回一个合并后数组', // 函数名字
				function: MERGEARRAY, // 当前函数
				callKey: 'MERGEARRAY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入合并数组', // 第一个参数代表含义
					},
					{
						text: '传入合并数组', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78], // 传入函数中的值
						text: '[23,98,78]', // 展示页面所用值
					},
					{
						value: [32, 51, 79], // 传入函数中的值
						text: '[32,51,79]', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '兼容性函数', // 系列函数名称
		images: Compatibility,
		pitchImages: Compatibility2,
		children: [
			{
				name: '兼容合并数组', // 函数代表名
				funcName: '将传入2个数组进行合并,返回一个合并后数组', // 函数名字
				function: MERGEARRAY, // 当前函数
				callKey: 'MERGEARRAY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入合并数组', // 第一个参数代表含义
					},
					{
						text: '传入合并数组', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78], // 传入函数中的值
						text: '[23,98,78]', // 展示页面所用值
					},
					{
						value: [32, 51, 79], // 传入函数中的值
						text: '[32,51,79]', // 展示页面所用值
					},
				],
			},
			{
				name: '兼容拆分数组', // 函数代表名
				funcName: '将传入数组按照传入长度进行拆分,返回一个拆分后多维数组', // 函数名字
				function: SPLITARRAY, // 当前函数
				callKey: 'SPLITARRAY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要拆分数组', // 第一个参数代表含义
					},
					{
						text: '传入拆分长度', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78, 65, 32, 11, 12], // 传入函数中的值
						text: '[23,98,78,65,32,11,12]', // 展示页面所用值
					},
					{
						value: 2, // 传入函数中的值
						text: '2', // 展示页面所用值
					},
				],
			},
			{
				name: '兼容切片数组', // 函数代表名
				funcName: '将传入数组按照传入长度进行切片,返回一个切片后数组', // 函数名字
				function: REMOVEARRAYDROP, // 当前函数
				callKey: 'REMOVEARRAYDROP',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要切片数组', // 第一个参数代表含义
					},
					{
						text: '传入切片长度', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [23, 98, 78, 65, 32, 11, 12], // 传入函数中的值
						text: '[23,98,78,65,32,11,12]', // 展示页面所用值
					},
					{
						value: 2, // 传入函数中的值
						text: '2', // 展示页面所用值
					},
				],
			},
		],
	},

	{
		name: '多维数据集函数', // 系列函数名称
		images: Dimensions,
		pitchImages: Dimensions2,
		children: [
			{
				name: '多维数据数组对象从大到小排序', // 函数代表名
				funcName: '检查传入数组中对象,并根据指定数字属性进行从大到小排序', // 函数名字
				function: ARRAYSORTONJECT, // 当前函数
				callKey: 'ARRAYSORTONJECT',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要排序的数组', // 第一个参数代表含义
					},
					{
						text: '需要排序的对象指定值', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ name: 'xx', age: 19 },
							{ name: 'ss', age: 16 },
							{ name: 'ww', age: 12 },
							{ name: 'ee', age: 17 },
							{ name: 'qq', age: 14 },
							{ name: 'uu', age: 22 },
						], // 传入函数中的值
						text: `[{name:'xx',age:19},{name:'ss',age:16},{name:'ww',age:12}
                        ,{name:'ee',age:17},{name:'qq',age:14},{name:'uu',age:22}]`, // 展示页面所用值
					},
					{
						value: 'age', // 传入函数中的值
						text: 'age', // 展示页面所用值
					},
				],
			},
			{
				name: '多维数据数组对象从小到大排序', // 函数代表名
				funcName: '检查传入数组中对象,并根据指定数字属性进行从小到大排序', // 函数名字
				function: ARRAYSORTONJECTTWO, // 当前函数
				callKey: 'ARRAYSORTONJECTTWO',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要排序的数组', // 第一个参数代表含义
					},
					{
						text: '需要排序的对象指定值', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ name: 'qq', age: 19 },
							{ name: 'ss', age: 56 },
							{ name: 'ww', age: 12 },
							{ name: 'ii', age: 17 },
							{ name: 'qq', age: 34 },
							{ name: 'uu', age: 22 },
						], // 传入函数中的值
						text: `[{name:'qq',age:19},{name:'ss',age:56},{name:'ww',age:12}
                        ,{name:'ii',age:17},{name:'qq',age:34},{name:'uu',age:22}]`, // 展示页面所用值
					},
					{
						value: 'age', // 传入函数中的值
						text: 'age', // 展示页面所用值
					},
				],
			},
			{
				name: '多维数据对象转为数组', // 函数代表名
				funcName: '检查传入对象,并进行转换为数组', // 函数名字
				function: OBJECTTOARRY, // 当前函数
				callKey: 'OBJECTTOARRY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的对象', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { name: 'xx', age: 12, address: 'china' }, // 传入函数中的值
						text: "{name:'xx',age:12,address:'china'}", // 展示页面所用值
					},
				],
			},
			{
				name: '多维数据获取对象指定值', // 函数代表名
				funcName: '检查传入对象,获取需要的指定key值', // 函数名字
				function: OBJECTGETKEY, // 当前函数
				callKey: 'OBJECTGETKEY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要操作的对象', // 第一个参数代表含义
					},
					{
						text: '获取数组中指定的key值',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: { name: 'xx', age: 12, address: 'china', time: '2019-10-10' }, // 传入函数中的值
						text: "{name:'xx',age:12,address:'china',time:'2019-10-10'}", // 展示页面所用值
					},
					{
						value: ['name', 'address'],
						text: "['name','address']",
					},
				],
			},
			{
				name: '多维数据子数组排序', // 函数代表名
				funcName: '传入多维数组,并对子数组中数值排序进行,非子数组则会跳过', // 函数名字
				function: ARRAYMANYSORT, // 当前函数
				callKey: 'ARRAYMANYSORT',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要排序的多维数组', // 第一个参数代表含义
					},
					{
						text: '是否从大到小排序,默认从大到小',
					},
				],
				demo: [
					// 展示给用户看的案例传入值

					{
						value: [[43, 12, 56, 26, 47], [21, 76, 74, 23, 63], '我不是数组', [85, 74, 12, 53, 23]],
						text: "[[43,12,56,26,47],[21,76,74,23,63],'我不是数组',[85,74,12,53,23]]",
					},
					{
						value: false,
						text: 'false',
					},
				],
			},
			{
				name: '多维数据子数组中对象拆分为数组', // 函数代表名
				funcName: '传入多维数组,并对子数组中对象进行拆分成数组,非子数组则会跳过', // 函数名字
				function: ARRAYSPLITOBJECT, // 当前函数
				callKey: 'ARRAYSPLITOBJECT',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要拆分的多维数组', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值

					{
						value: [
							[{ age: 21, name: 'sx', address: 'chind' }, { post: '职位', title: '标题' }],
							[{ name1: 'as', age1: 43, address: 'china' }, { post: '职位', title: '标题' }],
						],
						text:
							"[[{age:21,name:'sx',address:'chind'},{post:'职位',title:'标题'}],[{name1:'as',age1:43,address:'china'},{post:'职位',title:'标题'}]]",
					},
				],
			},
		],
	},
	{
		name: '数据库函数', // 系列函数名称
		images: Database,
		pitchImages: Database2,
		children: [
			{
				name: '数据库函数子函数', // 函数代表名
				funcName: 'sql', // 函数名字
				function: sql, // 当前函数
				callKey: 'sql',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '', // 传入函数中的值
						text: '', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '日期和时间函数', // 系列函数名称
		images: DateImg,
		pitchImages: DateImg2,
		children: [
			{
				name: '日期差值计算', // 函数代表名
				funcName: '将传入2个时间戳进行计算,返回2者时间戳差值', // 函数名字
				function: CONTRASTTIME, // 当前函数
				callKey: 'CONTRASTTIME',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入计算时间戳', // 第一个参数代表含义
					},
					{
						text: '传入计算时间戳', // 第二个参数代表含义
					},
					{
						text: '是否需要将时间差值进行转换(true或false)',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1576122231269, // 传入函数中的值
						text: '1576122231269', // 展示页面所用值
					},
					{
						value: 1576111231269, // 传入函数中的值
						text: '1576121231269', // 展示页面所用值
					},
					{
						value: true,
						text: 'true',
					},
				],
			},
			{
				name: '日期年月日格式化', // 函数代表名
				funcName: '将传入的时间戳格式化为年月日', // 函数名字
				function: DATEGETYEAR, // 当前函数
				callKey: 'DATEGETYEAR',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要格式化时间戳', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1576122231269, // 传入函数中的值
						text: '1576122231269', // 展示页面所用值
					},
				],
			},
			{
				name: '日期月日格式化', // 函数代表名
				funcName: '将传入的时间戳格式化为月日', // 函数名字
				function: DATAGETMONTH, // 当前函数
				callKey: 'DATAGETMONTH',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要格式化时间戳', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1576122231269, // 传入函数中的值
						text: '1576122231269', // 展示页面所用值
					},
				],
			},
			{
				name: '日期日格式化', // 函数代表名
				funcName: '将传入的时间戳格式化为日', // 函数名字
				function: DATAGETDAY, // 当前函数
				callKey: 'DATAGETDAY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要格式化时间戳', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1576122231269, // 传入函数中的值
						text: '1576122231269', // 展示页面所用值
					},
				],
			},
			{
				name: '日期时间格式化', // 函数代表名
				funcName: '将传入的时间戳格式化为时间', // 函数名字
				function: DATAGETTIME, // 当前函数
				callKey: 'DATAGETTIME',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要格式化时间戳', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1576122231269, // 传入函数中的值
						text: '1576122231269', // 展示页面所用值
					},
				],
			},
			{
				name: '日期自定义格式化', // 函数代表名
				funcName: '将传入的时间戳按照自定义格式化为时间格式', // 函数名字
				function: DATAGETCUSTOM, // 当前函数
				callKey: 'DATAGETCUSTOM',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要格式化时间戳', // 第一个参数代表含义
					},
					{
						text: '传入的时间格式化格式',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1576122231269, // 传入函数中的值
						text: '1576122231269', // 展示页面所用值
					},
					{
						value: 'YYYY-MM-DD hh:mm:ss',
						text: 'YYYY-MM-DD hh:mm:ss',
					},
				],
			},
		],
	},
	{
		name: '财务函数', // 系列函数名称
		images: Finance,
		pitchImages: Finance2,
		children: [
			{
				name: '财务自动求和', // 函数代表名
				funcName: '将传入2个数值进行相加,返回相加后总数', // 函数名字
				function: AUTOSUMMATION, // 当前函数
				callKey: 'AUTOSUMMATION',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入被加值', // 第一个参数代表含义
					},
					{
						text: '传入累加值', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 23, // 传入函数中的值
						text: '23', // 展示页面所用值
					},
					{
						value: 85, // 传入函数中的值
						text: '85', // 展示页面所用值
					},
				],
			},
			{
				name: '财务自动求平均值', // 函数代表名
				funcName: '将传入的数字数组集合累加并进行平均值求值', // 函数名字
				function: AUTOMEAN, // 当前函数
				callKey: 'AUTOMEAN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求平均值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
			{
				name: '财务自动获取最大值', // 函数代表名
				funcName: '将传入的数字数组集合获取最大值', // 函数名字
				function: AUTOMAX, // 当前函数
				callKey: 'AUTOMAX',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求获取最大值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
			{
				name: '财务自动获取最小值', // 函数代表名
				funcName: '将传入的数字数组集合获取最小值', // 函数名字
				function: AUTOMIN, // 当前函数
				callKey: 'AUTOMIN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求获取最小值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '信息函数', // 系列函数名称
		images: MessageImg,
		pitchImages: MessageImg2,
		children: [
			{
				name: '信息类型判断', // 函数代表名
				funcName: '将传入的数据判断类型并返回', // 函数名字
				function: TYPEOFDATA, // 当前函数
				callKey: 'TYPEOFDATA',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入一个数据,对传入数据进行判断', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['测试'], // 传入函数中的值
						text: '["测试"]', // 展示页面所用值
					},
				],
			},
			{
				name: '信息提示', // 函数代表名
				funcName: '将传入的提示内容添加到提示框展示', // 函数名字
				function: TOASTMESSAGE, // 当前函数
				callKey: 'TOASTMESSAGE',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要提示用户的信息', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '测试信息', // 传入函数中的值
						text: '测试信息', // 展示页面所用值
					},
				],
			},
			{
				name: '信息NaN判断', // 函数代表名
				funcName: '将传入的数据是否是NaN', // 函数名字
				function: TYPEOFNAN, // 当前函数
				callKey: 'TYPEOFNAN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入的需要判断数据', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: NaN, // 传入函数中的值
						text: 'NaN', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '逻辑函数', // 系列函数名称
		images: Logic,
		pitchImages: Logic2,
		children: [
			{
				name: '逻辑判断数组是否存在空数值', // 函数代表名
				funcName: '检查传入数组所有值是否存在值,存在控制返回true', // 函数名字
				function: LOGICARRAY, // 当前函数
				callKey: 'LOGICARRAY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要检查的数组', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [56, '23', '236', undefined, null], // 传入函数中的值
						text: "[56,'23','236',undefined,null]", // 展示页面所用值
					},
				],
			},
			{
				name: '逻辑判断文本内容对比', // 函数代表名
				funcName: '对比传入的2个字符串是否相同', // 函数名字
				function: STRINGISSAME, // 当前函数
				callKey: 'STRINGISSAME',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,world', // 传入函数中的值
						text: '你好,world', // 展示页面所用值
					},
					{
						value: '你好世界', // 传入函数中的值
						text: '你好世界', // 展示页面所用值
					},
				],
			},
			{
				name: '逻辑判断文本对比查询', // 函数代表名
				funcName: '对比传入的2个字符串对比,查询后面传入值是否存在于第一个参数中', // 函数名字
				function: STRINGISHAVE, // 当前函数
				callKey: 'STRINGISHAVE',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,world', // 传入函数中的值
						text: '你好,world', // 展示页面所用值
					},
					{
						value: '好', // 传入函数中的值
						text: '好', // 展示页面所用值
					},
				],
			},
			{
				name: '逻辑筛选数组指定值', // 函数代表名
				funcName: '检查数值是否存在指定值,存在则返回', // 函数名字
				function: LOGICARRAYFILTER, // 当前函数
				callKey: 'LOGICARRAYFILTER',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要检查的数组', // 第一个参数代表含义
					},
					{
						text: '指定值', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['你好', '世界', '嗯'], // 传入函数中的值
						text: "['你好','世界','嗯']", // 展示页面所用值
					},
					{
						value: '世界', // 传入函数中的值
						text: '世界', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '查找和引用函数', // 系列函数名称
		images: Find,
		pitchImages: Find2,
		children: [
			{
				name: '查找并替换字段', // 函数代表名
				funcName: '修改字符串中匹配的第一个字段', // 函数名字
				function: FINDSTRRPLACE, // 当前函数
				callKey: 'FINDSTRRPLACE',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要查询的字符串', // 第一个参数代表含义
					},
					{
						text: '传入需要查询的字段',
					},
					{
						text: '传入需要更换查询的字段',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,世界', // 传入函数中的值
						text: '你好,世界', // 展示页面所用值
					},
					{
						value: '世界',
						text: '世界',
					},
					{
						value: '美丽世界',
						text: '美丽世界',
					},
				],
			},
			{
				name: '查找数组内容', // 函数代表名
				funcName: '查找出数组中匹配的第一个数值', // 函数名字
				function: FINDARRAYNUM, // 当前函数
				callKey: 'FINDARRAYNUM',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要查询的数组', // 第一个参数代表含义
					},
					{
						text: '传入需要查询的内容',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [2, 3, 5, 2, 21], // 传入函数中的值
						text: '[2,3,5,2,21]', // 展示页面所用值
					},
					{
						value: 21,
						text: '21',
					},
				],
			},
		],
	},
	{
		name: '数学和三角函数', // 系列函数名称
		images: MathImg,
		pitchImages: MathImg2,
		children: [
			{
				name: '数学自动求和', // 函数代表名
				funcName: '将传入2个数值进行相加,返回相加后总数', // 函数名字
				function: AUTOSUMMATION, // 当前函数
				callKey: 'AUTOSUMMATION',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入被加值', // 第一个参数代表含义
					},
					{
						text: '传入累加值', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 23, // 传入函数中的值
						text: '23', // 展示页面所用值
					},
					{
						value: 85, // 传入函数中的值
						text: '85', // 展示页面所用值
					},
				],
			},
			{
				name: '数学自动求平均值', // 函数代表名
				funcName: '将传入的数字数组集合累加并进行平均值求值', // 函数名字
				function: AUTOMEAN, // 当前函数
				callKey: 'AUTOMEAN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求平均值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
			{
				name: '数学自动获取最大值', // 函数代表名
				funcName: '将传入的数字数组集合获取最大值', // 函数名字
				function: AUTOMAX, // 当前函数
				callKey: 'AUTOMAX',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求获取最大值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
			{
				name: '数学自动获取最小值', // 函数代表名
				funcName: '将传入的数字数组集合获取最小值', // 函数名字
				function: AUTOMIN, // 当前函数
				callKey: 'AUTOMIN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求获取最小值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '统计函数', // 系列函数名称
		images: Statistics,
		pitchImages: Statistics2,
		children: [
			{
				name: '统计数组总值', // 函数代表名
				funcName: '将传入的数组值,进行累加返回累加总数,如果存在非数字会跳过计算', // 函数名字
				function: ARRAYADDNUM, // 当前函数
				callKey: 'ARRAYADDNUM',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要进行累积的数组', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, '测试', 16], // 传入函数中的值
						text: '[8,9,6,8,7,"测试",16]', // 展示页面所用值
					},
				],
			},
			{
				name: '统计数组中对象某一值总数', // 函数代表名
				funcName: '将传入的数组值,进行累加返回累加总数,如果存在非数字会跳过计算', // 函数名字
				function: ARRAYOBJECTADD, // 当前函数
				callKey: 'ARRAYOBJECTADD',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入需要进行累积的数组', // 第一个参数代表含义
					},
					{
						text: '指定需要累积的对象key值',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [
							{ num: 3 },
							{ num: 33 },
							{ num: 63 },
							{ num: 43 },
							{ num: 23 },
							{ num: '98w' },
							{ num: 13 },
						], // 传入函数中的值
						text: '[{num:3},{num:33},{num:63},{num:43},{num:23},{num:"98w"},{num:13}]', // 展示页面所用值
					},
					{
						value: 'num',
						text: 'num',
					},
				],
			},
			{
				name: '统计用户输入长度', // 函数代表名
				funcName: '统计用户总共输入的长度并返回', // 函数名字
				function: STRINGLEHGTH, // 当前函数
				callKey: 'STRINGLEHGTH',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要统计的内容长度', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '我是被测试内容', // 传入函数中的值
						text: '我是被测试内容', // 展示页面所用值
					},
				],
			},
			{
				name: '统计自动求和', // 函数代表名
				funcName: '将传入2个数值进行相加,返回相加后总数', // 函数名字
				function: AUTOSUMMATION, // 当前函数
				callKey: 'AUTOSUMMATION',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入被加值', // 第一个参数代表含义
					},
					{
						text: '传入累加值', // 第二个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 23, // 传入函数中的值
						text: '23', // 展示页面所用值
					},
					{
						value: 85, // 传入函数中的值
						text: '85', // 展示页面所用值
					},
				],
			},
			{
				name: '统计自动求平均值', // 函数代表名
				funcName: '将传入的数字数组集合累加并进行平均值求值', // 函数名字
				function: AUTOMEAN, // 当前函数
				callKey: 'AUTOMEAN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求平均值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
			{
				name: '统计自动获取最大值', // 函数代表名
				funcName: '将传入的数字数组集合获取最大值', // 函数名字
				function: AUTOMAX, // 当前函数
				callKey: 'AUTOMAX',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求获取最大值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
			{
				name: '统计自动获取最小值', // 函数代表名
				funcName: '将传入的数字数组集合获取最小值', // 函数名字
				function: AUTOMIN, // 当前函数
				callKey: 'AUTOMIN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '传入所有需要求获取最小值的数组集合', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: [8, 9, 6, 8, 7, 16], // 传入函数中的值
						text: '[8,9,6,8,7,16]', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '文本函数', // 系列函数名称
		images: TextImg,
		pitchImages: TextImg2,
		children: [
			{
				name: '文本HTML标签转译', // 函数代表名
				funcName: '将文本域输入的HTML标签转移', // 函数名字
				function: TRANSLATIONSTRING, // 当前函数
				callKey: 'TRANSLATIONSTRING',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要进行转移的文本输入', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '<script>alert("233")</script>', // 传入函数中的值
						text: '<script>alert("233")</script>', // 展示页面所用值
					},
				],
			},
			{
				name: '文本HTML标签反向转译', // 函数代表名
				funcName: '将文本域输入的已转译HTML标签反向转译', // 函数名字
				function: TRANSLATIONSTRINGTWO, // 当前函数
				callKey: 'TRANSLATIONSTRINGTWO',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要进行反向转译的文本输入', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '&lt;script&gt;alert(&quto;233&quto;)&lt;&#x2F;script&gt;', // 传入函数中的值
						text: '&lt;script&gt;alert(&quto;233&quto;)&lt;&#x2F;script&gt;', // 展示页面所用值
					},
				],
			},
			{
				name: '文本数组内容拼接', // 函数代表名
				funcName: '将数组内容进行拼接,会跳过拼接对象', // 函数名字
				function: TEXTCONCAT, // 当前函数
				callKey: 'TEXTCONCAT',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要拼接的数组内容', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: ['你好', { num: 1 }, '世界'], // 传入函数中的值
						text: "['你好',{num:1},'世界']", // 展示页面所用值
					},
				],
			},
			{
				name: '文本内容对比', // 函数代表名
				funcName: '对比传入的2个字符串是否相同', // 函数名字
				function: STRINGISSAME, // 当前函数
				callKey: 'STRINGISSAME',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,世界', // 传入函数中的值
						text: '你好,世界', // 展示页面所用值
					},
					{
						value: '你好世界', // 传入函数中的值
						text: '你好世界', // 展示页面所用值
					},
				],
			},
			{
				name: '文本对比查询', // 函数代表名
				funcName: '对比传入的2个字符串对比,查询后面传入值是否存在于第一个参数中', // 函数名字
				function: STRINGISHAVE, // 当前函数
				callKey: 'STRINGISHAVE',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
					{
						text: '需要对比的字符串', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,世界', // 传入函数中的值
						text: '你好,世界', // 展示页面所用值
					},
					{
						value: '好', // 传入函数中的值
						text: '好', // 展示页面所用值
					},
				],
			},
			{
				name: '文本转换为驼峰写法', // 函数代表名
				funcName: '将文本英文转为驼峰写法', // 函数名字
				function: STRINGCAMELCASE, // 当前函数
				callKey: 'STRINGCAMELCASE',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的字符串', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,hello world,世界', // 传入函数中的值
						text: '你好,hello world,世界', // 展示页面所用值
					},
				],
			},
			{
				name: '文本校验', // 函数代表名
				funcName: '校验传入文本是否按照规定字符结尾', // 函数名字
				function: STRINGVERIFY, // 当前函数
				callKey: 'STRINGVERIFY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要校验的字符串', // 第一个参数代表含义
					},
					{
						text: '需要校验的字符规则', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,hello world,世界', // 传入函数中的值
						text: '你好,hello world,世界', // 展示页面所用值
					},
					{
						value: '世界', // 传入函数中的值
						text: '世界', // 展示页面所用值
					},
				],
			},
			{
				name: '文本拆分为集合', // 函数代表名
				funcName: '拆分字符串内容成数组', // 函数名字
				function: STRINGVERIFY, // 当前函数
				callKey: 'STRINGVERIFY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要拆分的字段', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: '你好,hello world,世界', // 传入函数中的值
						text: '你好,hello world,世界', // 展示页面所用值
					},
				],
			},
		],
	},
	{
		name: '工程函数', // 系列函数名称
		images: Project,
		pitchImages: Project2,
		children: [
			{
				name: '工程十进制转八进制', // 函数代表名
				funcName: '获得十进制参数并转换为八进制返回', // 函数名字
				function: TENSCALETOEIGHT, // 当前函数
				callKey: 'TENSCALETOEIGHT',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 580, // 传入函数中的值
						text: '580', // 展示页面所用值
					},
				],
			},
			{
				name: '工程十进制转十六进制', // 函数代表名
				funcName: '获得十进制参数并转换为十六进制返回', // 函数名字
				function: TENSCALETOSIXTEEN, // 当前函数
				callKey: 'TENSCALETOSIXTEEN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 580, // 传入函数中的值
						text: '580', // 展示页面所用值
					},
				],
			},
			{
				name: '工程十进制转二进制', // 函数代表名
				funcName: '获得十进制参数并转换为二进制返回', // 函数名字
				function: TENSCALETOTWO, // 当前函数
				callKey: 'TENSCALETOTWO',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 580, // 传入函数中的值
						text: '580', // 展示页面所用值
					},
				],
			},
			{
				name: '工程十进制自定义转化', // 函数代表名
				funcName: '获得十进制参数并转换为自定义转化返回', // 函数名字
				function: TENSCALETOMANY, // 当前函数
				callKey: 'TENSCALETOMANY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
					{
						text: '自定义的进制转换',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 580, // 传入函数中的值
						text: '580', // 展示页面所用值
					},
					{
						value: 8,
						text: '8',
					},
				],
			},
			{
				name: '工程八进制到十进制转换', // 函数代表名
				funcName: '获得八进制参数并转换为十进制返回', // 函数名字
				function: EIGHTSCALETOTEN, // 当前函数
				callKey: 'EIGHTSCALETOTEN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1104, // 传入函数中的值
						text: '1104', // 展示页面所用值
					},
				],
			},
			{
				name: '工程八进制到十六进制转换', // 函数代表名
				funcName: '获得八进制参数并转换为十六进制返回', // 函数名字
				function: EIGHTSCALETOSIXTEEN, // 当前函数
				callKey: 'EIGHTSCALETOSIXTEEN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1104, // 传入函数中的值
						text: '1104', // 展示页面所用值
					},
				],
			},
			{
				name: '工程八进制到二进制转换', // 函数代表名
				funcName: '获得八进制参数并转换为二进制返回', // 函数名字
				function: EIGHTSCALETOTWO, // 当前函数
				callKey: 'EIGHTSCALETOTWO',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1104, // 传入函数中的值
						text: '1104', // 展示页面所用值
					},
				],
			},
			{
				name: '工程八进制到自定义进制转换', // 函数代表名
				funcName: '获得八进制参数并转换为自定义返回', // 函数名字
				function: EIGHTSCALETOMANY, // 当前函数
				callKey: 'EIGHTSCALETOMANY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
					{
						text: '自定义的进制转换',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 1104, // 传入函数中的值
						text: '1104', // 展示页面所用值
					},
					{
						value: 10,
						text: '10',
					},
				],
			},
			{
				name: '工程十六进制到十进制转换', // 函数代表名
				funcName: '获得十六进制参数并转换为十进制返回', // 函数名字
				function: SIXTEENSCALETOTEN, // 当前函数
				callKey: 'SIXTEENSCALETOTEN',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 244, // 传入函数中的值
						text: '244', // 展示页面所用值
					},
				],
			},
			{
				name: '工程十六进制到二进制转换', // 函数代表名
				funcName: '获得十六进制参数并转换为二进制返回', // 函数名字
				function: SIXTEENSCALETOTWO, // 当前函数
				callKey: 'SIXTEENSCALETOTWO',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 244, // 传入函数中的值
						text: '244', // 展示页面所用值
					},
				],
			},
			{
				name: '工程十六进制到八进制转换', // 函数代表名
				funcName: '获得十六进制参数并转换为八进制返回', // 函数名字
				function: SIXTEENSCALETOEIGHT, // 当前函数
				callKey: 'SIXTEENSCALETOEIGHT',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 244, // 传入函数中的值
						text: '244', // 展示页面所用值
					},
				],
			},
			{
				name: '工程十六进制到自定义进制转换', // 函数代表名
				funcName: '获得十六进制参数并转换为自定义返回', // 函数名字
				function: SIXTEENSCALETOMANY, // 当前函数
				callKey: 'SIXTEENSCALETOMANY',
				params: [
					// 函数所需要传入值内容 为空为不传值
					{
						text: '需要转换的数字', // 第一个参数代表含义
					},
					{
						text: '自定义的进制转换',
					},
				],
				demo: [
					// 展示给用户看的案例传入值
					{
						value: 244, // 传入函数中的值
						text: '244', // 展示页面所用值
					},
					{
						value: 10,
						text: '10',
					},
				],
			},
		],
	},
];
/**
 * 公式选择数组
 */
const tabList = [
	// {
	//     name:'柱形图',
	//     key:'1',
	//     images: Column,
	//     pitchImages: Column2,
	//     children:[
	//         // 格式参考
	//         // {
	//         //     name: '', // 函数名字
	//         //     funcName: '', // 函数介绍
	//         //     function: ''. // 函数
	//         // }
	//     ],
	//     isPitch:false, // 是否选中
	//     isShowList: false, // 是否自动展开子表单
	// },
	// {
	//     name:'饼图',
	//     key:'2',
	//     images:PieImg,
	//     pitchImages: PieImg2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '雷达图',
	//     key:'3',
	//     images: Radar,
	//     pitchImages: Radar2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '气泡图',
	//     key:'4',
	//     images: Bubble,
	//     pitchImages: Bubble2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '散点图',
	//     key:'5',
	//     images: Splashes,
	//     pitchImages: Splashes2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '树状图',
	//     key: '6',
	//     images: Dendrogram,
	//     pitchImages: Dendrogram2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '箱型图',
	//     key: '7',
	//     images: Box,
	//     pitchImages: Box2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '旭日图',
	//     key: '8',
	//     images: Rising,
	//     pitchImages: Rising2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '折线图',
	//     key: '9',
	//     images: Line,
	//     pitchImages: Line2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// },
	// {
	//     name: '直方图',
	//     key:'10',
	//     images: Straight,
	//     pitchImages: Straight2,
	//     children:[],
	//     isPitch:false,
	//     isShowList: false,
	// }
];
/**
 * List 在此做格式化操作并添加入tabList导出,
 * 属于List数组中函数新增应新增到List中,此处会自动添加进去
 * 属于tabList数组函数新增应新增到tabList中
 */
List.map((item, index) => {
	tabList.push({
		name: item.name,
		key: item.name + index,
		images: item.images,
		pitchImages: item.pitchImages,
		isPitch: false,
		isShowList: false,
		children: item.children.map((arr, i) => {
			return {
				name: arr.name,
				funcName: arr.funcName,
				function: arr.function,
				callKey: arr.callKey,
			};
		}),
	});
});
export const formulaList = tabList;
/**
 * 数据库函数系列
 * @param {*} params
 */
export function sql() {}
/**
 * 基础计算函数
 * 自动求和
 * @param {传入被加值} num
 * @param {传入累加值} num1
 */
export function AUTOSUMMATION(num, num1) {
	num = +num;
	num1 = +num1;
	return num + num1;
}
/**
 * 基础计算函数
 * 自动求平均值
 * @param {传入需要累加的数组,里面为数字} List
 */
export function AUTOMEAN(List) {
	let num = 0; // 初始值
	let mean = 0; // 平均值
	if (isArray(List)) {
		List.map((item) => {
			if (typeof item == 'number' || typeof item == 'string') {
				num += item;
			} else {
				console.log('这不是一个数字');
				return;
			}
		});
		if (isNaN(num)) {
			console.log('传入值错误,请检查');
		} else {
			mean = num / List.length;
			return mean;
		}
	} else {
		console.log('这不是数组');
		return;
	}
}
/**
 * 基础计算函数
 * 获取最大值
 * @param {传入需要累加的数组,获取数组最大值} List
 */
export function AUTOMAX(List) {
	return Math.max.apply(null, List);
}
/**
 * 基础计算函数
 * 获取最大值
 * @param {传入需要累加的数组,获取数组最小值} List
 */
export function AUTOMIN(List) {
	return Math.min.apply(null, List);
}
/**
 * 查找引用函数
 * 修改字符串中匹配的第一个字段
 * @param {传入需要查询的字符串} str
 * @param {传入需要查询的字段} str2
 * @param {传入需要更换的字段} str32
 */
export function FINDSTRRPLACE(str, str2, str3) {
	if (typeof str == 'string' && typeof str2 == 'string' && typeof str3 == 'string') {
		str = str.replace(str2, str3);
		return str;
	} else {
		console.log('这不是个字符串');
	}
}
/**
 * 查找引用函数
 * 查找出数组中匹配的第一个数值
 * @param {传入需要查询的数组} arr
 * @param {传入需要查询的内容} data
 */
export function FINDARRAYNUM(arr, data) {
	if (isArray(arr)) {
		if (typeof arr[0] == 'object') {
			let index = arr.findIndex(arr, data);
			if (index == -1) {
				return '数组不存在查询值';
			} else {
				return arr[index];
			}
		}
		let index = arr.indexOf(data);
		if (index == -1) {
			return '数组不存在查询值';
		} else {
			return arr[index];
		}
	} else {
		return '传入值不是数组';
	}
}
/**
 * 兼容性函数
 * 合并2个传入的数组集合
 * @param {传入需要合并的数组} arr
 * @param {传入需要合并的数组} arr1
 */
export function MERGEARRAY(arr, arr1) {
	if (isArray(arr) && isArray(arr1)) {
		const list = [...arr, ...arr1];
		return list;
	} else {
		return '传入值不是数组';
	}
}
/**
 * 兼容性函数
 * 根据传入数组进行拆分成多维数组
 * @param {传入需要拆分的数组} arr
 * @param {传入需要拆分成长度的数值} num
 */
export function SPLITARRAY(arr, num) {
	if (isArray(arr)) {
		let list = chunk(arr, num);
		return list;
	} else {
		return '传入值不是数组';
	}
}
/**
 * 兼容性函数
 * 根据传入数组和切片长度,去除对应长度的数组
 * @param {传入需要拆分的数组} arr
 * @param {传入需要拆分成长度的数值} num
 */
export function REMOVEARRAYDROP(arr, num) {
	if (isArray(arr)) {
		let list = drop(arr, num);
		return list;
	} else {
		return '传入值不是数组';
	}
}
/**
 * 日期和时间函数
 * 根据传入的2个时间戳进行对比,返回时间差值
 * @param {传入需要对比的时间戳} time
 * @param {传入需要对比的时间戳} time1
 * @param {是否需要将时间差值进行转换} isFormat
 */
export function CONTRASTTIME(time, time1, isFormat) {
	if (typeof time1 == 'number' && typeof time == 'number') {
		if (time1 > time) {
			let data = time1 - time;
			if (isFormat) {
				return getTimeMonth(data);
			} else {
				return data;
			}
		} else if (time1 < time) {
			let data = time - time1;
			if (isFormat) {
				return getTimeMonth(data);
			} else {
				return data;
			}
		}
	} else {
		return '传入值不正确';
	}
}
/**
 * 时间戳格式化函数
 */
export function getTimeMonth(time) {
	if (time <= 60000) {
		// 低于1分钟
		return '低于一分钟';
	} else if (60000 <= time && time < 3600000) {
		// 低于1小时 统计分钟数
		return moment(time).format('mm') + '分钟';
	} else if (3600000 <= time && time < 86400000) {
		// 高于一小时,低于一天
		return moment(time).format('hh:mm:ss');
	} else if (86400000 <= time && time < 2592000000) {
		// 大于一天小于一个月
		return moment(time).format('DD天hh:mm:ss');
	} else if (2592000000 < time) {
		// 大于一个月
		return moment(time).format('MM月DD天 hh:mm:ss');
	}
}
/**
 * 日期和时间函数
 * 将传入的时间戳格式化为年月日
 * @param {传入的时间戳} time
 */
export function DATEGETYEAR(time) {
	let data = moment(time).format('YYYY-MM-DD');
	return data;
}
/**
 * 日期和时间函数
 * 将传入的时间戳格式化为月日
 * @param {传入的时间戳} time
 */
export function DATAGETMONTH(time) {
	let data = moment(time).format('MM-DD');
	return data;
}
/**
 * 日期和时间函数
 * 将传入的时间戳格式化为日
 * @param {传入的时间戳} time
 */
export function DATAGETDAY(time) {
	let data = moment(time).format('DD');
	return data;
}
/**
 * 日期和时间函数
 * 将传入的时间戳格式化为时间格式
 * @param {传入的时间戳} time
 */
export function DATAGETTIME(time) {
	let data = moment(time).format('hh:mm:ss');
	return data;
}
/**
 * 日期和时间函数
 * 将传入的时间戳按照自定义格式化为时间格式
 * @param {传入的时间戳} time
 * @param {传入的时间格式化格式} str
 */
export function DATAGETCUSTOM(time, str) {
	let data = moment(time).format(str);
	return data;
}
/**
 * 信息函数
 * 判断传入值的类型并返回
 * @param {需要判断类型的数据} data
 */
export function TYPEOFDATA(data) {
	if (typeof data == 'object') {
		if (isArray(data)) {
			return 'array';
		} else {
			return 'object';
		}
	} else {
		return typeof data;
	}
}
/**
 * 信息函数
 * 发起弹框提示用户信息
 * @param {需要提示用户的信息} str
 */
export function TOASTMESSAGE(str) {
	let width = document.documentElement.clientWidth || document.body.clientWidth;
	if (width < 1200) {
		showToast(str);
	} else {
		openToast('info', '提示', str);
	}
	return '';
}
/**
 * 信息函数
 * 判断传入值是否为NAN
 * @param {传入的需要判断数据} str
 */
export function TYPEOFNAN(str) {
	if (typeof str == 'string') {
		try {
			JSON.parse(str);
			if (typeof JSON.parse(str) === 'number') {
				return false;
			}
			return true;
		} catch (e) {
			return false;
		}
	}
}
/**
 * 统计函数
 * 将传入的数组值,进行累加返回累加总数,如果存在非数字会跳过计算
 * @param {传入的需要累加的数组} ary
 */
export function ARRAYADDNUM(ary) {
	if (isArray(ary)) {
		let sum = 0;
		ary.map((item) => {
			if (isNaN(+item)) {
				return;
			}
			sum += item;
		});
		return sum;
	} else {
		return '传入值非数组';
	}
}
/**
 * 统计函数
 * 将传入的为对象型数组进行指定属性统一累积
 * @param {传入的需要累加的数组} ary
 * @param {指定需要累积的对象key值} str
 */
export function ARRAYOBJECTADD(ary, str) {
	if (isArray(ary)) {
		let sum = 0;
		ary.map((item) => {
			if (isNaN(+item[str])) {
				return;
			}
			sum += item[str];
		});
		return sum;
	} else {
		return '传入值非数组';
	}
}
/**
 * 统计函数
 * 统计传入的字符串总共输入的长度
 * @param {需要统计的字符串长度} str
 */
export function STRINGLEHGTH(str) {
	return str.length;
}
/**
 * 文本函数
 * 将文本域输入的HTML标签转译
 * @param {需要进行转移的文本输入} str
 */
export function TRANSLATIONSTRING(str) {
	str = str.replace(/&/g, '&amp;');
	str = str.replace(/</g, '&lt;');
	str = str.replace(/>/g, '&gt;');
	str = str.replace(/"/g, '&quto;');
	str = str.replace(/'/g, '&#39;');
	str = str.replace(/`/g, '&#96;');
	str = str.replace(/\//g, '&#x2F;');
	str = str.replace(/ /g, '&nbsp;');
	return str;
}
/**
 * 文本函数
 * 将文本域输入的已转译HTML标签反向转译
 * @param {需要进行反向转译的文本输入} str
 */
export function TRANSLATIONSTRINGTWO(str) {
	str = str.replace(/&amp;/g, '&');
	str = str.replace(/&lt;/g, '<');
	str = str.replace(/&gt;/g, '>');
	str = str.replace(/&quto;/g, '"');
	str = str.replace(/&#39;/g, "'");
	str = str.replace(/&#96;/g, '`');
	str = str.replace(/&#x2F;/g, '/');
	str = str.replace(/&nbsp;/g, ' ');
	return str;
}
/**
 * 文本函数
 * 拆分字符串内容成数组
 * @param {需要拆分的字段} str
 */
export function STRINGWORDS(str) {
	if (typeof str == 'string') {
		return words(str);
	} else {
		return '传入值应该为字符串';
	}
}
/**
 * 文本函数
 * 将数组中内容进行拼接返回一个完整字符串,无法拼接则会跳过
 * @param {需要拼接的数组内容} ary
 */
export function TEXTCONCAT(ary) {
	if (isArray(ary)) {
		let str = '';
		ary.map((item) => {
			if (typeof item == 'object') {
				return;
			} else {
				str = `${str}` + `${item}`;
			}
		});
		return str;
	} else {
		return '传入值非数组';
	}
}
/**
 * 文本函数
 * 对比传入的2个字符串是否相同
 * @param {需要对比的字符串} str
 * @param {需要对比的字符串} str1
 */
export function STRINGISSAME(str, str1) {
	return str === str1;
}
/**
 * 文本函数
 * 对比传入的2个字符串对比,查询后面传入值是否存在于第一个参数中
 * @param {需要对比的字符串} str
 * @param {需要对比的字符串} str1
 */
export function STRINGISHAVE(str, str1) {
	let res = str.indexOf(str1);
	if (res == -1) {
		return false;
	} else {
		return true;
	}
}
/**
 * 文本函数
 * 将文本英文转为驼峰写法
 * @param {需要转换的字符串} str
 */
export function STRINGCAMELCASE(str) {
	if (typeof str == 'string') {
		return camelCase(str);
	} else {
		return '这不是个字符串';
	}
}
/**
 * 文本函数
 * 校验传入文本是否按照规定字符结尾
 * @param {需要校验的字符串} str
 * @param {需要校验的字符规则} str1
 */
export function STRINGVERIFY(str, str1) {
	if (typeof str == 'string' && typeof str1 == 'string') {
		return endsWith(str, str1);
	} else {
		return '传入值不是字符串';
	}
}
/**
 * 工程函数
 * 十进制转换8进制
 * @param { 需要转换的十进制} num
 */
export function TENSCALETOEIGHT(num) {
	if (typeof num == 'number') {
		return parseInt(num).toString(8);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 十进制转换16进制
 * @param { 需要转换的十进制} num
 */
export function TENSCALETOSIXTEEN(num) {
	if (typeof num == 'number') {
		return parseInt(num).toString(16);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 十进制转换2进制
 * @param { 需要转换的十进制} num
 */
export function TENSCALETOTWO(num) {
	if (typeof num == 'number') {
		return parseInt(num).toString(2);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 自定义十进制转换
 * @param {需要转换的十进制} num
 * @param {自定义的进制转换} num1
 */
export function TENSCALETOMANY(num, num1) {
	if (typeof num == 'number' && typeof num1 == 'number') {
		return parseInt(num).toString(num1);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 八进制到十进制转换
 * @param {需要转换的八进制} num
 */
export function EIGHTSCALETOTEN(num) {
	if (typeof num == 'number') {
		return parseInt(num, 8);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 八进制到十六进制转换
 * @param {需要转换的八进制} num
 */
export function EIGHTSCALETOSIXTEEN(num) {
	if (typeof num == 'number') {
		return parseInt(num, 8).toString(16);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 八进制到二进制转换
 * @param {需要转换的八进制} num
 */
export function EIGHTSCALETOTWO(num) {
	if (typeof num == 'number') {
		return parseInt(num, 8).toString(2);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 八进制到自定义机制转换
 * @param {需要转换的八进制} num
 * @param {自定义的进制转换} num1
 */
export function EIGHTSCALETOMANY(num, num1) {
	if (typeof num == 'number' && typeof num1 == 'number') {
		return parseInt(num, 8).toString(num1);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 十六进制转二进制
 * @param {需要转换的十六进制} num
 */
export function SIXTEENSCALETOTWO(num) {
	if (typeof num == 'number') {
		return parseInt(num, 16).toString(2);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 十六进制转八进制
 * @param {需要转换的十六进制} num
 */
export function SIXTEENSCALETOEIGHT(num) {
	if (typeof num == 'number') {
		return parseInt(num, 16).toString(8);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 十六进制转十进制
 * @param {需要转换的十六进制} num
 */
export function SIXTEENSCALETOTEN(num) {
	if (typeof num == 'number') {
		return parseInt(num, 16);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 工程函数
 * 十六进制转自定义进制
 * @param {需要转换的十六进制} num
 * @param {自定义的进制转换} num1
 */
export function SIXTEENSCALETOMANY(num, num1) {
	if (typeof num == 'number' && typeof num1 == 'number') {
		return parseInt(num, 16).toString(num1);
	} else {
		return '传入值不是数字';
	}
}
/**
 * 逻辑函数
 * 检查传入数组所有值是否存在值,存在控制返回true
 * @param {需要检查的数组} ary
 */
export function LOGICARRAY(ary) {
	if (isArray(ary)) {
		let isHave = true;
		ary.map((item) => {
			if (!!item == false) {
				isHave = false;
			}
		});
		return isHave;
	} else {
		return '传入值不是数组';
	}
}
/**
 * 逻辑函数
 * 检查数值是否存在指定值,存在则返回
 * @param {需要检查的数组} ary
 * @param {需要检查的指定值} res
 */
export function LOGICARRAYFILTER(ary, res) {
	if (isArray(ary)) {
		let data;
		data = ary.filter((item) => item == res);
		if (data.length > 0) {
			return data;
		} else {
			return '不存在指定值';
		}
	} else {
		return '传入值不是数组';
	}
}
/**
 * 多维数据集函数
 * 检查传入数组中对象,并根据指定数字属性进行从大到小排序
 * @param {需要排序的数组} ary
 * @param {需要排序的对象指定值} name
 */
export function ARRAYSORTONJECT(ary, name) {
	function sortList(obj1, obj2) {
		var a = obj1[name];
		var b = obj2[name];
		if (a > b) {
			return -1;
		} else if (a < b) {
			return 1;
		} else {
			return 0;
		}
	}
	if (isArray(ary)) {
		return ary.sort(sortList);
	} else {
		return '传入值不是数组';
	}
}
/**
 * 多维数据集函数
 * 检查传入数组中对象,并根据指定数字属性进行从小到大排序
 * @param {需要排序的数组} ary
 * @param {需要排序的对象指定值} name
 */
export function ARRAYSORTONJECTTWO(ary, name) {
	function sortList(obj1, obj2) {
		var a = obj1[name];
		var b = obj2[name];
		if (a < b) {
			return -1;
		} else if (a > b) {
			return 1;
		} else {
			return 0;
		}
	}
	if (isArray(ary)) {
		return ary.sort(sortList);
	} else {
		return '传入值不是数组';
	}
}
/**
 * 多维数据集函数
 * 检查传入对象,并进行转换为数组
 * @param {需要转换的对象} obj
 */
export function OBJECTTOARRY(obj) {
	let arr = [];
	for (let i in obj) {
		let o = {};
		o[i] = obj[i];
		arr.push(o);
	}
	return arr;
}
/**
 * 多维数据集函数
 * 检查传入对象,获取需要的指定key值
 * @param {需要操作的对象} obj
 * @param {获取数组中指定的key值} ary
 */
export function OBJECTGETKEY(obj, ary) {
	if (isArray(ary)) {
		return pick(obj, ary);
	} else {
		return '获取key值需传入数组';
	}
}
/**
 * 多维数据集函数
 * 传入多维数组,并对子数组中数值排序进行,非子数组则会跳过
 * @param {需要排序的多维数组} ary
 * @param {是否从大到小排序} isSort
 */
export function ARRAYMANYSORT(ary, isSort = true) {
	function sortList(a, b) {
		if (isSort) {
			if (a > b) {
				return -1;
			} else if (a < b) {
				return 1;
			} else {
				return 0;
			}
		} else {
			if (a < b) {
				return -1;
			} else if (a > b) {
				return 1;
			} else {
				return 0;
			}
		}
	}
	if (isArray(ary)) {
		ary.map((item) => {
			if (isArray(item)) {
				return item.sort(sortList);
			} else {
				return;
			}
		});
		return ary;
	} else {
		return '传入值应为数组';
	}
}
/**
 * 多维数据集函数
 * 传入多维数组,并对子数组中对象进行拆分成数组,非子数组则会跳过
 * @param {需要拆分的多维数组} ary
 */
export function ARRAYSPLITOBJECT(ary) {
	if (isArray(ary)) {
		let data = ary.map((item) => {
			if (isArray(item)) {
				let newAry = item.map((res) => {
					if (Object.prototype.toString.call(res) == '[object Object]') {
						let arr = [];
						for (let i in res) {
							let o = {};
							o[i] = res[i];
							arr.push(o);
						}
						return arr;
					}
					return res;
				});
				return newAry;
			} else {
				return item;
			}
		});
		return data;
	} else {
		return '应传入一个数组';
	}
}
/**
 * 数组操作函数
 * 创建一个新数组，包含原数组中所有的非假值元素。例如false, null, 0, "", undefined, 和 NaN 都是被认为是“假值”。
 * @param {Array} ary 筛选数组
 */
export function ArrayScreenFalse(ary) {
	if (isArray(ary)) {
		return compact(ary);
	} else {
		console.log('传入值非数组');
	}
}
/**
 * 数组操作函数
 * 创建一个新数组，将array与任何数组 或 值连接在一起。
 * @param { Array } ary 连接数组
 * @param { any  } data 连接入数组的值
 */
export function ArrayConcatData(ary, data) {
	if (isArray(ary)) {
		return concat(ary, data);
	} else {
		console.log('连接值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个新数组，这个数组中的值，为第一个数字（array 参数）排除了给定数组中的值。
 * @param { Array } ary 需要被筛选的数组
 * @param { Array } ary2 被筛选除外的值
 */
export function ArrayDifference(ary, ary2) {
	if (isArray(ary) && isArray(ary2)) {
		return difference(ary, ary2);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 iteratee （注：迭代器）， 调用array 和 values 中的每个元素以产生比较的标准。 结果值是从第一数组中选择。
 * @param { Array } ary 需要被筛选的数组
 * @param { Array } ary2 排除的值。
 * @param { Array|Function|Object|string } data 调用每个元素。
 * @returns { Array } 返回筛选后的数组
 */
export function ArrayDifferenceBy(ary, ary2, data) {
	if (isArray(ary) && isArray(ary2)) {
		return differenceBy(ary, ary2, data);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 比较array，values中的元素。 结果值是从第一数组中选择。
 * @param { Array } ary 要检查的数组
 * @param { Array } ary2 要排除的值
 * @returns { Array } 返回一个新数组
 */
export function ArrayDifferenceWith(ary, ary2) {
	if (isArray(ary) && isArray(ary2)) {
		return differenceWith(ary, ary2, isEqual);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个切片数组，去除array尾部的n个元素。（n默认值为1。）
 * @param { Array } ary 要查询的数组。
 * @param { number } num 要去除的元素个数。
 * @returns { Array } 返回一个新数组
 */
export function ArrayDropRight(ary, num) {
	if (isArray(ary)) {
		return dropRight(ary, num);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个切片数组，去除array中从 predicate 返回假值开始到尾部的部分。
 * @param { Array } ary 要查询的数组。
 * @param { function } func 查询规则
 * @returns { Array } 返回一个新数组
 */
export function ArrayDropRightWhile(ary, func) {
	if (isArray(ary)) {
		return dropRightWhile(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个切片数组，去除array中从 predicate 返回假值开始到尾部的部分。
 * @param { Array } ary 要查询的数组。
 * @param { function } func 查询规则
 * @returns { Array } 返回一个新数组
 */
export function ArrayDropWhile(ary, func) {
	if (isArray(ary)) {
		return dropWhile(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 使用 value 值来填充（替换） array，从start位置开始, 到end位置结束（但不包含end位置）。
 * @param { Array } ary 要查询的数组.
 * @param { * } data 填充给 array 的值。
 * @param { number } start 开始位置（默认0）。
 * @param { number } end 结束位置
 * @returns { Array } 返回一个新数组
 */
export function ArrayFill(ary, data, start = 0, end) {
	if (isArray(ary)) {
		return fill(ary, data, start);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 该方法返回第一个通过 predicate 判断为真值的元素的索引值（index），而不是元素本身。
 * @param { Array } ary 要查询的数组.
 * @param { function } func 查询规则
 * @returns { Array } 返回一个新数组
 */
export function ArrayFindIndex(ary, func) {
	if (isArray(ary)) {
		return findIndex(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 该方法从末尾查询返回第一个通过 predicate 判断为真值的元素的索引值（index），而不是元素本身。
 * @param { Array } ary 要查询的数组.
 * @param { function } func 查询规则
 * @returns { Array } 返回一个新数组
 */
export function ArrayFindLastIndex(ary, func) {
	if (isArray(ary)) {
		return findLastIndex(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 获取数组第一个元素
 * @param {Array} ary 要查询的数组
 * @returns {*}  返回数组 array的第一个元素。
 */
export function ArrayHead(ary) {
	if (isArray(ary)) {
		return head(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 减少一级array嵌套深度。
 * @param {Array} ary 要减少嵌套深度的数组
 */
export function ArrayFlatten(ary) {
	if (isArray(ary)) {
		return flatten(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 将array递归为一维数组。
 * @param {Array} ary 要清除嵌套深度的数组
 * @returns { Array } 一维数组
 */
export function ArrayFlattenDeep(ary) {
	if (isArray(ary)) {
		return flattenDeep(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 减少指定层级array嵌套深度。
 * @param { Array } ary 减少指定层级array嵌套深度。
 * @param { number } num 最多减少的嵌套层级数。
 * @returns { Array } 返回减少嵌套层级后的新数组。
 */
export function ArrayFlattenDepth(ary, num) {
	if (isArray(ary)) {
		return flattenDepth(ary, num);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 将数组pairs格式化为对象
 * @param { Array } ary 键值对pairs。
 * @returns { object } 返回一个新对象。
 */
export function ArrayFromPairs(ary) {
	if (isArray(ary)) {
		return fromPairs(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 返回首次 value 在数组array中被找到的 索引值， 如果 fromIndex 为负值，将从数组array尾端索引进行匹配。
 * @param { Array } ary  需要查找的数组。
 * @param { * } data 需要查找的值
 * @param { numbre } num 开始查询的位置。
 * @returns 返回 值value在数组中的索引位置, 没有找到为返回-1。
 */
export function ArrayIndexOf(ary, data, num = 0) {
	if (isArray(ary)) {
		return indexOf(ary, data, num);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 获取数组array中除了最后一个元素之外的所有元素（注：去除数组array中的最后一个元素）。
 * @param { Array } ary 需要查找的数组。
 * @returns 返回截取后的数组array。
 */
export function ArrayInitial(ary) {
	if (isArray(ary)) {
		return initial(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建唯一值的数组，这个数组包含所有给定数组都包含的元素，
 * @param { Array } ary 待检查的数组
 * @returns 返回一个包含所有传入数组交集元素的新数组。
 */
export function ArrayIntersection(ary) {
	if (isArray(ary)) {
		return intersection(...ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 iteratee 调用每一个arrays的每个值以产生一个值，通过产生的值进行了比较。结果值是从第一数组中选择。
 * @param { Array } ary 待检查的数组
 * @param { function } func 查询规则
 * @returns  返回一个包含所有传入数组交集元素的新数组。
 */
export function ArrayIntersectionBy(ary, func) {
	if (isArray(ary)) {
		return intersectionBy(...ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 comparator 调用比较arrays中的元素。结果值是从第一数组中选择。
 * @param { Array } ary 待检查的数组
 * @returns  返回一个包含所有传入数组交集元素的新数组。
 */
export function ArrayIntersectionWith(ary) {
	if (isArray(ary)) {
		return intersectionBy(...ary, isEqual);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 将 array 中的所有元素转换为由 separator 分隔的字符串。
 * @param { Array } ary 待转换的数组
 * @param { string } str 分割元素
 * @returns 返回连接字符串。
 */
export function ArrayJoin(ary, str = ',') {
	if (isArray(ary)) {
		return join(ary, str);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 获取array中的最后一个元素。
 * @param { Array } ary 要检索的数组
 */
export function ArrayLast(ary) {
	if (isArray(ary)) {
		return last(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它是从右到左遍历array的元素。返回查找到的元素
 * @param { Array } ary 待查找数组
 * @param {*} value 要搜索的值
 * @param {number} startIndex 开始搜索的下标值 默认 最后位
 * @returns 返回匹配值的索引值，否则返回 -1。
 */
export function ArrayLastIndexOf(ary, value, startIndex) {
	if (isArray(ary)) {
		if (startIndex) {
			return lastIndexOf(ary, value, startIndex);
		}
		return lastIndexOf(ary, value);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 获取array数组的第n个元素。如果n为负数，则返回从数组结尾开始的第n个元素。
 * @param { Array } ary 要查询的数组。
 * @param { number } num  要返回元素的索引值。
 * @returns { * }  获取array数组的第n个元素。
 */
export function ArrayNth(ary, num) {
	if (isArray(ary)) {
		return nth(ary, num);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 移除数组array中所有和给定值相等的元素，使用 SameValueZero 进行全等比较。 会修改传入数组
 * @param { Array } ary 要修改的数组。
 * @param { value } value 需要删除的值 可多个
 * @returns { Array }  返回 array.
 */
export function ArrayPull(ary, ...value) {
	if (isArray(ary)) {
		return pull(ary, ...value);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 移除数组array中所有和给定值相等的元素，使用 SameValueZero 进行全等比较。区别是这个方法接收一个要移除值的数组。 会修改传入数组
 * @param { Array } ary 要修改的数组。
 * @param { Array } ary2 要移除值的数组。
 * @returns { Array }  返回 array.
 */
export function ArrayPullAll(ary, ary2) {
	if (isArray(ary) && isArray(ary2)) {
		return pullAll(ary, ary2);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 这个方法接受一个 iteratee（迭代函数） 调用 array 和 values的每个值以产生一个值，通过产生的值进行了比较。 会修改传入数组
 * @param { Array } ary 要修改的数组。
 * @param { Array } ary2 要移除值的数组。
 * @param { Array|Function|Object|string } value（迭代器）调用每个元素。
 * @returns { Array }  返回 array.
 */
export function ArrayPullAllBy(ary, ary2, value) {
	if (isArray(ary) && isArray(ary2)) {
		if (value) {
			return pullAllBy(ary, ary2, value);
		}
		return pullAllBy(ary, ary2);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 这个方法接受 comparator 调用array中的元素和values比较。
 * @param { Array } ary 要修改的数组。
 * @param { Array } ary2 要移除值的数组。
 * @returns { Array }  返回 array.
 */
export function ArrayPullAllWith(ary, ary2) {
	if (isArray(ary) && isArray(ary2)) {
		return pullAllWith(ary, ary2, isEqual);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 根据索引 indexes，移除array中对应的元素，并返回被移除元素的数组。 会修改传入数组
 * @param { Array } ary 要修改的数组。
 * @param { number } value 要移除元素的索引。
 */
export function ArrayPullAt(ary, value) {
	if (isArray(ary)) {
		let newAry = [];
		ary.map((item, index) => {
			if (index === value) {
				return item;
			}
			newAry.push(item);
			return item;
		});
		return newAry;
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 移除数组中predicate（断言）返回为真值的所有元素，并返回移除元素组成的数组。
 * @param { Array } ary 要修改的数组。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns { Array }  返回移除元素组成的新数组。
 */
export function ArrayRemove(ary, func) {
	if (isArray(ary)) {
		remove(ary, func);
		return ary;
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 反转array，使得第一个元素变为最后一个元素，第二个元素变为倒数第二个元素，依次类推。
 * @param { Array } ary 要反转的数组
 * @returns { Array } 返回反转组成的新数组。
 */
export function ArrayReverse(ary) {
	if (isArray(ary)) {
		let nAry = [...ary];
		reverse(nAry);
		return nAry;
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 裁剪数组array，从 start 位置开始到end结束，但不包括 end 本身的位置
 * @param { Array } ary 要裁剪的数组
 * @param { number } start 开始的位置
 * @param { number } end 结束的位置
 * @returns 返回 数组array 裁剪部分的新数组。
 */
export function ArraySlice(ary, start = 0, end) {
	if (isArray(ary)) {
		if (end) {
			return slice(ary, start, end);
		} else {
			return slice(ary, start);
		}
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 使用二进制的方式检索来决定 value值 应该插入到数组中 尽可能小的索引位置，以保证array的排序。
 * @param { Array } ary 要检查的排序数组。
 * @param { * } value 要评估的值
 * @returns 返回 value值 应该在数组array中插入的索引位置 index。
 */
export function ArraySortedIndex(ary, value) {
	if (isArray(ary)) {
		return sortedIndex(ary, value);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 iteratee （迭代函数），调用每一个数组（array）元素，返回结果和value 值比较来计算排序
 * @param { Array } ary 要检查的排序数组
 * @param { * } value  要评估的值。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回 value值 应该在数组array中插入的索引位置 index。
 */
export function ArraySortedIndexBy(ary, value, func) {
	if (isArray(ary)) {
		return sortedIndexBy(ary, value, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 这个方法类似 _.indexOf，除了它是在已经排序的数组array上执行二进制检索。
 * @param { Array } ary 要检查的排序数组
 * @param { * } value 要检查的值
 * @returns 返回匹配值的索引位置，否则返回 -1。
 */
export function ArraySortedIndexOf(ary, value) {
	if (isArray(ary)) {
		return sortedIndexOf(ary, value);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它返回 value值 在 array 中尽可能大的索引位置（index）。
 * @param { Array } ary 要检查的排序数组
 * @param { * } value 要检查的值
 * @returns 返回匹配值的索引位置，否则返回 -1。
 */
export function ArraySortedLastIndex(ary, value) {
	if (isArray(ary)) {
		return sortedLastIndex(ary, value);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 iteratee （迭代函数），调用每一个数组（array）元素，返回结果和value 值比较来计算排序。
 * @param { Array } ary 要检查的排序数组
 * @param { * } value 要评估检查的值
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回 value值 应该在数组array中插入的索引位置 index。
 */
export function ArraySortedLastIndexBy(ary, value, func) {
	if (isArray(ary)) {
		return sortedLastIndexBy(ary, value, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它是在已经排序的数组array上执行反向二进制检索。
 * @param { Array } ary 要检查的排序数组
 * @param { * } value 要检查的值
 * @returns 返回匹配值的索引位置，否则返回 -1。
 */
export function ArraySortedLastIndexOf(ary, value) {
	if (isArray(ary)) {
		return sortedLastIndexOf(ary, value);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它会优化排序数组,返回一个不重复数组
 * @param { Array } ary 要检查的排序数组
 * @returns 返回一个新的不重复的数组。
 */
export function ArraySortedUniq(ary) {
	if (isArray(ary)) {
		return sortedUniq(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它会根据指定规则优化排序数组。,返回一个不重复数组
 * @param { Array } ary 要检查的数组。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 迭代函数，调用每个元素。
 */
export function ArraySortedUniqBy(ary, func) {
	if (isArray(ary)) {
		return sortedUniqBy(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 获取除了array数组第一个元素以外的全部元素。
 * @param { Array } ary 要检查的数组。
 * @returns 返回 array 数组的切片（除了array数组第一个元素以外的全部元素）。
 */
export function ArrayTail(ary) {
	if (isArray(ary)) {
		return tail(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个数组切片，从array数组的起始元素开始提取n个元素。
 * @param { Array } ary 要检索的数组
 * @param { number } num 要提取的元素个数。
 * @returns 返回 array 数组的切片（从起始元素开始n个元素）。
 */
export function ArrayTake(ary, num) {
	if (isArray(ary)) {
		return take(ary, num);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个数组切片，从array数组的最后一个元素开始提取n个元素。
 * @param { Array } ary 要检索的数组
 * @param { number } num 要提取的元素个数
 * @returns 返回 array 数组的切片（从最后元素开始n个元素）。
 */
export function ArrayTakeRight(ary, num) {
	if (isArray(ary)) {
		return takeRight(ary, num);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 从array数组的最后一个元素开始提取元素，直到规则返回假值。
 * @param { Array } ary 要检索的数组
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回 array 数组的切片。
 */
export function ArrayTakeRightWhile(ary, func) {
	if (isArray(ary)) {
		return takeRightWhile(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 从array数组的起始元素开始提取元素，，直到 规则 返回假值。
 * @param { Array } ary 要检索的数组
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回 array 数组的切片。
 */
export function ArrayTakeWhile(ary, func) {
	if (isArray(ary)) {
		return takeWhile(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个按顺序排列的唯一值的数组。所有给定数组的元素值做等值比较。
 * @param { Array } ary 要检查的数组
 * @returns 返回一个新的联合数组。
 */
export function ArrayUnion(...ary) {
	return union(...ary);
}
/**
 * 数组操作函数
 * 它接受一个 iteratee （迭代函数），调用每一个数组（array）的每个元素以产生唯一性计算的标准。
 * @param { Array } ary  要检查的数组。
 * @param { Array|Function|Object|string } func 迭代函数，调用每个元素。
 * @returns  返回一个新的联合数组。
 */
export function ArrayUnionBy(ary, func) {
	if (isArray(ary)) {
		return unionBy(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/***
 * 数组操作函数
 * 它接受一个 comparator 调用比较arrays数组的每一个元素。
 * @param { Array } ary 要检查的多个数组
 * @returns  返回一个新的联合数组。
 */
export function ArrayUnionWith(...ary) {
	if (isArray(ary)) {
		return unionWith(...ary, isEqual);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个去重后的array数组副本。只有第一次出现的元素才会被保留。
 * @param { Array } ary 要检查的数组。
 * @returns  返回新的去重后的数组。
 */
export function ArrayUniq(ary) {
	if (isArray(ary)) {
		return uniq(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 iteratee （迭代函数），调用每一个数组（array）的每个元素以产生唯一性计算的标准。
 * @param { Array } ary 要检查的数组。
 * @param { Array|Function|Object|string } func 迭代函数，调用每个元素。
 * @returns 返回新的去重后的数组。
 */
export function ArrayUniqBy(ary, func) {
	if (isArray(ary)) {
		return uniqBy(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 comparator 调用比较arrays数组的每一个元素
 * @param { Array } ary 要检查的数组。
 * @returns 返回新的去重后的数组。
 */
export function ArrayUniqWith(ary) {
	if (isArray(ary)) {
		return uniqWith(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接收分组元素的数组，并且创建一个数组，分组元素到打包前的结构。
 * @param { Array } ary 要处理的分组元素数组。
 * @returns 返回重组元素的新数组。
 */
export function ArrayUnzip(...ary) {
	if (isArray(ary)) {
		return unzip(ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个iteratee指定重组值应该如何被组合。
 * @param { Array } ary 要处理的分组元素数组。
 * @param { Array|Function|Object|string } func 迭代函数，调用每个元素。
 * @returns 这个函数用来组合重组的值。
 */
export function ArrayUnzipWidth(ary, func) {
	if (isArray(ary)) {
		return unzipWith(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个剔除所有给定值的新数组，
 * @param { Array } ary 要处理的分组元素数组。
 * @param { any } value 要剔除的值。
 * @returns 返回过滤值后的新数组。
 */
export function ArrayWithout(ary, ...value) {
	if (isArray(ary)) {
		return without(ary, ...value);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个给定数组唯一值的数组，返回值的顺序取决于他们数组的出现顺序,返回过滤后的新数组
 * @param { Array } ary 要检查的数组。
 * @returns 返回过滤值后的新数组。
 */
export function ArrayXor(...ary) {
	if (isArray(ary)) {
		return xor(...ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受 迭代器，这个迭代器 调用每一个 arrays（数组）的每一个值，以生成比较的新值。
 * @param { Array } ary 要检查的数组组。
 * @param { Array|Function|Object|string } func 迭代函数，调用每个元素。
 * @returns 返回过滤值后的新数组。
 */
export function ArrayXorBy(ary, func) {
	if (isArray(ary)) {
		return xorBy(...ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 接收对象进行相同筛选，以调用比较数组的元素。
 * @param { Array } ary 要检查的数组组。
 * @param { Array|Function|Object|string } func 迭代函数，调用每个元素。
 * @returns 返回过滤值后的新数组。
 */
export function ArrayXorWith(ary, func) {
	if (isArray(ary)) {
		return xorWith(...ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 创建一个分组元素的数组，数组的第一个元素包含所有给定数组的第一个元素，数组的第二个元素包含所有给定数组的第二个元
 * @param { Array } ary 要合并分组的数组组
 * @returns 返回分组元素的新数组。
 */
export function ArrayZip(...ary) {
	if (isArray(ary)) {
		return zip(...ary);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受2个数组，第一个数组中的值作为属性标识符（属性名），第二个数组中的值作为相应的属性值。
 * @param { Array } ary 作为对象标识符数组
 * @param { Array } ary2 作为属性值数组
 * @returns 返回新对象
 */
export function ArrayZipObject(ary, ary2) {
	if (isArray(ary) && isArray(ary2)) {
		return zipObject(ary, ary2);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它支持属性路径接受2个数组，第一个数组中的值作为属性标识符（属性名），第二个数组中的值作为相应的属性值。
 * @param { Array } ary 作为对象标识符(属性名)数组
 * @param { Array } ary2 作为属性值数组
 * @returns 返回新对象
 */
export function ArrayZipObjectDeep(ary, ary2) {
	if (isArray(ary) && isArray(ary2)) {
		return zipObjectDeep(ary, ary2);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 数组操作函数
 * 它接受一个 iteratee（迭代函数），来 指定分组的值应该如何被组合。 该iteratee调用每个组的元素
 * @param { Array } ary  要处理的数组组。
 * @param { Function } func 函数用来组合分组的值。
 * @returns 返回分组元素的新数组。
 */
export function ArrayZipWith(ary, func) {
	if (isArray(ary)) {
		return zipWith(...ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 集合操作函数
 * 创建一个组成对象，key（键）是经过 iteratee（迭代函数） 执行处理collection中每个元素后返回的结果，每个key（键）对应的值是 iteratee（迭代函数）返回该key（键）的次数
 * @param { Array } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 一个迭代函数，用来转换key（键）
 * @returns { Object } 返回一个组成集合对象。
 */
export function CollectCountBy(ary, func) {
	if (isArray(ary)) {
		return countBy(ary, func);
	} else {
		console.log('传入值必须为数组');
	}
}
/**
 * 集合操作函数
 * 调用 iteratee 遍历 collection(集合) 中的每个元素，如果迭代函数（iteratee）显式的返回 false ，迭代会提前退出。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Function } func 函数用来组合分组的值。
 * @returns  返回集合 collection。
 */
export function CollectForEach(ary, func) {
	return forEach(ary, func);
}
/**
 * 集合操作函数
 * 调用 iteratee 反方向遍历 collection(集合) 中的每个元素，如果迭代函数（iteratee）显式的返回 false ，迭代会提前退出。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Function } func 函数用来组合分组的值。
 * @returns  返回集合 collection。
 */
export function CollectForEachRight(ary, func) {
	return forEachRight(ary, func);
}
/**
 * 集合操作函数
 * 通过 predicate（断言函数） 检查 collection（集合）中的 所有 元素是否都返回真值。一旦 predicate（断言函数） 返回假值，迭代就马上停止。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 如果所有元素经 predicate（断言函数） 检查后都都返回真值，那么就返回true，否则返回 false 。
 */
export function CollectEvery(ary, func) {
	return every(ary, func);
}
/**
 * 集合操作函数
 * 遍历 collection（集合）元素，返回 predicate（断言函数）返回真值 的所有元素的数组。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回一个新的过滤后的数组。
 */
export function CollectFilter(ary, func) {
	return filter(ary, func);
}
/**
 * 集合操作函数
 * 遍历 collection（集合）元素，返回 predicate（断言函数）第一个返回真值的第一个元素。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @param { number } num 开始搜索的索引位置。
 * @returns 返回匹配元素，否则返回 undefined。
 */
export function CollectFind(ary, func, num) {
	return find(ary, func, num);
}
/**
 * 集合操作函数
 * 遍历 collection（集合）元素，从右至左返回 predicate（断言函数）第一个返回真值的第一个元素。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @param { number } num 开始搜索的索引位置。
 * @returns 返回匹配元素，否则返回 undefined。
 */
export function CollectFindLast(ary, func, num) {
	return findLast(ary, func, num);
}
/**
 * 集合操作函数
 * 创建一个扁平化（注：同阶数组）的数组，这个数组的值来自collection（集合）中的每一个值经过 iteratee（迭代函数） 处理后返回的结果，并且扁平化合并。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回新扁平化数组。
 */
export function CollectFlatMap(ary, func) {
	return flatMap(ary, func);
}
/**
 * 集合操作函数
 * 创建一个扁平化（注：同阶数组）的数组，这个数组的值来自collection（集合）中的每一个值经过 iteratee（迭代函数） 处理后返回的结果，并且多层扁平化合并。
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回新扁平化数组。
 */
export function CollectFlatMapDeep(ary, func) {
	return flatMapDeep(ary, func);
}
/**
 * 集合操作函数
 * 创建一个扁平化（注：同阶数组）的数组，这个数组的值来自collection（集合）中的每一个值经过 iteratee（迭代函数） 处理后返回的结果，并且根据指定的 depth（递归深度）继续扁平化递归映射结果
 * @param { Array|Object } ary 一个用来迭代的集合。
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @param { number } num 最大递归深度。
 */
export function CollectFlatMapDepth(ary, func, num) {
	return flatMapDepth(ary, func, num);
}
/**
 * 断言操作函数
 * 如果 value 不是数组, 那么强制转为数组。
 * @param { * } value 要处理的值。
 * @returns { Array } 返回转换后的数组。
 */
export function LangCastArray(value) {
	return castArray(value);
}
/**
 * 断言操作函数
 * 创建一个 value 的浅拷贝。
 * @param { * } value 要拷贝的值
 * @returns 拷贝后的数据
 */
export function LangClone(value) {
	return clone(value);
}
/**
 * 断言操作函数
 * 递归拷贝数据
 * @param { * } value 要拷贝的值
 * @returns 深拷贝后的数据
 */
export function LangCloneDeep(value) {
	return cloneDeep(value);
}
/**
 * 断言操作函数
 * 深度克隆数据
 * @param { * } value 用来递归克隆的值
 * @param { Array|Function|Object|string } func 每次迭代调用的函数。
 * @returns 返回深度克隆的值
 */
export function LangCloneDeepWith(value, func) {
	return cloneDeepWith(value, func);
}
/**
 * 断言操作函数
 * 递归拷贝数据,它接受一个 customizer 定制返回的克隆值。 如果 customizer 返回 undefined 将会使用拷贝方法代替处理
 * @param { * } value 用来递归克隆的值
 * @param { Array|Function|Object|string } func 用来自定义克隆的函数。
 * @returns 返回克隆值。
 */
export function LangCloneWith(value, func) {
	return cloneWith(value, func);
}
/**
 * 断言操作函数
 * 通过调用断言对象的属性与 对象 的相应属性值，检查对象是否符合 断言。
 * @param { Object } obj 要检查的对象。
 * @param { Object } obj2 要断言属性是否符合的对象。
 * @returns { Object } 如果 object 符合，返回 true，否则 false。
 */
export function LangConformsTo(obj, obj2) {
	return conformsTo(obj, obj2);
}
/**
 * 断言操作函数
 * 比较两者的值，来确定它们是否相等。如果两个值相等返回 true ，否则返回 false 。
 * @param { * } value 要比较的值。
 * @param { * } other 另一个要比较的值。
 * @returns 如果两个值相等返回 true ，否则返回 false 。
 */
export function LangEq(value, other) {
	return eq(value, other);
}
/**
 * 断言操作函数
 * 检查 value 是否是一个类 arguments 对象(伪数组)。
 * @param { * } value 要检查的值。
 * @returns { Boolean }  如果value是一个 arguments 对象 返回 true，否则返回 false。
 */
export function LangIsArguments(value) {
	return isArguments(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是 Array 类对象。
 * @param { * } value 要检查的值。
 * @returns { Boolean } 如果value是一个数组返回 true，否则返回 false。
 */
export function LangIsArray(value) {
	return LIsArray(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是 Array 类对象。
 * @param { * } value 要检查的值
 * @returns { Boolean }  如果value是一个数组 buffer 返回 true，否则返回 false。
 */
export function LangIsArrayBuffer(value) {
	return isArrayBuffer(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是原始 boolean 类型或者对象
 * @param { * } value 要检查的值
 * @returns { Boolean } 如果 value 是一个布尔对象，那么返回 true，否则返回 false。
 */
export function LangIsBooean(value) {
	return isBoolean(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是 Date 对象。
 * @param { * } value 要检查的值
 * @returns { Boolean } 如果 value 是一个日期对象，那么返回 true，否则返回 false。
 */
export function LangIsDate(value) {
	return isDate(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是可能是 DOM 元素。
 * @param { * } value 要检查的值
 * @returns { Boolean } 如果 value 是一个DOM元素，那么返回 true，否则返回 false。
 */
export function LangIsElement(value) {
	return isElement(value);
}
/**
 * 断言操作函数
 * 检查 value 是否为一个空对象，集合，映射或者set。
 * @param { * } value 要检查的值
 * @returns { Boolean }  如果 value 为空，那么返回 true，否则返回 false。
 */
export function LangIsEmpty(value) {
	return isEmpty(value);
}
/**
 * 断言操作函数
 * 执行深比较来确定两者的值是否相等。
 * @param { * } obj 用来比较的值。
 * @param { * } obj1 另一个用来比较的值。
 * @returns  如果 两个值完全相同，那么返回 true，否则返回 false。
 */
export function LangIsEqual(obj, obj1) {
	return isEqual(obj, obj1);
}
/**
 * 断言操作函数
 * 它接受一个对比函数用来定制比较值。如果对比函数返回 undefined 将会比较处理方法代替。
 * @param { * } obj 用来比较的值。
 * @param { * } obj1 另一个用来比较的值。
 * @param { Function } func 用来定制比较值的函数。
 * @returns 如果 两个值完全相同，那么返回 true，否则返回 false。
 */
export function LangIsEqualWith(obj, obj1, func) {
	return isEqualWith(obj, obj1, func);
}
/**
 * 断言操作函数
 * 检查 value 是否是 Error, EvalError, RangeError, ReferenceError, SyntaxError, TypeError, 或者 URIError对象。
 * @param { * } value 要检查的值
 * @returns  如果 value 是一个错误（Error）对象，那么返回 true，否则返回 false。
 */
export function LangIsError(value) {
	return isError(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是原始有限数值。
 * @param { * } value 要检查的值
 * @returns 如果 value 是一个有限数值，那么返回 true，否则返回 false。
 */
export function LangIsFinite(value) {
	return isFinite(value);
}

/**
 * 断言操作函数
 * 检查 value 是否是 Function 对象。
 * @param { * } value 要检查的值
 * @returns 如果 value 是一个函数，那么返回 true，否则返回 false。
 */
export function LangIsFunction(value) {
	return isFunction(value);
}

/**
 * 断言操作函数
 * 检查 value 是否为一个整数。
 * @param { * } value 要检查的值
 * @returns 如果 value 是一个整数，那么返回 true，否则返回 false。
 */
export function LangIsInteger(value) {
	return isInteger(value);
}
/**
 * 断言操作函数
 * 检查 value 是否为一个 Map 对象。
 * @param { * } value 要检查的值
 * @returns 如果 value 是一个 Map 对象，那么返回 true，否则返回 false。
 */
export function LangIsMap(value) {
	return isMap(value);
}
/**
 * 断言操作函数
 * 执行一个深度比较，来确定 object 是否含有和 source 完全相等的属性值。
 * @param { * } value 要检查的对象。
 * @param { * } obj 属性值相匹配的对象。
 * @returns 如果object匹配，那么返回 true，否则返回 false。
 */
export function LangIsMatch(value, obj) {
	return isMatch(value, obj);
}
/**
 * 断言操作函数
 * 它接受一个对比函数定制比较的值。 如果对比函数返回 undefined 将会比较处理方法代替
 * @param { * } value 要检查的对象。
 * @param { * } obj 属性值相匹配的对象。
 * @param { * } func  这个函数用来定制比较。
 * @returns 如果object匹配，那么返回 true，否则返回 false。
 */
export function LangIsMatchWith(value, obj, func) {
	return isMatchWith(value, obj, func);
}
/**
 * 断言操作函数
 * 检查 value 是否是 NaN。
 * @param { * } value 要检查的值
 * @returns 如果 value 是一个 NaN，那么返回 true，否则返回 false。
 */
export function LangIsNaN(value) {
	return isNaN(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是一个原生函数。
 * @param { * } value 要检查的值
 * @returns 如果 value 是一个 原生函数，那么返回 true，否则返回 false。
 * core-js 不支持该方法
 */
export function LangIsNative(value) {
	return isNative(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是 null 或者 undefined。
 * @param { * } value 要检查的值
 * @returns 如果 value 为null 或 undefined，那么返回 true，否则返回 false。
 */
export function LangIsNil(value) {
	return isNil(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是 null
 * @param { * } value 要检查的值
 * @returns 如果 value 为null，那么返回 true，否则返回 false。
 */
export function LangIsNull(value) {
	return isNull(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是原始Number数值型 或者 对象。
 * @param { * } value 要检查的值
 * @returns 如果 value 为一个数值，那么返回 true，否则返回 false。
 */
export function LangIsNumber(value) {
	return isNumber(value);
}
/**
 * 断言操作函数
 * 检查 value 是否是对象。
 * @param { * } value 要检查的值
 * @returns  如果 value 为一个对象，那么返回 true，否则返回 false。
 */
export function LangIsObject(value) {
	return isObject(value);
}
/**
 * 断言操作函数
 * 检查 value 是否为RegExp对象。
 * @param { * } value 要检查的值
 * @returns  如果 value 为一个正则表达式，那么返回 true，否则返回 false。
 */
export function LangIsRegExp(value) {
	return isRegExp(value);
}
/**
 * 断言操作函数
 * 转换 value 为一个数组。
 * @param { * } value 要检查的值
 * @returns 返回转换后的数组。
 */
export function LangToArray(value) {
	return toArray(value);
}
/**
 * 断言操作函数
 * 转换 value 为一个整数。
 * @param { * } value 要转换的值
 * @returns 返回转换后的整数。
 */
export function LangToInteger(value) {
	return toInteger(value);
}
/**
 * 断言操作函数
 * 转换 value 为字符串。 null 和 undefined 将返回空字符串。-0 将被转换为字符串"-0"。
 * @param { * } value 要转换的值
 * @returns 返回字符串。
 */
export function LangToString(value) {
	return toString(value);
}
export default List;
