/**
 * 徐立
 * 2019年12月11日
 */
import React, { Component } from 'react';
import { Button, Row, Col, Select } from 'antd';
import funcList from './functionList';
import AceEditor from 'react-ace';
import styles from './style.less';
import Throttle from 'lodash-decorators/throttle';
import { getModal } from '@/webPublic/one_stop_public/utils/utils';
const { Option } = Select;
const Modal = getModal();
export default class index extends Component {
	state = {
		visible: false, // 模态框状态
		selectOne: [], // 系列函数初始数组
		selectTwo: [], // 子函数初始数组
		checkedList: [], // 用户选中的函数数据
		checkedFuc: '', // 用户选择的函数
		aceValue: '', // 编辑器输入内容
		callKey: '', // 选择函数调用名
		resultValue: '', // 计算结果
	};
	/**
	 * 展示模态框回调
	 */
	showModal = () => {
		this.setState({
			visible: true,
		});
	};
	/**
	 * 模态框确定函数回调
	 */
	handleOk = (e) => {
		const { checkedFuc, callKey } = this.state;
		this.setState({
			visible: false,
		});
		this.props.setPitchOff(`$.${callKey}()`);
	};
	/**
	 * 模态框取消函数回调
	 */
	handleCancel = (e) => {
		this.setState({
			visible: false,
		});
		this.props.setClosePitchOff();
	};
	/**
	 * 系列函数搜索框change
	 * @param {*} value
	 */
	selectOneChange = (value) => {
		// 筛选出用户选择
		let arr = funcList.filter((item) => item.name == value);
		let arrTwo = []; // 替换子函数搜索
		if (arr.length > 0) {
			arr[0].children.map((item) => {
				arrTwo.push({
					value: item.name,
					key: item.name,
					func: item.function,
					funcName: item.funcName,
					params: item.params,
					demo: item.demo,
					callKey: item.callKey,
				});
			});
			this.setState({
				selectTwo: arrTwo,
			});
		} else {
			const arrTwo = [];
			// 默认用户可查看全部数据
			funcList.map((item) => {
				item.children.map((item) => {
					arrTwo.push({
						funcName: item.funcName,
						value: item.name,
						key: item.name,
						func: item.function,
						params: item.params,
						demo: item.demo,
						callKey: item.callKey,
					});
				});
			});
			this.setState({
				selectTwo: arrTwo,
			});
		}
	};
	/**
	 * 子函数列表搜索框change
	 * @param {*} value
	 */
	selectTwoChange = (value) => {
		const { selectTwo } = this.state;
		let arr = selectTwo.filter((item) => item.key == value);
		this.setState(
			{
				checkedList: arr,
				checkedFuc: arr[0].func,
				aceValue: arr[0].func.toString(),
				callKey: arr[0].callKey,
			},
			() => {
				this.getListData(this.state.checkedList[0].demo);
			},
		);
	};
	/**
	 * 数据格式化等操作
	 */
	componentDidMount() {
		const arrOne = [],
			arrTwo = [];
		// 默认用户可查看全部数据
		funcList.map((item) => {
			arrOne.push({
				value: item.name,
				key: item.name,
			});
			item.children.map((item) => {
				arrTwo.push({
					funcName: item.funcName,
					value: item.name,
					key: item.name,
					func: item.function,
					params: item.params,
					demo: item.demo,
					callKey: item.callKey,
				});
			});
		});
		this.setState({
			selectOne: arrOne,
			selectTwo: arrTwo,
		});
	}
	/**
	 * 根据传入的数组长度返回对应的函数传入值
	 */
	@Throttle(1)
	getListData = (List) => {
		const { checkedFuc } = this.state;
		let ary = [];
		List.map((item) => {
			ary.push(item.value);
			return item;
		});
		let data = checkedFuc(...ary);
		this.setState({
			resultValue: data,
		});
	};
	componentWillReceiveProps(nextProps) {
		const { isPicth } = nextProps;
		const { visible } = this.state;
		if (visible !== isPicth) {
			this.setState({
				visible: isPicth,
			});
		}
	}
	// 编辑起状态函数
	onAceChange = (newValue) => {
		this.setState({
			aceValue: newValue,
		});
	};
	render() {
		const { selectOne, selectTwo, checkedList, checkedFuc, aceValue, resultValue } = this.state;
		const { isShowBtn, isPicth } = this.props;
		return (
			<>
				{isShowBtn ? (
					''
				) : (
					<Button type="primary" onClick={this.showModal}>
						选择公式
					</Button>
				)}
				<Modal
					title="选择已有公式"
					visible={this.state.visible}
					onOk={this.handleOk}
					onCancel={this.handleCancel}
					width={1200}>
					<Row>
						<div className={styles.title}>快捷查询函数</div>
						<Col style={{ padding: 12 }} span={12}>
							<span style={{ marginRight: 12 }}>函数类别</span>
							<Select
								allowClear
								showSearch
								style={{ width: '80%' }}
								placeholder="请选择函数类别"
								optionFilterProp="children"
								onChange={this.selectOneChange}
								filterOption={(input, option) =>
									option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
								}>
								{selectOne.map((item) => {
									return (
										<Option value={item.key} key={item.key}>
											{item.value}
										</Option>
									);
								})}
							</Select>
						</Col>
						<Col style={{ padding: 12 }} span={12}>
							<span style={{ marginRight: 12 }}>函数列表</span>
							<Select
								showSearch
								style={{ width: '80%' }}
								placeholder="请选择函数列表"
								optionFilterProp="children"
								onChange={this.selectTwoChange}
								filterOption={(input, option) =>
									option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
								}>
								{selectTwo.map((item) => {
									return (
										<Option value={item.key} key={item.key}>
											{item.value}
										</Option>
									);
								})}
							</Select>
						</Col>
					</Row>
					<Row>
						<div className={styles.title}>
							{checkedList.length > 0 ? checkedList[0].name : ''}
							函数详细内容
						</div>
						<Col span={24}>
							{checkedList.length > 0 ? (
								<div className={styles.yesList}>
									<Row gutter={16}>
										<Col span={5} className={styles.left_title}>
											函数名称:
										</Col>
										<Col span={16} className={styles.right_content}>
											{' '}
											{checkedList[0].value}
										</Col>
									</Row>
									<Row gutter={16}>
										<Col span={5} className={styles.left_title}>
											函数介绍:
										</Col>
										<Col span={16} className={styles.right_content}>
											{' '}
											{checkedList[0].funcName}
										</Col>
									</Row>
									{checkedList.length > 0
										? checkedList[0].params.map((item, index) => {
												return (
													<Row gutter={16}>
														<Col span={5} className={styles.left_title}>
															函数传入参数介绍(
															{index + 1}
															):
														</Col>
														<Col span={16} className={styles.right_content}>
															{' '}
															{item.text}
														</Col>
													</Row>
												);
										  })
										: ''}
									<Row gutter={16}>
										<Col span={5} className={styles.left_title}>
											函数内容:
										</Col>
										<Col span={16} className={styles.right_content}>
											<AceEditor
												height={450}
												width={462}
												placeholder="请输入json样式"
												mode={'json'}
												disabled
												theme={'textmate'}
												fontSize={12}
												readOnly
												value={aceValue}
												onChange={this.onAceChange}
												showPrintMargin={true}
												showGutter={true}
												highlightActiveLine={true}
												name="UNIQUE_ID_OF_DIV"
												// keyboardHandler="vim"
												setOptions={{
													enableBasicAutocompletion: true,
													enableLiveAutocompletion: true,
													enableSnippets: true,
													showLineNumbers: true,
													tabSize: 2,
												}}
												editorProps={{ $blockScrolling: true }}
											/>
											{/* <pre>{checkedList[0].func.toString()}</pre> */}
										</Col>
									</Row>
									<Row gutter={16}>
										<Col span={5} className={styles.left_title}>
											函数案例计算参数:
										</Col>
										<Col span={16} className={styles.right_content}>
											{checkedList[0].demo.map((item, index) => {
												return (
													<div>
														<span>
															案例传入参数(
															{index + 1}
															):
														</span>
														<span style={{ marginLeft: 12 }}>类型: {item.text}</span>
													</div>
												);
											})}
										</Col>
									</Row>
									<Row gutter={16}>
										<Col span={5} className={styles.left_title}>
											计算结果:
										</Col>
										<Col span={16} className={styles.right_content}>
											{resultValue
												? typeof resultValue === 'object' || typeof resultValue === 'boolean'
													? JSON.stringify(resultValue)
													: resultValue
												: typeof resultValue === 'boolean'
													? JSON.stringify(resultValue)
													: null}
										</Col>
									</Row>
								</div>
							) : (
								<div className={styles.noList}>请选择您需要执行的函数</div>
							)}
						</Col>
					</Row>
				</Modal>
			</>
		);
	}
}
