/**
 * web端文件预览功能
 */
import React, { Component } from 'react';
import { checkIsImage } from '@/webPublic/one_stop_public/libs/UploadCom';
import { getModal, getPopconfirm, isFromIframe } from '@/webPublic/one_stop_public/utils/utils';
import styles from './styles.less';
import PreviewWordExtend from "@/webPublic/one_stop_public/filePreview/PreviewWordExtend";
import { ImgViewer } from './ImgViewer';

const Modal = getModal();
const Popconfirm = getPopconfirm();

export default class index extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
    };
    this.imageDom = null;
  }

  showModal = () => {
    if (isFromIframe()) {
      return false;
    }
    this.setState({
      visible: true,
    });
  };

  handleOk = e => {
    this.setState({
      visible: false,
    });
  };

  handleCancel = e => {
    this.setState({
      visible: false,
    });
  };
  download = () => {
    let { path, pathName } = this.props;
    if (window?.parent?.open && typeof window.parent.open === 'function') {
      window.parent.open(path, '_blank');
    } else {
      window.open(path, '_blank');
    }
  };

  render() {
    /***
     * pathName 必须是个字符串 否则容易崩溃
     * */
    let { path, pathName = '', width, height, activeIndex, images } = this.props;
    const { visible } = this.state;
    let isShow = false;
    let type;
    let isImg = checkIsImage(pathName);
    if (isImg) {
      isShow = true;
    } else {
      let find = ['.pdf', '.mp3', '.mp4', '.csv'].find(x => {
        if(pathName && typeof pathName === 'string'){
          return pathName && pathName.indexOf(x) > -1;
        }else{
          return false;
        }
      });
      if (find) {
        isShow = true;
      }
    }
    if (isShow) {
      type = pathName.split('.');
      type = Array.isArray(type) && type.length && type[type.length - 1];
    }

    // return null;
    return (
      <>
        {isShow ? (
          <Popconfirm
            title="查看附件"
            onConfirm={this.download}
            okText="下载"
            onCancel={this.showModal}
            cancelText={isFromIframe() ? '取消' : '预览'}
          >
            {isImg ? (
              <div ref={node => {
                this.imageDom = node;
              }}
                   className={styles.imgDiv}
                   style={{
                     width: width ? width : '100px',
                     height: height ? height : 'auto',
                     backgroundImage: `url(${path})`,
                   }}
              >
              </div>
            ) : (
              <PreviewWordExtend src={path} fileName={pathName}/>
            )}
          </Popconfirm>
        ) : (
          <PreviewWordExtend src={path} fileName={pathName}/>
        )}
        {visible && (
          <Modal
            title={pathName}
            visible={true}
            width={1200}
            destroyOnClose
            centered={true}
            onOk={this.handleOk}
            onCancel={this.handleCancel}
          >
            {type === 'pdf' ? (
              <iframe
                style={{
                  width: '100%',
                  height: 600,
                }}
                src={path}
              />
            ) : (
              <div
                style={{
                  height: 650,
                  maxWidth: 1200,
                }}
              >
                {!checkIsImage(path) && <a onClick={this.download}>下载文件</a>}

                {!!checkIsImage(path) && (
                  <ImgViewer
                    onClose={this.handleCancel}
                    images={images}
                    path={path}
                  />
                )}
              </div>
            )}
          </Modal>
        )}
      </>
    );
  }
}
