/**
 * 徐立
 * 2019年12月20日
 * 基础组件
 */
import React, { Component } from 'react';
import AllImg from '../assets/Add.png';
import styles from './style.less';
import { Icon, Tooltip } from 'antd';
import { isEmpty } from '../copy';
export default class Basics extends Component {
	constructor(props) {
		super(props);
		this.state = {
			isUserClick: false, // 是否用户点击
		};
	}
	// 打开函数选择
	setShowList = () => {
		const { item } = this.props;
		this.props.setCheckedList(item.name);
		this.setState({
			isUserClick: true,
		});
	};
	render() {
		const { isUserClick } = this.state;
		const {
			setPitchOn,
			setFunction,
			setCloseAll, // 选中函数后关闭全部
			item,
		} = this.props;
		return (
			<div onClick={this.setShowList} className={styles.basics_div}>
				<div className={styles.img_div}>
					<img src={item.isPitch ? item.pitchImages : item.images} />
				</div>
				<div className={[`${styles.name}`, `${item.isPitch ? styles.pitchOn : ''}`].join(' ')}>
					{item.name}
				</div>
				<div
					className={[
						`${styles.pull_down}`,
						`${item.isShowList ? styles.pull_show : isUserClick ? styles.pull_dis : ''}`,
					].join(' ')}>
					<div className={styles.top_fuc}>
						{!isEmpty(item.children) ? (
							item.children.map((arr, index) => {
								return (
									<div key={index}>
										<Tooltip
											placement="right"
											title={
												<div>
													<div>
														函数名称:
														<br />
														{arr.name}
													</div>
													<div>
														函数简介:
														<br />
														{arr.funcName}
													</div>
													<div>
														注:
														<br />
														点击可快捷添加入输入栏
													</div>
												</div>
											}>
											<div
												onClick={() => {
													setCloseAll();
													setFunction(`$.${arr.callKey}()`);
												}}
												className={styles.top_list}>
												<Icon style={{ fontSize: 12, marginRight: 8 }} type="edit" />
												{arr.name}
											</div>
										</Tooltip>
									</div>
								);
							})
						) : (
							<div className={styles.top_list}>暂无相关函数</div>
						)}
					</div>
					<div className={styles.bottom_fuc} onClick={setPitchOn}>
						<img src={AllImg} alt="" />
						所有函数
					</div>
				</div>
			</div>
		);
	}
}
