/**
 * 徐立
 * 2019年12月19日
 * 公式表单
 */
import React, { Component } from 'react';
import styles from './style.less';
import { Icon  } from 'antd';
import AllImg from '../assets/AllFuc.png';
import All2Img from '../assets/AllFuc2.png';
import ExcelBtn from '../excelInitFuc';
import RollTab from './rollTab';
export default class FormulaForm extends Component {
	constructor(props) {
		super(props);
		this.state = {
			isPitchOn: false, // 是否点击所有函数
			pitchFunction: '', // 选中函数
			aceValue: '', // 编辑器输入内容
			pages: 1, // 初始页面
			pagesTotal: 0, // 总条数
			isPagesMax: false, // 是否为最大页
			isPagesMin: true, // 是否为最小页
		};
	}
	// 设置数据总条数
	setPagesTotal = (num) => {
		this.setState({
			pagesTotal: num,
		});
	};
	// ta表单快捷选择函数
	setFunction = (fuc) => {
		this.setState({
			pitchFunction: fuc,
		});
		this.props.append(fuc);
	};
	// 点击修改选中状态
	setPitchOn = () => {
		this.setState({
			isPitchOn: true,
		});
	};
	// 取消显示并获取用户选择函数
	setPitchOff = (fuc) => {
		this.setState({
			isPitchOn: false,
			pitchFunction: fuc,
		});
		this.props.append(fuc);
	};
	// 单独用户点击取消控制函数
	setClosePitchOff = () => {
		this.setState({
			isPitchOn: false,
		});
	};
	// 查找表选择事件
	onNameChange = (value) => {
		console.log(`selected ${value}`);
	};
	// 查找字段编码选择事件
	onCodeChange = (value) => {
		console.log(`selected ${value}`);
	};
	// 编辑起状态函数
	onAceChange = (newValue, all) => {
		this.setState({
			aceValue: newValue,
		});
	};
	// 返回上一页
	goBackPages = () => {
		this.refs.rolltab.setCloseAll();
		const num = this.state.pages <= 1 ? 1 : this.state.pages - 1;
		this.setState({
			pages: num,
			isPagesMin: num == 1 ? true : false,
			isPagesMax: false,
		});
	};
	/**
	 * 前进下一页
	 */
	goForwrod = () => {
		this.refs.rolltab.setCloseAll();
		const { pagesTotal } = this.state;
		let pageMax = Math.ceil(pagesTotal / 14);
		let num = this.state.pages == pageMax ? pageMax : this.state.pages + 1;
		this.setState({
			pages: num,
			isPagesMax: num == pageMax ? true : false,
			isPagesMin: false,
		});
	};

	render() {
		const {
			isFormula, // 是否展示公式表单
			cutCloseFormula, // 关闭公式表单函数
			isOne, // 是否为用户点击,排除渲染时重复展示
		} = this.props;
		const { isPitchOn, aceValue, isPagesMax, isPagesMin, pages } = this.state;
		return (
			<div
				className={[
					`${styles.formula_div}`,
					`${isFormula ? styles.show : isOne ? styles.dis : ''}`,
				].join(' ')}>
				<div className={styles.left_div}>
					<div className={styles.tab_top}>
						<div
							onClick={isPagesMin ? () => {} : this.goBackPages}
							style={{ cursor: isPagesMin ? 'not-allowed' : 'pointer' }}
							className={styles.left_btn}>
							<Icon style={{ color: isPagesMin ? '#cccccc' : '#999999' }} type="left" />
						</div>
						<div className={styles.center_conter}>
							<div onClick={this.setPitchOn} className={styles.all_card}>
								<img src={isPitchOn ? All2Img : AllImg} />
								<div className={[`${styles.name}`, `${isPitchOn ? styles.pitchOn : ''}`].join(' ')}>
									所有函数
								</div>
							</div>
							<RollTab
								ref="rolltab"
								// 所有函数调用相关
								setPitchOn={this.setPitchOn}
								// 设置函数相关
								setFunction={this.setFunction}
								// 设置数据总条数
								setPagesTotal={this.setPagesTotal}
								// 页码相关
								pages={pages}
							/>
						</div>
						<div
							onClick={isPagesMax ? () => {} : this.goForwrod}
							style={{ cursor: isPagesMax ? 'not-allowed' : 'pointer' }}
							className={styles.left_btn}>
							<Icon style={{ color: isPagesMax ? '#cccccc' : '#999999' }} type="right" />
						</div>
					</div>
					<div
						onClick={() => {
							this.refs.rolltab.setCloseAll();
						}}>
						{this.props.editor}
					</div>
				</div>

				<div
					className={styles.absolute_div}
					onClick={() => {
						cutCloseFormula();
						this.refs.rolltab.setCloseAll();
					}}>
					{isFormula ? <Icon type="right" /> : <Icon type="left" />}
				</div>
				<ExcelBtn
					isShowBtn={true}
					setClosePitchOff={this.setClosePitchOff}
					setPitchOff={this.setPitchOff}
					isPicth={isPitchOn}
				/>
			</div>
		);
	}
}
