import React from 'react';
import { Tree, Upload, Icon, Button, message } from 'antd';
import Location from '../location';
const TreeNode = Tree.TreeNode;

export default class LocationCom extends React.Component {
	constructor(props) {
		super(props);
		const value = props.value || {};
		this.state = {
			lng: value.lng,
			lat: value.lat,
			address: value.address,
			params: {},
		};
	}

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			onChange(Object.assign({}, this.state, changedValue));
		}
	};
	componentWillReceiveProps(nextProps) {
		// Should be a controlled component.
		if ('value' in nextProps) {
			const value = nextProps.value;

			this.setState(value);
		}
	}
	changePos = (obj) => {
		if (!('value' in this.props)) {
			this.setState({ ...obj });
		}
		this.triggerChange({ ...obj });
	};
	render() {
		const { btnName, btnSucName, width, showMap, get, json, showLocation } = this.props;
		const { lng, lat, address, params } = this.state;

		return (
			<Location
				json={json}
				params={params}
				lng={lng}
				lat={lat}
				address={address}
				onChange={this.changePos}
				get={get}
				btnName={lng != null ? btnSucName : btnName}
				showMap={showMap}
				showLocation={showLocation}
				width={width}
			/>
		);
	}
}
