/**
 * 2019年10月23日
 * 移动端日期选择封装
 */
/*
*  2022年8月29日 29143 h5/优秀学生干部管理/优秀学生干部申请，时间只要年/月；更改时间排版（20192601007，bdk@2022*$）
*
 */
import React, { Component } from 'react';
import { DatePicker, List, Toast } from 'antd-mobile';
import moment from 'moment';

export default class MobileDate extends Component {
  constructor(props) {
    super(props);
    const value = props.value || [];

    this.state = {
      dates: value,
    };
  }

  triggerChange = changedValue => {
    // Should provide an event to pass value to Form.
    const onChange = this.props.onChange;
    if (onChange) {
      onChange([...changedValue]);
    }
  };

  componentWillReceiveProps(nextProps) {
    // Should be a controlled component.
    if ('value' in nextProps) {
      const value = nextProps.value;
      this.setState({ dates: value });
    }
  }

  handelStartChange = date => {
    const { dates } = this.state;

    if (dates.length === 0) {
      dates.push(moment(date.valueOf()));
    } else {
      if (dates.length === 2) {
        if (moment(date.valueOf()).isAfter(dates[1], 'second')) {
          Toast.fail('结束时间必须在开始时间之后', 1);
          return false;
        }
      }
      dates[0] = moment(date.valueOf());
    }

    if (!('value' in this.props)) {
      this.setState({ dates });
    }
    this.triggerChange(dates);
  };

  handelEndChange = date => {
    const { dates } = this.state;
    if (dates.length === 0) {
      dates.push(null);
      dates.push(moment(date.valueOf()));
    } else if (dates.length === 1) {
      if (dates[0].isAfter(moment(date.valueOf()), 'second')) {
        Toast.fail('结束时间必须在开始时间之后', 1);
        return false;
      }
      dates.push(moment(date.valueOf()));
    } else {
      if (dates[0].isAfter(moment(date.valueOf()), 'second')) {
        Toast.fail('结束时间必须在开始时间之后', 1);
        return false;
      }

      dates[1] = moment(date.valueOf());
    }
    if (!('value' in this.props)) {
      this.setState({ dates });
    }
    this.triggerChange(dates);
  };

  MustSpan = () => {
    const { required } = this.props;
    if (required) {
      return <span style={{ color: 'red' }}>* </span>;
    } else {
      return null;
    }
  };

  formatDateShow = (v) => {

  };

  render() {
    let { dates } = this.state;
    const { format, showTime, otherProps,
     } = this.props;
    const mobileProps = otherProps?.mobileProps || {};
    const formatDiy = mobileProps.format || format || 'YYYY-MM-DD HH:mm:ss';
    let mode = 'datetime';
    if (!showTime) {
      mode = 'date';
    }
    const startTime = dates.length > 0 ? dates[0] && dates[0].valueOf() : null;
    const endTime = dates.length > 1 ? dates[1] && dates[1].valueOf() : null;
    const MustSpan = this.MustSpan();


    return (
      <div>
        <DatePicker
          // value={this.state.date}
          extra={
            <span style={{ fontSize: 14 }}>
              {!!startTime
                ? moment(startTime).format(formatDiy)
                : '请选择时间'}
            </span>
          }
          locale={{
            okText: '确定',
            dismissText: '取消',
          }}
          value={!!startTime ? new Date(startTime) : null}
          mode={mode}
          onChange={date => this.handelStartChange(date)}
          {...mobileProps}
          format={(value) => {
            return moment(value).format(formatDiy);
          }}
        >
          <List.Item arrow="horizontal">{MustSpan}开始</List.Item>
        </DatePicker>
        <DatePicker
          // value={this.state.date}
          extra={
            <span style={{ fontSize: 14 }}>
              {!!endTime
                ? moment(endTime).format(formatDiy)
                : '请选择时间'}
            </span>
          }
          value={!!endTime ? new Date(endTime) : null}
          locale={{
            okText: '确定',
            dismissText: '取消',
          }}
          mode={mode}
          onChange={date => this.handelEndChange(date)}
          {...mobileProps}
          format={(value) => {
            return moment(value).format(formatDiy);
          }}
        >
          <List.Item arrow="horizontal">{MustSpan}结束</List.Item>
        </DatePicker>
      </div>
    );
  }
}
