import React from 'react';
import Neo4jD3 from '@/webPublic/one_stop_public/utils/Neo4jD3';
import UUID from 'react-native-uuid';
export default class Neo4jD3Com extends React.Component {
	state = {
		uid: UUID.v4(),
	};

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			onChange(changedValue);
		}
	};
	data;
	q;
	componentWillReceiveProps(nextProps) {
		if ('option' in nextProps && nextProps.option && nextProps.option.neo4jData) {
			if (this.neo4jd3 == null) {
				this.q = nextProps.option.q;
				this.neo4jd3 = this.init(nextProps.option.neo4jData);
			} else {
				if (this.q != nextProps.option.q) {
					const newuid = UUID.v4();
					this.q = nextProps.option.q;
					this.setState({ uid: UUID.v4() }, () => {
						this.init(nextProps.option.neo4jData, newuid);
					});
				}
			}
		}
	}
	/*   componentWillReceiveProps(nextProps) {
        // Should be a controlled component.
        if ('option' in nextProps&&nextProps.option&&nextProps.option.neo4jData) {

            if(this.neo4jd3==null){
               this.q=nextProps.option.q
               this.neo4jd3=this.init(nextProps.option.neo4jData,this.uid)
            }else{
                if(this.q!=nextProps.option.q){
                    const newuid=UUID.v4()
                    this.neo4jd3.clear()
                    var test=document.createElement('div');
                    test.setAttribute("id","id_"+newuid);
                    test.setAttribute("key",newuid);

                    console.log(document.getElementById("zhishi"));
                    document.getElementById("zhishi").append(test)

                    this.neo4jd3=this.init(nextProps.option.neo4jData,newuid)
                    this.q=nextProps.option.q
                }

            }

        }
    }
     */
	changePos = (obj) => {
		if (!('value' in this.props)) {
			this.setState({ ...obj });
		}
		this.triggerChange({ ...obj });
	};
	neo4jd3;
	init = (neo4jData) => {
		return new Neo4jD3('#id_' + this.state.uid, {
			highlight: [
				{
					class: 'Project',
					property: 'name',
					value: 'neo4jd3',
				},
				{
					class: 'User',
					property: 'userId',
					value: 'eisman',
				},
			],
			icons: {
				//                        'Address': 'home',
				Api: 'gear',
				//                        'BirthDate': 'birthday-cake',
				Cookie: 'paw',
				//                        'CreditCard': 'credit-card',
				//                        'Device': 'laptop',
				Email: 'at',
				Git: 'git',
				Github: 'github',
				Google: 'google',
				//                        'icons': 'font-awesome',
				Ip: 'map-marker',
				Issues: 'exclamation-circle',
				Language: 'language',
				Options: 'sliders',
				Password: 'lock',
				Phone: 'phone',
				Project: 'folder-open',
				SecurityChallengeAnswer: 'commenting',
				User: 'user',
				zoomFit: 'arrows-alt',
				zoomIn: 'search-plus',
				zoomOut: 'search-minus',
			},
			images: {
				Address: 'img/twemoji/1f3e0.svg',
				//                        'Api': 'img/twemoji/1f527.svg',
				BirthDate: 'img/twemoji/1f382.svg',
				Cookie: 'img/twemoji/1f36a.svg',
				CreditCard: 'img/twemoji/1f4b3.svg',
				Device: 'img/twemoji/1f4bb.svg',
				Email: 'img/twemoji/2709.svg',
				Git: 'img/twemoji/1f5c3.svg',
				Github: 'img/twemoji/1f5c4.svg',
				icons: 'img/twemoji/1f38f.svg',
				Ip: 'img/twemoji/1f4cd.svg',
				Issues: 'img/twemoji/1f4a9.svg',
				Language: 'img/twemoji/1f1f1-1f1f7.svg',
				Options: 'img/twemoji/2699.svg',
				Password: 'img/twemoji/1f511.svg',
				//                        'Phone': 'img/twemoji/1f4de.svg',
				Project: 'img/twemoji/2198.svg',
				'Project|name|neo4jd3': 'img/twemoji/2196.svg',
				//                        'SecurityChallengeAnswer': 'img/twemoji/1f4ac.svg',
				User: 'img/twemoji/1f600.svg',
				//                        'zoomFit': 'img/twemoji/2194.svg',
				//                        'zoomIn': 'img/twemoji/1f50d.svg',
				//                        'zoomOut': 'img/twemoji/1f50e.svg'
			},
			minCollision: 60,
			neo4jData: neo4jData,
			nodeRadius: 25,
			onNodeDoubleClick: function(node) {
				/*     switch(node.id) {
                        case '25':
                            // Google
                            window.open(node.properties.url, '_blank');
                            break;
                        default:
                            var maxNodes = 5,
                                data = neo4jd3.randomD3Data(node, maxNodes);
                            neo4jd3.updateWithD3Data(data);
                            break;
                    } */
			},
			onRelationshipDoubleClick: function(relationship) {
				console.log('double click on relationship: ' + JSON.stringify(relationship));
			},
			zoomFit: true,
		});
	};

	render() {
		return (
			<div id="zhishi">
				<div id={'id_' + this.state.uid} style={{ height: this.props.json.height || 500 }}>
					{' '}
				</div>
			</div>
		);
	}
}
