/*
 * @Author: LSC
 * @Date: 2024-08-09 10:02:04
 * @LastEditTime: 2024-08-13 16:52:31
 */
import React, { useEffect, useState } from 'react';
import { Button, Table, Input } from 'antd';
import { List, InputItem, WhiteSpace } from 'antd-mobile';
import { getServicesNomal } from '../Services/services';
import { getSqlDataApi } from '../Services/apiConfig';
import styles from './style.less';

// eslint-disable-next-line import/prefer-default-export
export const PageTable = (props) => {
	const {
		isMultiple,
		isShowQuanXuan,
		selectAll,
		cancelAll,
		valueName,
		columns3,
		allWidth,
		get,
		sqlKey,
		allValues,
		visiable,
		modalWidth,
	} = props;
	const [pagination, setPagination] = useState({
		total: 0,
		pageNo: 1,
		pageSize: 15,
	});
	const [queryParams, setQueryParams] = useState({});
	const [dataSource, setDataSource] = useState([]);
	useEffect(
		() => {
			init();
		},
		[visiable, pagination.pageNo, pagination.pageSize],
	);
	const init = () => {
		const params = {
			sqlKey,
			allValues,
			isCache: false,
			jsParams: JSON.stringify([queryParams]),
			pageNo: pagination?.pageNo,
			pageSize: pagination?.pageSize,
		};
		getServicesNomal(getSqlDataApi, params).then((list) => {
			setPagination({
				...pagination,
				total: parseInt(list?.total) || 0,
			});
			setDataSource(list?.rows);
		});
	};

	const pageProps = {
		pageSize: pagination.pageSize,
		current: pagination.pageNo,
		total: pagination.total,
		showSizeChanger: true,
		showQuickJumper: true,
	};
	let widthThis = 
		get === 'mobile' ? '100%' : !!Number(modalWidth) ? Number(modalWidth) : modalWidth || '90%';
	return (
		<>
			{
				get !== 'mobile' && columns3?.filter((y) => y?.isQuery)?.length > 0 &&
			<div
				className={styles.searchGrid}
				style={{
					width: widthThis,
				}}>
				{columns3.filter((y) => y?.isQuery)?.map((g) => {
					return (
						<div key={g.dataIndex} className={styles.itemX}>
							<span className={styles.searchSpan}>{g.title}</span> :{' '}
							<Input
								onChange={(e) => {
									setQueryParams({ ...queryParams, [g.dataIndex]: e.target.value });
								}}
								value={queryParams[g.dataIndex]}
								style={{
									display: 'inline-block',
									width: '150px',
								}}
							/>
						</div>
					);
				})}
				<Button onClick={init} type="primary">
					查询
				</Button>
			</div>
			}
			{
				get === 'mobile' && columns3?.filter((y) => y?.isQuery)?.length > 0 &&
				<List>
					{columns3.filter((y) => y?.isQuery)?.map((g) => {
						return (
							<InputItem
							key={g.dataIndex}
							onChange={(e) => {
								setQueryParams({ ...queryParams, [g.dataIndex]: e });
							}}
					clear
					placeholder="请输入"
				>{g.title}</InputItem>
						);
					})}
				<List.Item>
					<div
						style={{ width: '100%', color: '#108ee9', textAlign: 'center' }}
						onClick={init}
					>
						查询
					</div>
				</List.Item>
			</List>
			}
			<div>
				{isMultiple &&
					isShowQuanXuan !== false && (
						<>
							{' '}
							<Button
								id={'quanXuanButton'}
								type={'primary'}
								style={{ margin: '0 10px 10px 0' }}
								onClick={selectAll}>
								全选
							</Button>
							<Button
								id={'quXiaoQuanXuanButton'}
								type={'primary'}
								style={{ marginBottom: '10px' }}
								onClick={cancelAll}>
								取消全选
							</Button>
						</>
					)}
			</div>

			<Table
				rowKey={valueName}
				size="small"
				dataSource={dataSource}
				columns={columns3}
				scroll={{ x: get === 'mobile' ? 'max-content' : allWidth }}
				pagination={pageProps}
				onChange={(newPagination, filters, sorter) => {
					const { current, pageSize } = newPagination;
					if (pagination.pageSize !== pageSize) {
						setPagination({
							...pagination,
							pageNo: 1,
							pageSize,
						});
						return;
					}
					setPagination({
						...pagination,
						pageNo: current,
						pageSize,
					});
				}}
			/>
		</>
	);
};
