/**
 * 钟是志
 * 2022年5月31日
 * 禅道需求定制化
 * 27141 [黔南]门户---单位个人中心，，双选会申请可视化展示，，发布到门户后，在邀请函页面也可视化展示
 * 27345 门户--单位个人中心，，，双选会申请，选择展位的图片优化
 * */
import React, { Fragment } from 'react';
import { Tag, Radio, Tooltip } from 'antd';
import styles from './styles.less';


/**
 return {
  showType: 'card-select',
  remark: '黔南需求 禅道 27141',
  cardSelectModalProps: {
   title: '选择展位',
   width: '90vw',
   bodyStyle: {
     height: '75vh',
     overflowY: 'auto',
   },
  },
  headerInfoFields: [
   {
     label: '批次名称',
     key: 'batch_name',
   },
   {
      label: '招聘地点',
      key: 'address_name',
   },
  ],
  statusKey: 'state_id',
  rowKey: 'booth_no_id',
  noDataSentence: '暂无可选展位',
  canSelectKeys: ['-1'],
  selectedStyle: {
    backgroundColor: '#4075FE',
    color: '#fff',
  },
  typeList: {
    '-1': {
      style: {
        // color: '',
        border: '1px solid green',
        cursor: 'pointer',
      },
        styleTips: {
          border: '1px solid green',
       },
      text: '未选',
      //canSelect: true,

    },
     '0': {
       styleTips: {
          border: '1px solid gray',
       },
      style: {
        // color: '',
        border: '1px solid gray',
      },

      text: '已选',

    },
    '1': {
         styleTips: {
          border: '1px solid orange',
       },
      style: {
        // color: '',
        border: '1px solid orange',
      },
      text: '申请中'
    }
  },
}
 * */

export default function TableSelectZhanWei(props) {
  const {
    isMultiple, isShowQuanXuan,
    selectAll, cancelAll,
    valueName, dataSource,
    columns3, allWidth,
    get, otherProps,
    callback, selects,
  } = props;

  const {
    headerInfoFields,
    rowKey,
    prefixName = '',
    statusKey,
    noDataSentence = '暂无可选数据',
    canSelectKeys = [],
    typeList = [],
    selectedStyle = {},
  } = otherProps;
  if (!dataSource || !dataSource.list || !dataSource.list.length) {
    return <div className={styles.noData}>{noDataSentence}</div>;
  }
  const data = dataSource.list;

  const selectItem = (selectData) => {
    callback(selectData);
  };


  return <div className={styles.zhanWei}>

    {headerInfoFields && headerInfoFields.length &&
    <div className={styles.header}>
      {headerInfoFields.map((g) => {
        return <span key={g.key} className={styles.headOne}>
          <span className={styles.headTitle}>{g.label}</span> : {data[0][g.key]}
        </span>;
      })}
    </div>
    }


    <div className={styles.list}>
      {
        data.map((item, index) => {
          const status = item[statusKey];
          const defaultChecked = canSelectKeys.includes(status + '');
          const typeConfig = typeList[status + ''] || {};
          const nowSelect = !!selects[item[rowKey]];
          return <div className={styles.item}
                      key={item[rowKey]}
                      style={
                        nowSelect ? {
                          ...selectedStyle,
                        } : {
                          ...typeConfig.style,
                        }
                      }
                      onClick={() => {
                        if (defaultChecked) {
                          selectItem(item);
                        }
                      }}
          >

            <div className={styles.name}>
              <Tooltip title={nowSelect ? '当前选择' : typeConfig.text}>
                {prefixName + item.booth_no_name}
              </Tooltip>
            </div>
          </div>;
        })
      }
    </div>

    <div className={styles.footer}>
      {
        Object.keys(typeList).map((g) => {
          const typeOne = typeList[g];
          return <span key={g} className={styles.tipsSpan}>
            <span className={styles.tipsBlock} style={typeOne.styleTips}>

            </span>
            <span className={styles.tipsText}>{typeOne.text}</span>
          </span>;
        })
      }
    </div>

  </div>;
}

{/* <div className={styles.itemHead}>
              <div>
                <Radio disabled={!defaultChecked}
                       checked={!defaultChecked || nowSelect}
                       onChange={(e) => {
                         selectItem(item);
                       }}
                >
                </Radio>
              </div>
              <div className={styles.statusTag}>
                <Tag color={typeConfig.color}>
                  {typeConfig.text}
                </Tag>
              </div>
            </div>*/
}
