/*
 * @Author: your name
 * @Date: 2019-10-23 18:27:52
 * @LastEditTime : 2020-02-11 15:36:01
 * @LastEditors  : Please set LastEditors
 * @Description: In User Settings Edit
 * @FilePath: \one_stop_front\src\components\libs\TableList.js
 */
import React from 'react';
import FormList from './formList';
import TreeList from './formList/TreeList';
import { Spin } from 'antd';

export default class TableList extends React.Component {
	constructor(props) {
		super(props);
		const value = props.value || {};
		this.otherProps = {};
		if (props.json.otherProps && props.json.otherProps.length) {
			try {
				this.otherProps = new Function(props.json.otherProps)();
			} catch (e) {
				console.log('Table 列表组件 otherProps 获取失败');
			}
		}
		// console.log(this.otherProps);
		this.state = {
			isAll: value.isAll,
			querys: value.querys,
			sql: value.sql,
			btns: value.btns,
			columns: value.columns,
		};
	}

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			onChange(Object.assign({}, this.state, changedValue));
		}
	};

	static getDerivedStateFromProps(nextProps, prevState) {
		// ...
		if ('value' in nextProps) {
			return { ...nextProps.value }; // 更新state
		}
		return null; //不需要更新任何state
	}

	componentDidUpdate(prevProps, prevState) {
		if (prevState?.columns !== this.state.columns) {
		  console.log(prevState.columns, this.state.columns);
			this.setState(
				{
					showNo: true,
				},
				() => {
					setTimeout(() => { // 如果两次的表头不同 重新渲染组件
						this.setState({
							showNo: false,
						});
					}, 10);
				},
			);
		}
	}

	render() {
		const { isTree, json, uuid, obj } = this.props;
		const { showNo } = this.state;
		// console.log(obj);
		if (showNo) {
			return null;
		}
		return isTree ? (
			<TreeList
				otherProps={this.otherProps}
				json={json}
				onSelectRow={this.props.value.onSelectRow}
				istableCom={true}
				showHeader={this.props.showHeader}
				get={this.props.get}
				isHiddenPage={this.props.isHiddenPage != null ? this.props.isHiddenPage : false}
				loading={this.props.loading}
				pageSize={this.props.pageSize || 10}
				value={this.state}
				notShowBack={true}
				rights={this.props.rights || []}
				objCode={this.props.objCode}
				isFormCom={true}
				uuid={uuid}
        obj={obj}
        sql={this.props.sql}
			/>
		) : (
			<FormList
				otherProps={this.otherProps}
				json={json}
				onSelectRow={this.props.value.onSelectRow}
				getCheckboxProps={this.props.value.getCheckboxProps}
				istableCom={true}
				showHeader={this.props.showHeader}
				get={this.props.get}
				isHiddenPage={this.props.isHiddenPage != null ? this.props.isHiddenPage : false}
				pageSize={this.props.pageSize || 10}
				value={{ ...this.state }}
				notShowBack={true}
				rights={this.props.rights || []}
				objCode={this.props.objCode}
        obj={obj}
				isFormCom={true}
				uuid={uuid}
				sql={this.props.sql}
			/>
		);
	}
}
