import React, { useEffect, useState } from 'react';
import { Button } from 'antd';

export default function SplitButton(props) {
  const [stateProps, setProps] = useState({ ...props });

  // useEffect(() => {
  //   setProps({
  //     ...stateProps,
  //     onClick: props.onClick && typeof props.onClick === 'function' && props.onClick.bind(this, props.selectedRows, props.obj),
  //   });
  // }, [props.selectedRows, props.obj]);

  useEffect(() => {
    if(props.changeButtonProps && typeof props.changeButtonProps === 'function'){
      props.changeButtonProps({
        selectedRows: props.selectedRows,
        setProps,
        stateProps,
      });
    }

  }, [props.selectedRows]);

  const handleClick = (e) => {
    if(props.onClick && typeof props.onClick === 'function'){
      props.onClick(e, props.selectedRows, props.obj);
    }
  };


  return <Button {...stateProps} onClick={handleClick}/>;
}
