import React, { Fragment } from 'react';
import {
	Button,
	Card,
	DatePicker,
	Divider,
	Form,
	Row,
	Col,
	Input,
	InputNumber,
	message,
	Select,
	Tree,
	Tooltip,
	Spin,
} from 'antd';
import { connect } from 'dva';
import PageHeaderWrapper from './PageHeaderWrapper';
import styles from './TableList.less';
import StandardTable from './StandardTable';
import moment from 'moment';
import router from 'umi/router';
import ExportInfo from '../../App/ExportInfo';
import ExportCurrentInfo from '../../App/ExportCurrentInfo';

import StatisticsInfo from '../../App/StatisticsInfo';
import ImportUtil from '../../App/ImportUtil';
import SearchInfo from '../../App/SearchInfo';
import { Base16Encode } from '../../Base16/index';
import { isEmpty } from 'lodash';
import FilePreview from '@/webPublic/one_stop_public/filePreview';
import { queryApiActionPath, queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';
import UploadCom from '@/webPublic/one_stop_public/libs/UploadCom';
import { getModal, getPopconfirm } from '@/webPublic/one_stop_public/utils/utils';
import { getServicesNomal } from '../../Services/services';
import {
	getFormDataListApi,
	getBatchOptionsApi,
	getFormDataApi,
	deleteFormDataApi,
	getDetailByCodeApi,
	findByCodeApi,
	getDetailApi,
	getHeaderListApi,
	getGroupListApi,
	addFormDataApi,
} from '../../Services/apiConfig';

const Popconfirm = getPopconfirm();
const Modal = getModal();
const FormItem = Form.Item;
let AllWidth = 0; // 表格总长度
const { RangePicker } = DatePicker;

const TreeNode = Tree.TreeNode;
const text = [
	'BINARY',
	'BIT',
	'BLOB',
	'CHAR',
	'GEOMETRY',
	'GEOMETRYCOLLECTION',
	'JSON',
	'LINESTRING',
	'LONGBLOB',
	'LONGTEXT',
	'MEDIUMBLOB',
	'MEDIUMINT',
	'MEDIUMTEXT',
	'MULTILINESTRING',
	'MULTIPOINT',
	'MULTIPOLYGON',
	'POINT',
	'POLYGON',
	'REAL',
	'DECIMAL',
	'ENUM',
	'SET',
	'TEXT',
	'TINYBLOB',
	'TIBYTEXT',
	'VARBINARY',
	'VARCHAR',
];
const number = ['BIGINT', 'DOUBLE', 'FLOAT', 'INT', 'INTEGER', 'NUMERIC', 'SMALLINT', 'TINYINT'];
const data = ['DATE', 'DATETIME', 'TIME', 'TIMESTAMP', 'YEAR'];

const CreateForm = Form.create()((props) => {
	const {
		modalVisible,
		form,
		handleAdd,
		formLoading,
		formData,
		isAdd,
		handleModalVisible,
		formItem,
		getItem,
		isView,
	} = props;

	//通过回调
	const okHandle = () => {
		form.validateFields((err, fieldsValue) => {
			if (err) return;
			if (isView) {
				handleModalVisible();
				return;
			}
			formItem.map((item, index) => {
				if (item.type.indexOf('DATE') > -1) {
					for (let d in fieldsValue) {
						if (item.name === d && fieldsValue[d]) {
							fieldsValue[d] = fieldsValue[d].format('YYYY-MM-DD HH:mm:ss');
						}
					}
				}
			});
			let params = { ...fieldsValue };
			handleAdd(params, isAdd);
		});
	};

	//需要获取动态表单
	return (
		<Modal
			width="700px"
			maskClosable={false}
			destroyOnClose
			title={isView ? '查看详情' : isAdd ? '新增' : '编辑'}
			visible={modalVisible}
			footer={
				isView
					? null
					: [
							<Button key="back" onClick={() => handleModalVisible()}>
								取消
							</Button>,
							<Button key="submit" type="primary" onClick={okHandle}>
								确定
							</Button>,
					  ]
			}
			onOk={okHandle}
			onCancel={() => handleModalVisible()}>
			{formItem.map((item, index) =>
				getItem(false, form, item, isAdd, formData, { span: 5 }, { span: 15 }),
			)}
		</Modal>
	);
});

@connect(({ formList, loading }) => ({
	formList,
	loading: loading.models.formList,
}))
@Form.create()
class TreeList extends React.Component {
	constructor(props) {
		super(props);
		const {
			json: { treeTitleName, treeKeyName },
		} = this.props;
		const root = {};
		root[treeTitleName] = '根目录';
		root[treeKeyName] = '0-0';
		this.state = {
			data: {
				list: [],
				pagination: {},
			},
			treeData: [root],
			isReady: false,
			parentName: '根节点',
			parentId: null,
			selects: [],
			modalVisible: false,
			formData: null,
			formValues: {},
			formItem: [],
			objId: this.props.objId || (this.props.location ? this.props.location.state.id : null),
			isAdd: false,
			querys: [],
			selectedRows: [],
			primaryKey: null,
			options: {},
			isTable: true,
			tableWidth: 500,
			rights: this.props.rights || [],
			columnRights: [],
			isReady: false,
			groups: {},
			showDiv: '',
			showMobileDiv: '',
			isView: false,
		};
	}

	columns = [];
	getOptions = () => {
		const refIds = [];
		for (var i = 0; i < this.state.formItem.length; i++) {
			if (
				this.state.formItem[i].referenceObjId != null &&
				this.state.options[this.state.formItem[i].id + ''] == null
			) {
				refIds.push(datas[t].id);
			}
		}

		if (refIds.length > 0) {
			getServicesNomal(getBatchOptionsApi, { ids: refIds }).then(options => {
				this.setState({ options: { ...this.state.options, ...options } });
			});
		}
	};
	getList = (values, callback, isFirst) => {
		const { json: { treeParentIdName, ctgFilterSql } } = this.props;

		if (!values) {
			values = this.state.formValues;
		}
		getServicesNomal(getFormDataListApi, {
			...values,
			ctgFilterSql: ctgFilterSql,
			parentIdName: treeParentIdName,
			dataObjId: this.state.objId,
		}).then(res => {
			callback()
		})
	};
	modify = (record) => {
		//  if (this.state.formItem.length < 10) {
		this.getOptions();
		getServicesNomal(getFormDataApi, {
			dataObjId: this.state.objId,
			key: this.state.primaryKey,
			value: record[this.state.primaryKey],
			isBase: false,
		}).then(record2 => {
			this.setState({
				formData: record2,
				modalVisible: true,
				isAdd: false,
				isView: false,
			});
		});
	};

	view = (record) => {
		// if (this.state.formItem.length < 10) {
		this.getOptions();
		this.setState({
			formData: record,
			modalVisible: true,
			isAdd: false,
			isView: true,
		});

	};

	isJSON = (str) => {
		if (typeof str == 'string') {
			try {
				var obj = JSON.parse(str);
				if (typeof obj == 'object' && obj) {
					return true;
				} else {
					return false;
				}
			} catch (e) {
				console.log('error：' + str + '!!!' + e);
				return false;
			}
		}
		console.log('这不是个字符串');
	};

	delete = (record) => {
		//找出主键
		let Keys = {};
		Keys[this.state.primaryKey] = record[this.state.primaryKey];
		getServicesNomal(deleteFormDataApi, {
			keys: JSON.stringify(Keys),
			objId: this.state.objId,
		}).then(() => {
			this.getPage({ parentId: this.state.parentId }, null, null, (list) => {
				const treeData = this.refesh(this.state.parentId, list, this.state.treeData);
				this.setState({
					modalVisible: false,
					treeData,
				});
			});
		});
	};

	viewProcess = (record) => {
		getServicesNomal(getDetailByCodeApi, { code: record.process_biz_key }).then(data => {
			router.push({ pathname: '/portal/serviceCentre/getdetail', state: { id: data.id } });
		});
	};

	/**
	 * 宽度自适应函数
	 */
	resize = (e) => {
		let scrollWidth = document.documentElement.clientWidth || document.body.clientWidth; //可使宽度
		let showMobileDiv = scrollWidth - 77;
		if (document.querySelector('#previewDiv')) {
			// 预览模式
			this.setState({
				showMobileDiv: document.querySelector('#previewDiv').clientWidth - 77,
			});
		} else {
			this.setState({
				showMobileDiv,
			});
		}
	};

	//渲染值
	componentDidMount() {
		window.addEventListener('resize', this.resize);
		if (this.props.objCode) {
			const { objCode } = this.props;

			if (objCode == 1 || objCode == '1') {
				this.initColumn();
			} else {
				getServicesNomal(findByCodeApi, { objCode: this.props.objCode }).then(dataObj => {
					this.setState({ objId: dataObj.id, isTable: data.isTable }, () => {
						this.initColumn();
					});
				});
			}
		} else {
			getServicesNomal(getDetailApi, { id: this.state.objId }).then(data => {
				this.setState({ isTable: data.isTable });
			});
      		this.initColumn();
		}
	}

	/**
	 * 移除监听器
	 */
	componentWillUnmount() {
		window.removeEventListener('resize', this.resize);
	}

	custom = this.props.value ? JSON.stringify(this.props.value) : null;

	componentWillReceiveProps(nextProps) {
		const b = nextProps.value || {};
		const a = this.props.value || {};

		if (JSON.stringify(a) != JSON.stringify(b)) {
			const params = {
				pageNo: 1,
				pageSize: this.props.pageSize || 10,
				query: JSON.stringify(this.state.formValues),
			};
			if (nextProps.value.columns != null && nextProps.value.columns.length > 0) {
				this.columns = nextProps.value.columns;
			}

			this.custom = JSON.stringify(b);
			if (nextProps.value.getPage) {
				this.getPage(params, null, nextProps.value.getPage);
			} else {
				if (this.state.objId) this.getPage(params);
			}
		}
		const x = nextProps.selects;
		const y = this.props.selects;
		if (JSON.stringify(x) != JSON.stringify(y)) {
			this.setState({ selects: x });
		}
	}

	initColumn = () => {
		const { columnRights } = this.state;
		if (this.props.value && this.props.value.columns) {
			this.columns = this.props.value.columns;
			this.getPage();
			return;
		}
		if (this.props.objCode == 1 || this.props.objCode == '1') {
		} else {
			getServicesNomal(getHeaderListApi, { dataObjId: this.state.objId }).then(datas => {
				const querys = [];
				const refIds = [];
				const groups = {};
				if (datas) {
					this.state.formItem = datas;
					let i = 0;

					for (let t in datas) {
						if (datas[t].isPrimaryKey) this.state.primaryKey = datas[t].name;
						if (datas[t].isHidden) {
							continue;
						}
						let column = {};
						column.title = datas[t].title;
						column.dataIndex = datas[t].name;
						column.width = datas[t].width;
						if (i == 0) column.fixed = 'left';

						if (columnRights.length > 0 && !columnRights.includes(datas[t].id)) {
							continue;
						}
						if (data.includes(datas[t].type)) {
							column.render = (val) => {
								if (val == null) {
									return val;
								}
								if (datas[t].dataFormatStrWeb != null) {
									return moment(val).format(datas[t].dataFormatStrWeb);
								} else {
									return moment(val).format('YYYY-MM-DD HH:mm:ss');
								}
							};
						} else if (datas[t].name.indexOf('process_status') > -1) {
							column.render = (val) => (val ? (val === '0' ? '审核通过' : '审核未通过') : null);
						} else if (datas[t].extendTypeId && datas[t].extendTypeId.indexOf('file') > -1) {
							//特殊处理附件
							column.render = (val) => {
								if (this.isJSON(val)) {
									val = JSON.parse(val);
									let files = val.files;
									let xx = (
										<ul>
											{files.map((f, index2) => {
												return (
													<li key={index2}>
														<FilePreview 
														path={queryFileUrl(f.path)} 
														pathName={f.name} 
														images={files?.map((item) => {
															return {
																src: queryFileUrl(item.path),
																alt: '预览',
															};
														 })}
														 activeIndex={index2}
														/>
													</li>
												);
											})}
										</ul>
									);
									return xx;
								} else {
									return val;
								}
							};
						} else {
							column.render = (val) =>
								val && val.length > 100 ? (
									<Tooltip title={val} overlayStyle={{ width: 1000 }}>
										<span
											style={{
												width: column.width || 200,
												display: 'block',
												wordBreak: 'keep-all',
												whiteSpace: 'nowrap',
												overflow: 'hidden',
												textOverflow: 'ellipsis',
											}}>
											{val}
										</span>
									</Tooltip>
								) : (
									val
								);
						}

						this.setState({ tableWidth: (datas.length - 1) * 200 });
						this.columns.push(column);

						if (datas[t].isShowQuery) {
							querys.push(datas[t]);
							if (datas[t].referenceObjId != null) {
								refIds.push(datas[t].id);
							}
							if (datas[t].isGroupQuery != null) {
								getServicesNomal(getGroupListApi, { columnId: datas[t].id }).then(gourp => {
									groups[datas[t].id] = gourp;
									this.setState({ groups });
								});
							}
						}
						i++;
					}
					if (querys.length > 0) {
						this.setState({ querys });
						if (refIds.length > 0) {
							getServicesNomal(getBatchOptionsApi, { ids: refIds }).then(options => {
								this.setState({ options });
							})
						}
					}

					this.getPage();
				}
			});
		}
	};
	sqlBs16 = this.props.sql;
	getPage = (params, values, callPage, callback) => {
		if (this.columns == null || this.columns.length == 0) {
			return;
		}
		const {
			json: { treeParentIdName },
		} = this.props;
		const pagination = this.state.data.pagination;

		if (params == null) {
			params = {
				// pageNo: pagination.current ? pagination.current : 1,
				//pageSize: pagination.pageSize ? pagination.pageSize : (this.props.pageSize||10),
				query: JSON.stringify(values != null ? values : this.state.formValues),
			};
		}

		if (this.props.objCode && (this.props.objCode == '1' || this.props.objCode == 1)) {
			if (callPage) {
				callPage(params, (data) => {
					if (!this.state.isReady) {
						this.setState({ data, isReady: true });
					} else {
						this.setState({ data });
					}
				});
			} else if (this.props.value && this.props.value.getPage) {
				this.props.value.getPage(params, (data) => {
					if (!this.state.isReady) {
						this.setState({ data, isReady: true });
					} else {
						this.setState({ data });
					}
				});
			}
		} else {
			getServicesNomal(getFormDataListApi, {
				custom: this.custom,
				...params,
				parentIdName: treeParentIdName,
				sql: this.sqlBs16,
				dataObjId: this.state.objId,
			}).then((list) => {
				const data = {
					list: list,
					pagination: false,
				};

				if (!this.state.isReady) {
					this.setState({ data, parentId: params.parentId, isReady: true }, () => {
						if (callback) callback(list);
					});
				} else {
					this.setState({ data, parentId: params.parentId }, () => {
						if (callback) callback(list);
					});
				}
			});
		}
	};

	handleStandardTableChange = (pagination, filtersArg, sorter) => {
		const filters = Object.keys(filtersArg).reduce((obj, key) => {
			const newObj = { ...obj };
			newObj[key] = getValue(filtersArg[key]);
			return newObj;
		}, {});

		const params = {
			pageNo: pagination.current,
			pageSize: pagination.pageSize,
			...filters,
			query: JSON.stringify(this.state.formValues),
		};
		if (sorter.field) {
			params.sorter = `${sorter.field}_${sorter.order}`;
		}
		this.getPage(params);
	};

	handleAdd = (fields, isAdd) => {
		const {
			json: { treeParentIdName },
		} = this.props;
		let params = {
			...fields,
		};
		params[treeParentIdName] = this.state.parentId;
		getServicesNomal(addFormDataApi, {
			params: params,
			objId: this.state.objId,
			isAdd: isAdd,
			isSelf: true,
			isView: false,
		}).then(() => {
			message.success('操作成功');
			this.getPage({ parentId: this.state.parentId }, null, null, (list) => {
				const treeData = this.refesh(this.state.parentId, list, this.state.treeData);
				this.setState({
					modalVisible: false,
					treeData,
				});
			});
		});
	};

	handleModalVisible = () => {
		this.setState({
			modalVisible: this.state.modalVisible ? false : true,
			formData: {},
		});
	};

	add = () => {
		// if (this.state.formItem.length < 10) {
		this.getOptions();
		this.setState({
			modalVisible: true,
			formData: {},
			isAdd: true,
			isView: false,
		});
	};

	handleSelectRows = (rows) => {
		if (this.props.onSelectRow) {
			this.props.onSelectRow(rows);
		}
		this.setState({
			selectedRows: rows,
		});
	};

	batchDelete = (e) => {
		const { selectedRows } = this.state;

		if (!selectedRows) return;

		let columns = this.state.formItem;
		let Keys = {};

		for (let i in columns) {
			if (columns[i].isPrimaryKey) {
				//key
				Keys[columns[i].name] = selectedRows.map((row) => row[columns[i].name]).join(',');
			}
		}
		getServicesNomal(deleteFormDataApi, {
			keys: JSON.stringify(Keys),
			objId: this.state.objId,
			isSelf: true,
		}).then(() => {
			this.setState({
				selectedRows: [],
			});
			this.getPage();
		});
	};

	goBack = () => {
		router.goBack();
	};
	handleSearch = (e) => {
		e.preventDefault();

		const { form } = this.props;

		const { formValues } = this.state;

		form.validateFields((err, fieldsValue) => {
			if (err) return;

			const formItem = this.state.formItem;
			formItem.map((item, index) => {
				if (item.type.indexOf('DATE') > -1) {
					for (let d in fieldsValue) {
						if (item.name === d && fieldsValue[d]) {
							if (fieldsValue[d] != null && fieldsValue[d].length > 0) {
								fieldsValue[d] = [
									fieldsValue[d][0].format('YYYY-MM-DD HH:mm:ss'),
									fieldsValue[d][1].format('YYYY-MM-DD HH:mm:ss'),
								];
							} else {
								fieldsValue[d] = '';
							}
						}
					}
				}
			});
			const values = {
				...this.state.formValues,
				...fieldsValue,
			};
			this.setState({
				formValues: fieldsValue,
			});

			this.getPage(null, values);
		});
	};

	hanldeHighSearch = (e) => {
		const pagination = this.props.formList.data.pagination;
		let params = {
			pageNo: pagination.current ? pagination.current : 1,
			pageSize: pagination.pageSize ? pagination.pageSize : this.props.pageSize || 10,
			...e,
		};
		this.setState({ formValues: { ...e, ...this.state.formValues } });
		this.getPage(params);
	};
	handleFormReset = () => {
		const { form } = this.props;
		form.resetFields();
		this.setState(
			{
				formValues: {},
			},
			() => {
				this.getPage();
			},
		);
	};
	getItem = (isQuery, form, item, isAdd, formData, labelCol, wrapperCol) => {
		const { groups, isView } = this.state;
		if (item.isPrimaryKey) {
			if (isAdd) {
				return <></>;
			} else {
				return (
					<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
						{form.getFieldDecorator(item.name, {
							initialValue: formData == null ? '' : formData[item.name],
							rules: [{ required: !item.isNull }],
						})(<Input style={{ width: '70%' }} readOnly={!isAdd} placeholder="请输入" />)}
					</FormItem>
				);
			}
		} else if (item.referenceObjId != null) {
			const { options } = this.state;
			const ops = options[item.id + ''] || [];

			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue: formData == null ? '' : formData[item.name],
						rules: [{ required: !item.isNull }],
					})(
						<Select style={{ width: '70%' }} placeholder="请选择" allowClear>
							{ops.map((r) => (
								<Option value={r[item.referenceCodeName]} key={r[item.referenceCodeName]}>
									{r[item.referenceNameName]}
								</Option>
							))}
						</Select>,
					)}
				</FormItem>
			);
		} else if (item.name.indexOf('process_status') > -1) {
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue: formData == null ? '' : formData[item.name],
						rules: [{ required: !item.isNull }],
					})(
						<Select style={{ width: '70%' }} placeholder="请选择" allowClear>
							<Option value={'0'} key={'0'}>
								审核通过
							</Option>
							<Option value={'2'} key={'2'}>
								审核未通过
							</Option>
						</Select>,
					)}
				</FormItem>
			);
		} else if (item.extendTypeId && item.extendTypeId.indexOf('file') > -1) {
			//特殊处理附件 如果是查询就 跳过
			if (isQuery) return;
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue:
							formData == null
								? ''
								: formData[item.name] && this.isJSON(formData[item.name])
									? JSON.parse(formData[item.name])
									: null,
						rules: [{ required: !item.isNull }],
					})(<UploadCom disabled={isView} />)}
				</FormItem>
			);
		} else if (isQuery && item.isGroupQuery != null && item.isGroupQuery) {
			//如果是查询 并且是组合查询

			const ops = groups[item.id + ''] || [];
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue: formData == null ? '' : formData[item.name],
						rules: [{ required: !item.isNull }],
					})(
						<Select style={{ width: '70%' }} placeholder="请选择" allowClear>
							{ops.map((r) => (
								<Option value={r.value} key={r.value}>
									{r.value}
								</Option>
							))}
						</Select>,
					)}
				</FormItem>
			);
		} else if (text.indexOf(item.type) > -1) {
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue: formData == null ? '' : formData[item.name],
						rules: [{ required: !item.isNull }],
					})(<Input style={{ width: '70%' }} placeholder="请输入" />)}
				</FormItem>
			);
		} else if (number.indexOf(item.type) > -1) {
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue: formData == null ? '' : formData[item.name],
						rules: [{ required: !item.isNull }],
					})(<InputNumber placeholder="请输入" min={0} />)}
				</FormItem>
			);
		} else if (isQuery && data.indexOf(item.type) > -1) {
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue: formData == null ? null : moment(formData[item.name]),
						rules: [{ required: !item.isNull }],
					})(
						<RangePicker
							format={item.dataFormatStrWeb == null ? 'YYYY-MM-DD HH:mm:ss' : item.dataFormatStrWeb}
							style={{ width: '95%' }}
						/>,
					)}
				</FormItem>
			);
		} else if (data.indexOf(item.type) > -1) {
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue:
							formData == null
								? moment()
								: formData[item.name]
									? moment(formData[item.name])
									: null,
						rules: [{ required: !item.isNull }],
					})(
						<DatePicker
							format={item.dataFormatStrWeb == null ? 'YYYY-MM-DD HH:mm:ss' : item.dataFormatStrWeb}
							style={{ width: '100%' }}
							placeholder="请输入"
						/>,
					)}
				</FormItem>
			);
		} else {
			return (
				<FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
					{form.getFieldDecorator(item.name, {
						initialValue: formData == null ? '' : formData[item.name],
						rules: [{ required: !item.isNull }],
					})(<Input style={{ width: '70%' }} placeholder="请输入" />)}
				</FormItem>
			);
		}
	};

	renderForm() {
		const { form, get } = this.props;

		const { querys } = this.state;
		if (querys.length == 0) {
			return '';
		}

		return (
			<Form layout="inline">
				<Row style={{ padding: '15px' }}>
					{querys.map((item) => (
						<Col style={{ height: 58 }} span={get === 'mobile' ? 24 : 8} key={item.id}>
							{this.getItem(
								true,
								form,
								{
									...item,
									isNull: true,
								},
								true,
							)}
						</Col>
					))}

					<Col
						span={get === 'mobile' ? 24 : 8}
						style={{
							textAlign: get === 'mobile' ? 'right' : '',
							paddingRight: get === 'mobile' ? 12 : '',
						}}>
						<span className={styles.submitButtons}>
							<Button type="primary" loading={this.props.loading} onClick={this.handleSearch}>
								查询
							</Button>
							<Button style={{ marginLeft: 8 }} onClick={this.handleFormReset}>
								重置
							</Button>
							{/* <a style={{ marginLeft: 8 }} onClick={this.toggleForm}>
                展开 <Icon type="down" />
              </a> */}
						</span>
					</Col>
				</Row>
			</Form>
		);
	}

	onSelect = (selectedKeys, info) => {
		if (info.selectedNodes.length > 0) {
			const parentId = selectedKeys[0] != '0-0' ? selectedKeys[0] : null;
			this.setState({ parentName: info.selectedNodes[0].props.title, parentId });
			this.getPage({ parentId: parentId });
		}
	};
	onLoadData = (treeNode) => {
		return new Promise((resolve) => {
			if (treeNode.props.childs) {
				resolve();
				return;
			}
			const parentId = treeNode.props.eventKey != '0-0' ? treeNode.props.eventKey : null;
			this.getList(
				{ parentId: parentId },
				(list) => {
					treeNode.props.dataRef.childs = list;
					this.setState({
						treeData: [...this.state.treeData],
					});
					resolve();
				},
				true,
			);
		});
	};

	renderTreeNodes = (list) => {
		const {
			json: { treeTitleName, treeKeyName },
		} = this.props;

		return list.map((item) => {
			item.title = item[treeTitleName];
			item.key = item[treeKeyName];
			if (item.childs) {
				return (
					<TreeNode title={item[treeTitleName]} key={item.key} dataRef={item}>
						{this.renderTreeNodes(item.childs)}
					</TreeNode>
				);
			}
			return <TreeNode {...item} dataRef={item} />;
		});
	};
	refesh = (parentId, list, data) => {
		if (parentId == null) {
			data[0].childs = list;
			return data;
		}
		for (var i = 0; i < data.length; i++) {
			if (data[i].key == parentId) {
				data[i].childs = list;
				break;
			} else {
				if (data[i].childs) {
					this.refesh(parentId, list, data[i].childs);
				}
			}
		}

		return data;
	};

	render() {
		const { modalVisible, selectedRows, querys, tableWidth, rights, data, isReady } = this.state;
		if (!isReady) {
			return (
				<div style={{ width: 20, margin: 'auto' }}>
					<Spin />
				</div>
			);
		}
		const {
			isFormCom,
			isSelect,
			get,
			callback,
			valueName,
			notShowBack,
			istableCom, // 是否有模板设计器调用
			value: { btns },
			json: { treeSpan },
			loading,
		} = this.props;
		const { showMobileDiv, isView } = this.state;

		let scrollWidth = document.documentElement.clientWidth || document.body.clientWidth; //可使宽度
		let isMobile = scrollWidth < 1200;
		if (document.querySelector('#previewDiv')) {
			isMobile = true;
		}
		let showDiv =
			document.querySelector('#mobelDiv') &&
			document.querySelector('#mobelDiv')?.parentNode.clientWidth;
		const parentMethods = {
			handleAdd: this.handleAdd,
			handleModalVisible: this.handleModalVisible,
			formData: this.state.formData,
			formItem: this.state.formItem,
			isAdd: this.state.isAdd,
			getItem: this.getItem,
			isView: isView,
		};

		if (
			!isSelect &&
			!rights.includes('edit') &&
			!rights.includes('delete') &&
			!rights.includes('view') &&
			!rights.includes('viewProcess')
		) {
		} else {
			let width = 0;
			if (rights && rights.includes('viewProcess')) {
				width = width + 75;
			}
			if (rights && rights.includes('view')) {
				width = width + 75;
			}
			if (rights && rights.includes('edit')) {
				width = width + 40;
			}
			if (rights && rights.includes('delete')) {
				width = width + 40;
			}
			const column = {
				title: '操作',
				fixed: 'right',
				width: width,
				render: (text, record) => {
					return (
						<Fragment>
							<div style={{ textAlign: 'center' }}>
								{isSelect ? (
									this.state.selects.includes(record[valueName]) ? (
										<>
											<span>已选择</span>
											<Divider type="vertical" />
										</>
									) : (
										<>
											<a onClick={callback.bind(this, record, this.columns)}>选择</a>
											<Divider type="vertical" />
										</>
									)
								) : (
									''
								)}
								{rights && !rights.includes('view') ? (
									''
								) : (
									<>
										<a onClick={this.view.bind(this, record)}>查看详情</a>
										<Divider type="vertical" />
									</>
								)}
								{rights && !rights.includes('edit') ? (
									''
								) : (
									<>
										<a onClick={this.modify.bind(this, record)}>编辑</a>
										<Divider type="vertical" />
									</>
								)}
								{rights && rights.includes('viewProcess') && record.process_biz_key ? (
									<>
										<a onClick={this.viewProcess.bind(this, record)}>查看流程详情</a>
										<Divider type="vertical" />
									</>
								) : (
									''
								)}
								{rights && !rights.includes('delete') ? (
									''
								) : (
									<>
										{' '}
										<Popconfirm
											title="确定删除该数据?"
											onConfirm={this.delete.bind(this, record)}
											okText="确定"
											cancelText="取消">
											<a>删除</a>
										</Popconfirm>
									</>
								)}
							</div>
						</Fragment>
					);
				},
			};
			if (this.columns.length > 0 && this.columns[this.columns.length - 1].title == '操作') {
				this.columns[this.columns.length - 1] = column;
			} else {
				this.columns.push(column);
			}
		}

		if (this.columns) {
			/**
			 * 计算总长度
			 */
			AllWidth = 0;
			this.columns = this.columns.map((item, index) => {
				if (isEmpty(item)) {
					return item;
				}
				if (
					index === this.columns.length - 1 &&
					this.columns[this.columns.length - 1].title !== '操作'
				) {
					AllWidth += 150;
					item.width = '';
					return item;
				}
				let width = item.width ? item.width : 150;
				if (!item.width) {
					item.width = 150;
				}
				AllWidth += width;
				return item;
			});
			if (
				!isEmpty(this.columns[this.columns.length - 1]) &&
				this.columns[this.columns.length - 1].title === '操作'
			) {
				this.columns[this.columns.length - 2].width = '';
				AllWidth += 100;
			}
		}
		const xxxx = (
			<>
				<Row gutter={16}>
					<Col span={treeSpan}>
						<Card bordered={false} style={{ minHeight: 500 }}>
							<Tree
								showLine
								defaultExpandedKeys={['0-0']}
								onSelect={this.onSelect}
								loadData={this.onLoadData}>
								{this.renderTreeNodes(this.state.treeData)}
							</Tree>
						</Card>
					</Col>
					<Col span={24 - treeSpan}>
						<Card bordered={false} bodyStyle={{ padding: 0 }}>
							<div className={styles.tableList}>
								<div className={styles.tableListForm}>{this.renderForm()}</div>
								<div className={styles.tableListOperator}>
									{notShowBack ? (
										notShowBack
									) : (
										<Button icon="rollback" type="primary" onClick={this.goBack}>
											返回
										</Button>
									)}
									{btns && btns.before && btns.before.length > 0
										? btns.before.map((r) => <Button {...r} />)
										: ''}
									{rights && !rights.includes('add') ? (
										''
									) : (
										<Button icon="plus" type="primary" onClick={this.add}>
											新建
										</Button>
									)}
									{rights && !rights.includes('searchData') ? (
										''
									) : (
										<SearchInfo hanldeHighSearch={this.hanldeHighSearch} objId={this.state.objId} />
									)}

									{rights && !rights.includes('importData') ? (
										''
									) : (
										<ImportUtil objId={this.state.objId} />
									)}
									{rights && !rights.includes('exportCurrent') ? (
										''
									) : (
										<ExportCurrentInfo
											objId={this.state.objId}
											query={JSON.stringify(this.state.formValues)}
											custom={
												this.props.value ? Base16Encode(JSON.stringify(this.props.value)) : null
											}
											sql={Base16Encode(this.props.sql)}
										/>
									)}

									{this.props.value && this.props.value.exportConfig
										? this.props.value.exportConfig.map((r, i) => (
												<ExportCurrentInfo
													objId={this.state.objId}
													query={JSON.stringify(this.state.formValues)}
													custom={
														this.props.value ? Base16Encode(JSON.stringify(this.props.value)) : null
													}
													index={i}
													btn={r.btn}
													ext={r.ext ? r.ext : 'xlsx'}
													sql={Base16Encode(this.props.sql)}
												/>
										  ))
										: ''}
									{rights && !rights.includes('exportData') ? (
										''
									) : (
										<ExportInfo objId={this.state.objId} />
									)}
									{rights && !rights.includes('statistics') ? (
										''
									) : (
										<StatisticsInfo objId={this.state.objId} />
									)}
									{rights && !rights.includes('delete')
										? ''
										: selectedRows.length > 0 && (
												<span>
													<Popconfirm
														title="确定删除该数据?"
														onConfirm={this.batchDelete}
														okText="确定"
														cancelText="取消">
														<Button>批量删除</Button>
													</Popconfirm>
												</span>
										  )}
									{btns && btns.after && btns.after.length > 0
										? btns.after.map((r) => <Button {...r} loading={loading} />)
										: ''}
								</div>
								{!istableCom || (this.props.value && this.props.value.columns) ? (
									<StandardTable
										showHeader={this.props.showHeader != null ? this.props.showHeader : true}
										noSelectRow={
											this.props.onSelectRow == null &&
											(rights == null || !rights.includes('delete'))
										}
										rowKey="id"
										data={data}
										isHiddenPage={this.props.isHiddenPage != null ? this.props.isHiddenPage : false}
										columns={this.columns}
										scroll={this.props.value && this.props.value.columns ? {} : { x: AllWidth }}
										selectedRows={selectedRows}
										onSelectRow={this.handleSelectRows}
										onChange={this.handleStandardTableChange}
										loading={this.props.loading}
									/>
								) : (
									<div
										id="mobelDiv"
										style={{
											overflow: 'hidden',
											width: isMobile ? showMobileDiv : showDiv,
											height: '100%',
										}}>
										<div>
											{get === 'mobile' ? <div>手机端,请将手机横屏查看</div> : null}
											{showDiv && (
												<StandardTable
													showHeader={this.props.showHeader != null ? this.props.showHeader : true}
													noSelectRow={
														this.props.onSelectRow == null &&
														(rights == null || !rights.includes('delete'))
													}
													rowKey="id"
													data={data}
													columns={this.columns}
													scroll={
														this.props.value && this.props.value.columns ? {} : { x: AllWidth }
													}
													selectedRows={selectedRows}
													isHiddenPage={
														this.props.isHiddenPage != null ? this.props.isHiddenPage : false
													}
													onSelectRow={this.handleSelectRows}
													onChange={this.handleStandardTableChange}
													loading={this.props.loading}
												/>
											)}
										</div>
									</div>
								)}
							</div>
						</Card>
					</Col>
				</Row>
				<CreateForm {...parentMethods} modalVisible={modalVisible} />
			</>
		);
		if (isFormCom) {
			return xxxx;
		}
		return <PageHeaderWrapper title="">{xxxx}</PageHeaderWrapper>;
	}
}

export default TreeList;
