//@ts-nocheck
import React, { Component } from 'react';
import { Upload, message, Button, Modal } from 'antd';
import { getToken } from '@/webPublic/one_stop_public/utils/token';
import { uaaRequest } from "@/webPublic/one_stop_public/utils/request";
import getOneStopUploadUrl from '@/webPublic/one_stop_public/Base16/getOneStopUploadUrl';


export default class UploadZipCom extends Component{
	constructor(props) {
		super(props);
		this.config = props.config || {};
		this.state = {
			confirmLoading: false,
			showModal: false,
		};
	}

	changeUrl = (info) => {
		if (info.file.status === 'done') {
			message.success(`${info.file.name} 上传压缩包成功,正在保存数据,请稍后`);
			this.setState({ file: info.file.response, confirmLoading: true });
			let params = {
        dataObjId: this.props.dataObjId,
        isExchange: this.config.isExchange,
        nameKey: this.config.nameKey,
        valueKey: this.config.valueKey,
        zipPath: info.file.response,
      };
			if(this.config.otherParams){
			  params = {
			    ...params,
          ...this.config.otherParams,
        };
      }
			uaaRequest('/DataObjApi/importZip', params).then(() => {
					this.setState({ confirmLoading: false });
					message.success('数据保存成功');
					this.changeShowModal(); // 禅道 3730 服兵役国家教育资助统计---军士生学费补偿tab页，上传的附件报提示成功，实际看不到
				});
		} else if (info.file.status === 'error') {
			message.error(`${info.file.name} 上传失败`);
		}
	};

	changeShowModal = () => {
		this.setState({
			showModal: !this.state.showModal,
		});
	};

	render() {
		const { confirmLoading, showModal } = this.state;
		const { modalMessageHtml, modalTitle = '上传zip压缩包文件' } = this.config;
		const props = {
			name: 'file',
			multiple: false,
			action: getOneStopUploadUrl(),
			showUploadList: false,
			onChange: this.changeUrl,
			headers: {
				Authorization: `bearer ${getToken()}`,
			},
			data: {
				token: getToken(),
			},
		};
		const btn = this.config.btn ? this.config.btn : { name: '导出' };
		return (
			<>
				<Button type='default' onClick={this.changeShowModal}>
					{btn.name}
				</Button>
				<Modal title={modalTitle}
							 footer={null}
							 onCancel={this.changeShowModal}
							 visible={showModal}
				>
					<div style={{
						display: 'flex',
						alignItems: 'center',
						justifyContent: 'center',
						flexDirection: 'column',
					}}>
						<div style={{ margin: '10px 0' }}>
							<div dangerouslySetInnerHTML={{ __html: modalMessageHtml }} />
						</div>
						<Upload {...props}>
							<Button {...btn} type='danger' loading={confirmLoading}>
								点击上传
							</Button>
						</Upload>
					</div>

				</Modal>
			</>
		);
	}
}
