/**
 * 签到功能
 */
import React, { Component } from 'react';
import Location from './components';
import { isEmpty } from 'lodash';
import { openToast } from './Notification';
import { successToast, failToast } from './Toast';

export default class location extends Component {
  constructor(props) {
    super(props);
    this.state = {
      locationMsg: {},
      btn: true,
      style: { display: 'none' },
    };
  }
  // 该方法在首次渲染之前调用(数据初始化)
  componentWillMount() {}
  //已经生成对应的dom结构
  componentDidMount = () => {};
  //在组件从 DOM 中移除的时候立刻被调用。
  componentWillUnmount = () => {};
  getLocationMsg = locationMsg => {
    //如果不为空的话显示提示
    this.setState({ loading: true }, () => {
      if (Object.keys(locationMsg).length !== 0) {
        this.props.onChange(locationMsg);
        this.setState({
          locationMsg: locationMsg,
          loading: false,
          style: { display: 'block' },
          btn: false,
        });
      } else {
        this.setState({
          loading: false,
        });
      }
    });
  };
  submitLocation = () => {
    const { showLocation } = this.props;
    if (!showLocation) return;
    if (isEmpty(this.state.locationMsg) && window.lat && window.lng) {
      let obj = {
        lat: window.lat,
        lng: window.lng,
      };
      this.props.onChange(obj);
      if (this.props.get === 'web') {
        openToast('success', '成功', '已添加定位地址');
      } else {
        successToast('已添加定位地址');
      }
    } else if (!isEmpty(this.state.locationMsg)) {
      this.props.onChange(this.state.locationMsg);
      if (this.props.get === 'web') {
        openToast('success', '成功', '已添加定位地址');
      } else {
        successToast('已添加定位地址');
      }
    } else {
      if (this.props.get === 'web') {
        openToast('error', '错误', '定位失败，请稍后重试');
      } else {
        successToast('定位失败，请稍后重试');
      }
    }
  };
  // 点击确定提交定位
  confirm = e => {
    if (this.state.btn) {
      if (this.props.get === 'web') {
        openToast('error', '错误', '正在定位，请稍后重试');
      } else {
        failToast('正在定位，请稍后重试');
      }
      return;
    }
    this.submitLocation();
  };
  render() {
    let { locationMsg, btn } = this.state;
    let { lat, lng, address, params, json, showLocation } = this.props;

    return (
      <div style={{ display: 'flex' }}>
        <Location
          lat={lat}
          json={json}
          lng={lng}
          getLocationMsg={this.getLocationMsg.bind(this)}
          showMap={this.props.showMap}
          params={params}
        />
        <div style={{ display: 'block'}}>
          {locationMsg?.address || ''}
         {/* <Popconfirm
            title={btn ? '正在定位中' : locationMsg.address}
            onConfirm={this.confirm}
            okText="提交"
            cancelText="取消"
          >
            <Button
              disabled={btn}
              style={{ margin: 'auto', width: this.props.width }}
              loading={this.state.loading}
              className={styles.btn}
              type="primary"
            >
              {this.props.btnName}
            </Button>
          </Popconfirm>*/}
        </div>
      </div>
    );
  }
}
