import { uaaRequest } from '../utils/request';
const api = '/UnifiedAppFormApi';


const myCollect = {
  namespace: 'countersign', // 加签
  state: {
    user: {}, // 用户数据
  },

  effects: {
    /**
     * 转办流程
     * @param { string|Array } taskId 需要转交流程ID
     * @param { Array } userIds  加签人id
     */
    *countersignHandle({ payload, callback }, { call, put }) {
      const response = yield call(uaaRequest, `${api}/addSigns`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 介入（改派流程）
     * @param { string } taskId 表Id
     * @param { string } userId 用户Id
     */
    *involvedHandle({ payload, callback }, { call, put }) {
      const response = yield call(uaaRequest, `${api}/reassignmentProcess`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
  },
  reducers: {
    nom(state) {
      return { ...state };
    },
  },
};
export default myCollect;
