import { apiRequest } from '../utils/request';

const api = '/DataColumnApi';
export default {
	namespace: 'DataColumn',

	state: {
		isShowModal: {},

		list: [],
		refs: [],
	},

	effects: {
		*showModal({ payload, callback }, { call, put }) {
			yield put({
				type: 'show',
				payload: payload,
			});

			if (callback && typeof callback === 'function') {
				callback();
			}
		},
		*clear({ payload, callback }, { call, put }) {
			yield put({
				type: 'list',
				payload: [],
			});
			if (callback && typeof callback === 'function') {
				callback();
			}
		},
		*autoCreate({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/autoCreate', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getBatchOptions({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getBatchOptions', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*findByName({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getList', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getOptions({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getOptions', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getLabels({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getLabels', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getSqlOptions({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getSqlOptions', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getSqlLabels({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getSqlLabels', payload);

			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getSqlData({ payload, callback }, { call, put }) {

			const response = yield call(apiRequest, api + '/getSqlData', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},

		*add({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/add', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*fetch({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getList', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'list',
				payload: { list: response, isReference: payload.isReference },
			});
			if (callback) callback(response);
		},
		*remove({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/remove', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},
		*deleteReference({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/deleteReference', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},

		*open({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/open', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},

		*addReference({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/addReference', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},
	},

	reducers: {
		list(state, action) {
			if (action.payload.isReference) {
				return {
					...state,

					refs: action.payload.list,
				};
			} else {
				return {
					...state,
					list: action.payload.list,
				};
			}
		},
		page(state, { payload }) {
			return {
				...state,
				data: {
					list: payload.rows,
					pagination: {
						current: payload.pageNo,
						pageSize: payload.pageSize,
						total: payload.total,
					},
				},
			};
		},
		nom(state, action) {
			return { ...state };
		},
		show(state, { payload }) {
			return { ...state, isShowModal: payload.isShowModal };
		},
	},
};
