import { apiRequest, getRequest } from '../utils/request';

const api = '/DataGgEditorApi'
export default {
    namespace: 'DataGgEditor',
    state: {
        data: {
            allmasg: {}
        },
    },
    // 6c64c3f8-1c91-11ea-930a-525400e1d4cc/editor
    effects: {
        * fetch({ callback, payload }, { call, put }) {//获取数据
            const response = yield call(getRequest, `/app/rest/models/${payload}/editor/json`);
            if (response == null) {
                yield put({ type: 'nom' });
                return
            }
            yield put({
                type: 'allmasg',
                payload: response,
            });
            if (callback) callback(response);
        },
        * getNewProcessImg({ callback, payload }, { call, put }) {//获取数据
            const response = yield call(getRequest, `/UnifiedAppFormApi/getNewProcessImg?appId=${payload.appid}&code=${payload.code}`);
            if (response == null) {
                yield put({ type: 'nom' });
                return
            }
            yield put({
                type: 'allmasg',
                payload: response,
            });
            if (callback) callback(response);
        },
        * getDistriBution({ callback, payload }, { call, put }) {
            const response = yield call(getRequest, `/demo/rest/editor-users?filter=${payload}`);

            if (response == null) {
                yield put({ type: 'nom' });
                return
            }
            yield put({
                type: 'allmasg',
                payload: response,
            });
            if (callback) callback(response);
        },
        *getGroupList({ payload, callback }, { call, put }) {
            const response = yield call(getRequest, `/demo/rest/editor-groups?filter=${payload}`)
            if (response == null) {
                yield put({ type: 'nom' });
                return
            }
            yield put({
                type: 'allmasg',
                payload: response,
            });
            if (callback) callback(response);

        },
        *upData({ payload, callback }, { call, put }) {//上传数据
            const newPayload = JSON.parse(JSON.stringify(payload))//数据转换
            newPayload.json_xml = JSON.stringify(newPayload.model)//转换model中的数据为字符串
            newPayload.newversion = true //是否定义新版本
            // console.log(newPayload)
            const response = yield call(apiRequest, `/app/rest/models/${payload.modelId}/editor/json`, newPayload);
            if (response == null) {
                yield put({ type: 'nom' });
                return
            }
            yield put({
                type: 'allmasg',
                payload: response,
            });
            if (callback) callback(response);

        },

    },
    reducers: {
        allmasg(state, { payload }) {
            return {
                ...state,
                data: {
                    allmasg: payload
                }
            };
        },
        nom(state, action) {
            return {
                ...state,
                status: 'ok'
            };


        },

    },
};
