import { apiRequest } from '../utils/request';

const api = '/DataObjApi';
export default {
	namespace: 'formList',

	state: {
		list: [],
		data: {
			list: [],
			pagination: {},
		},
	},

	effects: {
		*clear({ payload, callback }, { call, put }) {
			yield put({
				type: 'clearAll',
				payload: {},
			});
		},
		*getHead({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, '/DataColumnApi/getHeaderList', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*tree({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getFormDataList', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*getAppId({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, '/UnifiedAppFormApi/getDetailByCode', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*getBatchOptions({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, '/DataColumnApi/getBatchOptions', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*getGroupList({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, '/DataColumnApi/getGroupList', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*getObjDetail({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, '/DataObjApi/getDetail', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*fetch({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getFormDataPage', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'page',
				payload: response,
			});

			if (callback) {
				callback({
					list: response.rows,
					pagination: {
						current: response.pageNo,
						pageSize: response.pageSize,
						total: response.total,
					},
				});
			}
		},
		*add({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/addFormData', {
				data: JSON.stringify(payload.params),
				isAdd: payload.isAdd,
				objId: payload.objId,
			});
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*delete({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/deleteFormData', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*getDetail({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getFormData', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
	},
	reducers: {
		clearAll(state, action) {
			return {
				...state,
				data: {
					list: [],
					pagination: {},
				},
			};
		},
		list(state, action) {
			return {
				...state,
				list: action.payload,
			};
		},
		page(state, { payload }) {
			return {
				...state,
				data: {
					list: payload.rows,
					pagination: {
						current: payload.pageNo,
						pageSize: payload.pageSize,
						total: payload.total,
					},
				},
			};
		},
		nom(state, action) {
			return { ...state };
		},
	},
};
