import { apiRequest } from '../utils/request';
const api = '/SqlManageEntityApi';
export default {
	namespace: 'SqlManageEntity',
	state: {
		data: {
			list: [],
			pagination: {},
		},
	},

	effects: {
		*find({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/find', payload);

			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*add({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/add', payload);

			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback({ suc: true });
		},
		*changeType({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/changeType', payload);
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback({ suc: true });
		},
		*fetch({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getPage', payload);

			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'list',
				payload: response,
			});
		},
		*remove({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/remove', payload);

			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},
	},

	reducers: {
		list(state, { payload }) {
			return {
				...state,
				data: {
					list: payload.rows,
					pagination: {
						current: payload.pageNo,
						pageSize: payload.pageSize,
						total: payload.total,
					},
				},
			};
		},
		nom(state, action) {
			return { ...state, status: 'ok' };
		},
	},
};
