/**
 * 徐立
 * 2019年11月8日
 * 绑定邮箱手机相关请求
 */
import { uaaRequest } from '../utils/request';
import { setToken } from '@/webPublic/one_stop_public/utils/token';

const api: string = '/UserApi';
const api2: string = '/ConfigApi';
const api3: string = '/UserApi';

interface getPayload {
  email?: string;
}

interface fuc {
  (response: any, isNull?: boolean): void,
}

const myCollect = {
  namespace: 'emailorphone',
  state: {
    user: {}, // 用户数据
    deaImg: '', // 全局背景图
  },
  effects: {
    /**
     * 发送邮箱验证码
     * @params {email} 邮箱
     */
    * GetSysCodeEmail({
                        payload,
                        callback,
                      }: { payload: getPayload, callback: fuc },
                      {
                        call,
                        put,
                      }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/sendResetCode`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 发送绑定手机验证码
     * @param {phone} 手机号
     */
    * GetSysCodePhone({
                        payload,
                        callback,
                      }: { payload: getPayload, callback: fuc },
                      {
                        call,
                        put,
                      }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/sendResetCodePhone`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 获得验证码后重置邮箱
     * @params { verifyCode } 验证码
     * @params {email} 邮箱
     */
    * GetResteEmail({
                      payload,
                      callback,
                    }: { payload: getPayload, callback: fuc },
                    {
                      call,
                      put,
                    }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/changeEmail`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        if (callback) {
          callback(response, true);
        }
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 获得验证码后重置手机
     * @params {verifyCode } 验证码
     * @params {phone} 手机
     */
    * GetRestePhone({
                      payload,
                      callback,
                    }: { payload: getPayload, callback: fuc },
                    {
                      call,
                      put,
                    }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/changePhone`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        if (callback) {
          callback(response, true);
        }
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 游客注册接口
     * @params { username }  用户名
     * @params { password } 密码
     */
    * GetRegister({
                    payload,
                    callback,
                  }: { payload: getPayload, callback: fuc },
                  {
                    call,
                    put,
                  }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/register`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 手机重置密码
     * @params {verifyCode } 验证码
     * @params {phone} 手机
     */
    * GetPhonePassword({
                         payload,
                         callback,
                       }: { payload: getPayload, callback: fuc },
                       {
                         call,
                         put,
                       }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/changePhonePwd`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      setToken(response.token);
      if (callback) {
        callback(response);
      }
    },
    /**
     * logo相关配置接口
     * @parmas {configKey} 配置项
     */
    * GetLogo({
                payload,
                callback,
              }: {
                payload: getPayload,
                callback: fuc,
              },
              {
                call,
                put,
              }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api2}/getDetails`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 通过传入用户名直接拿取用户信息
     */
    * GetUserData({
                    payload,
                    callback,
                  }: { payload: getPayload, callback: fuc },
                  {
                    call,
                    put,
                  }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api3}/loginByCount`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 获取背景图并转存到modal中
     */
    * GetDeaImg({
                  payload,
                  callback,
                }: { payload: getPayload, callback: fuc },
                {
                  call,
                  put,
                }: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api2}/getDetails`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
      yield put({
        type: 'setImg',
        payload: response,
      });
    },
  },
  reducers: {
    setImg(state: any, action: any) {
      return {
        ...state,
        deaImg: action.payload,
      };
    },
    nom(state: any, action: any) {
      return { ...state };
    },
  },
};
export default myCollect;
