import { permRequest } from '../utils/request';

export default {
  namespace: 'uaa_User_OneStop',

  state: {
    data: {
      list: [],
      pagination: {},
    },
    data2: {
      list: [],
      pagination: {},
    },
  },

  effects: {
    *savePost({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/savePost', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *fetch2({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/newGetPage', payload);
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      yield put({
        type: 'list2',
        payload: response,
      });
    },
    *getMyApp({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/getMyApp', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *findUser({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/findUser', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *isOpen({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/isOpen', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }
      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *add({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/add', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback({ suc: true });
    },
    *changeAppIds({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/changeAppIds', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }
      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *getAppIds({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/getAppIds', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }
      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *changeUser({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/changeUser', payload);

      if (!response) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },

    *getMy({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/getMy', payload);

      if (!response) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *changePassword({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/changePassword', payload);

      if (!response) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    *fetch({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/getPage', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }
      yield put({
        type: 'list2',
        payload: response,
      });
      if (callback) callback(response);
    },
    *remove({ payload, callback }, { call, put }) {
      const response = yield call(permRequest, '/UserApi/remove', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }
      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
  },

  reducers: {
    list(state, { payload }) {
      return {
        ...state,
        data: {
          list: payload.rows,
          pagination: {
            current: payload.pageNo,
            pageSize: payload.pageSize,
            total: payload.total,
          },
        },
      };
    },
    list2(state, { payload }) {
      return {
        ...state,
        data2: {
          list: payload.rows,
          pagination: {
            current: payload.pageNo,
            pageSize: payload.pageSize,
            total: payload.total,
          },
        },
      };
    },
    nom(state) {
      return { ...state };
    },
  },
};
