import React from 'react';
import { Button } from 'antd';
import { getModal } from '@/webPublic/one_stop_public/utils/utils';
import styles from './style.less'
import { connect } from "dva";

const Modal = getModal();


// 解决新增和编辑冲突的bug http://scjoyedu.eicp.net:57400/zentao/bug-view-3504.html
@connect(({ DataColumn }) => ({
  DataColumn,
}))
export default class FormModal extends React.Component {
  constructor(props) {
    super(props);
  }

  showFullScreen = () => {
    let dom = document.getElementById('smartFormModal');
    dom.requestFullscreen();
    console.log(dom);
  }

	render() {
    const { DataColumn, modalCode,title = '' } = this.props;
    const { isShowModal } = DataColumn;
		return (
			<Modal
				bodyStyle={{
					maxHeight: '80vh',
					overflowY: 'auto',
				}}
				{...this.props}
				destroyOnClose
        visible={isShowModal[modalCode + title] || false}
				title={title}
				maskClosable={false}
				width={this.props.width}
				height={this.props.height}
				footer={null}
				onCancel={this.props.handleCancel}>
				{this.props.showFullScreen && (
					<Button type={'primary'} onClick={this.showFullScreen}>
						全屏查看
					</Button>
				)}
        <div id={'smartFormModal'} className={styles.fullScreen}>
          {this.props.children}
        </div>
			</Modal>
		);
	}
}
