import { Switch } from 'antd';
import React, { useEffect } from 'react';


export default function SwitchWeb(props) {
  const {
    checked: value,
    onChange,
    json,
    disabled,
  } = props;
  const changeSw = (v) => {
    onChange(v);
  };

  useEffect(() => {
    if (typeof value !== 'boolean') {
      if (value && value === 'true') {
        onChange(true);
      } else {
        onChange(false);
      }
    }
  }, [value]);
  return (
    <Switch
      disabled={disabled}
      onChange={changeSw}
      checked={value}
      checkedChildren={json.checkedChildren}
      unCheckedChildren={json.unCheckedChildren}
    />
  );
}
