/**
 * 2019年9月22日
 * 钟是志 2021年10月20日
 * 动态表格组件返回对应的组件
 */
import React, { Component, lazy, Suspense } from 'react';

import md5 from 'js-md5';
import FormModal from './FormModal';
import {
  Button,
  Cascader,
  Checkbox,
  Col,
  DatePicker,
  Form,
  Icon,
  Input,
  InputNumber,
  message,
  Radio,
  Row,
  Select,
  Switch,
  Table,
  Tabs,
  TimePicker
} from 'antd';
import UUID from 'react-native-uuid';
import QRCode from 'qrcode.react';
import { Editor } from 'draft-js';
import MyBlockRenderer from '../App/MyBlockRender';
// import CronEditor from 'antd-cron-editor'; // 2022年3月17日 按需加载这个组件 钟是志
import { Flex, List as MobileList, Switch as MobileSwitch, List } from 'antd-mobile';
import ReactEcharts from 'echarts-for-react';
import ZdyTable from '../Table/index';
import TreeSelectDiy from '../TreeSelect/index';
import { connect } from 'dva';
import UploadCom from '../libs/UploadCom';
import TableSelect from '../libs/TableSelect';
import TreeDiy from '../libs/TreeDiy';
import LocationCom from '../libs/LocationCom';
import MobileDate from '../libs/MobileDate';
import ChildForm from '../libs/ChildForm';
import Neo4jD3Com from '../libs/Neo4jD3Com';
import ImgUploadCom from '../libs/ImgUploadCom';
import VideoUploadCom from '../libs/VideoUploadCom';
import moment from 'moment';
import router from 'umi/router';
import TableList from '../libs/TableList';
import styles from './style.less';
import config from '@/webPublic/one_stop_public/config';
import { cloneDeep, isEmpty, isNaN } from 'lodash';
import { queryApiActionPath, queryFileUrl } from '../utils/queryConfig';
import Highlighter from 'react-highlight-words';
import Signature from '../Signature';
import { changeToDraftState, deepCopy, preHandle } from '../utils/myutils';
import { getToken } from '../utils/token';
import { formulaList } from '../excelInitFuc/functionList';
import FilePreview from '../filePreview';
import DraftEditorCom from '../App/DraftEditorCom';
import MobileItem from './MobileItem';
import MobileCascader from './CascaderDiy/MobileCascader';
import {
  equal,
  errorHandler,
  getBase64,
  getRender,
  isJSON,
  ShowComName,
} from './Split_Index/staticInfo';
import PictureSignature, {
  SignArray,
} from '@/webPublic/one_stop_public/libs/PictureSignature/PictureSignature';
import WangEditor from '@/webPublic/zyd_public/WangEditor/OnstopWang';
import MobileCard from './Split_Index/MobileCard/index';
import { noPrefixRequest, uaaRequest } from '@/webPublic/one_stop_public/utils/request';
import RangePickerDiy, {
  getMomentArr,
} from '@/webPublic/one_stop_public/tableCompon/Split_Index/RangePickerDiy';
import getActiveJson from '@/webPublic/one_stop_public/Table/getActiveJson';
import getOneStopUploadUrl from '@/webPublic/one_stop_public/Base16/getOneStopUploadUrl';
import SwitchWeb from '@/webPublic/one_stop_public/tableCompon/Split_Index/SwitchWeb';
import CronEditorDiy from '@/webPublic/one_stop_public/tableCompon/Split_Index/CronEditorDiy/index';
import ButtonDiy from '@/webPublic/one_stop_public/tableCompon/Split_Index/ButtonDiy';
import giveVarcharRules from '@/webPublic/one_stop_public/tableCompon/Split_Index/giveVarcharLength';
import getPopupContainer from '@/webPublic/one_stop_public/tableCompon/Split_Index/getPopupContainer';
import StepDiy from '@/webPublic/one_stop_public/tableCompon/Split_Index/StepDiy';
import EchartsDiy from '@/webPublic/one_stop_public/tableCompon/Split_Index/EchartsDiy';
import { getServicesNomal } from '../Services/services';
import {
  getHeaderListApi,
  getSqlDataApi,
  findApi,
  getSqlOptionsApi,
  getSqlLabelsApi,
  getLabelsApi,
  getOptionsApi,
} from '../Services/apiConfig';
import UploadComReadOnly from '@/webPublic/one_stop_public/libs/Split/UploadComReadOnly';
/**
 * 日期组件antd3.x有bug 详情见禅道 27152 毕业跟踪调查管理 毕业时间改为年级筛选
 */
const { TextArea } = Input;
const { Option } = Select;

const giveRender = (column = {}) => {
  if (!column?.render) {
    // 超过30个字的字段 自动隐藏
    column.render = (text, record) => {
      if (text && typeof text === 'string' && text.length > 30) {
        return <span title={text}>{text.slice(0, 30)}</span>;
      }
      return text;
    };
  }
  return column;
};

@connect(({ DataColumn, SqlManageEntity, formList, loading }) => ({
  DataColumn,
  SqlManageEntity,
  formList,
  loading: loading.models.DataColumn || loading.models.SqlManageEntity || loading.models.formList,
}))
export default class TableCom extends Component {
  constructor(props) {
    super(props);
    this.state = {
      options: this.props.options || [],
      labels: [],
      url: null,
      selectDis: true, // 让下拉框在获取到数据前失效,防止网络卡顿用户点击时造成页面白屏
      isDate: true, // 避免重复调用
      sqlKeys: {},
      searchText: '',
      reqUrls: {},
      res: null,
      option: {},
      sqlModel: {},
      columns: [],
      sqlContent: null,
      modalProps: {},
      modalTitle: '',
      modalInit: {},
      modalCode: null,
      getSqlOptionsCache: '', // fetchData3 函数参数做缓存 防止重复请求接口 禅道28017
      dataSource: {
        list: [],
        pagination: false,
      },
      sqlKey:'',
      allValues:{},
    };
    this.excludeKeys = ['defaultValues', ''];
    this.otherProps = {};
    if (props.json?.otherProps) {
      try {
        this.otherProps = new Function(props.json?.otherProps)();
      } catch (e) {

      }
    }
    this.serviceJSONParams = {};
  }

  closeModal = (fk, callback) => {
    const { dispatch } = this.props;
    const x = this.props.DataColumn.isShowModal;
    for(let k in x){
      if(k.includes(fk)){
        x[k] = false;
      }
    }
    dispatch({
      type: 'DataColumn/showModal',
      payload: { isShowModal: x },
      callback: callback,
    });
  };

  changeTabsActiveKey = activeKey => {
    this.setState({
      activeKey,
    });
  };

  showModal = (fk, title, data, modalProps) => {

    const { dispatch } = this.props;
    const x = this.props.DataColumn.isShowModal;
    x[fk + title] = true;
    this.setState(
      {
        modalInit: data,
      },
      () => {
        // let a = setTimeout(() => {
          // 解决禅道 31435 勤工助学（新）/工作情况考核，20219001028 批次设置的时间没有受控制 看下
          dispatch({
            type: 'DataColumn/showModal',
            payload: { isShowModal: x },
            callback: () => {
              this.setState({
                modalTitle: title,
                modalCode: fk,
                modalProps: modalProps,
              });
            },
          });
          // clearTimeout(a);
        // }, 300);

      },
    );
  };

  /**
   * 上传文件输入
   * 使用antd上传组件
   */
  file = {
    name: 'file',
    action: getOneStopUploadUrl(),
    onChange: info => {
      if (info.file.status !== 'uploading') {
        this.setState({
          img: info.file.response,
        });
      }
      if (info.file.status === 'done') {
        message.success(`图像添加成功，如需保存请点击保存`);
      } else if (info.file.status === 'error') {
        message.error(`图像添加失败.`);
      }
    },
  };
  obj = {};
  childObj = {};
  count = [];
  handleSearch = (selectedKeys, confirm) => {
    confirm();
    this.setState({ searchText: selectedKeys[0] });
  };

  handleReset = clearFilters => {
    clearFilters();
    this.resetSearchText();
  };

  resetSearchText = () => {
    this.setState({
      searchText: '',
    });
  };

  getColumnSearchProps = (dataIndex, title) => ({
    filterDropdown: ({ setSelectedKeys, selectedKeys, confirm, clearFilters }) => (
      <div style={{ padding: 8 }}>
        <Input
          ref={node => {
            this.searchInput = node;
          }}
          placeholder={`请输入${title}`}
          value={selectedKeys[0]}
          onChange={e => setSelectedKeys(e.target.value ? [e.target.value] : [])}
          onPressEnter={() => this.handleSearch(selectedKeys, confirm)}
          style={{
            width: 188,
            marginBottom: 8,
            display: 'block',
          }}
        />
        <Button
          type="primary"
          onClick={() => this.handleSearch(selectedKeys, confirm)}
          icon="search"
          loading={this.props.loading}
          size="small"
          style={{
            width: 90,
            marginRight: 8,
          }}
        >
          搜索
        </Button>
        <Button
          loading={this.props.loading}
          onClick={() => this.handleReset(clearFilters)}
          size="small"
          style={{ width: 90 }}
        >
          重置
        </Button>
      </div>
    ),
    filterIcon: filtered => <Icon type="search" style={{ color: filtered ? '#1890ff' : 'red' }} />,
    onFilter: (value, record) =>
      record[dataIndex]
        ? record[dataIndex]
          .toString()
          .toLowerCase()
          .includes(value.toLowerCase())
        : '',
    onFilterDropdownVisibleChange: visible => {
      if (visible) {
        setTimeout(() => this.searchInput.select());
      }
    },
    render: text => {
      if (text != null) {
        return (
          <Highlighter
            highlightStyle={{
              backgroundColor: '#ffc069',
              padding: 0,
            }}
            searchWords={[this.state.searchText]}
            autoEscape
            textToHighlight={text.toString()}
          />
        );
      } else {
        return '';
      }
    },
  });
  searchJson = (value, json, level, labs) => {
    if (!json || !Array.isArray(json) || !json.length || !value) {
      // console.log('下拉级联组件数据错误 没得值', value);
      return;
    }
    for (var i = 0; i < json.length; i++) {
      if (!!value && json[i].value == value[level]) {
        labs.push(json[i].label);
        if (json[i].children) {
          this.searchJson(value, json[i].children, level + 1, labs);
        }
        break;
      }
    }
  };

  componentWillReceiveProps(props) {
    const { json, mapData, obj } = props;
    if((json && json.comName === 'Select') && json.isFormulaOnce){ // 解决下拉枚举接口一直调的bug
      return;
    }
    if (json == null || this.props.safe) {
      return;
    }
    if (
      !(this.dataFilter.includes(json.comName) || json.comName === 'TableSelect') &&
      json.isFormulaOnce
    ) {
      return;
    }
    if (
      !(
        this.dataFilter.includes(json.comName) ||
        json.comName === 'TableSelect' ||
        !!json.formula
      )
    ) {
      return;
    }
    const obj2 = props.form.getFieldsValue();
    const bb = equal(this.obj, obj2, json, this.state.sqlContent, 1, this.props, this.excludeKeys);
    let bb2 = true;
    let childObj2 = {};
    if (props.fatherCode) {
      if (obj2 != null && obj2[props.fatherCode]) {
        childObj2 = obj2[props.fatherCode][props.index];

        bb2 = equal(
          this.childObj,
          childObj2,
          json,
          this.state.sqlContent,
          1,
          this.props,
          this.excludeKeys,
        );
      }
    }

    if (!(bb && bb2)) {
      const now = new Date().valueOf();

      let j = 0;
      for (var i = 0; i < this.count.length; i++) {
        if (now - this.count[i] < 1000) {
          break;
        } else {
          j = i;
        }
      }

      if (j > 0) {
        this.count.splice(0, j);
      }
      if (this.count.length > 10) {
        console.log(
          `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this.props
            .i + 1}行,第${this.props.j +
            1}列:存在循环风险，1秒内执行超过10次，现已停止执行，请检查,`,
        );

        return;
      }
      if (!bb) {
        this.obj = cloneDeep(obj2);
      }
      if (!bb2) {
        this.childObj = cloneDeep(childObj2);
      }
      this.count.push(now);
    } else {
      return;
    }

    const bindObj = this.getColumn('c1');

    let dataColumn =
      this.props.fatherCode != null
        ? bindObj
          ? {
            ...bindObj,
            base52: `${this.props.fatherCode}.[${this.props.index}].${bindObj.base52}`,
          }
          : { base52: `${this.props.fatherCode}.[${this.props.index}].${this.props.uuid}` }
        : bindObj;
    if (this.props.fatherCode == null && dataColumn == null) {
      dataColumn = { base52: this.props.uuid };
    }

    if (!this.props.isEdit && this.props.fatherCode) {
      if (bindObj != null) {
        dataColumn.base52 = bindObj.base52;
      } else {
        dataColumn.base52 = this.props.uuid;
      }
    }
    // if(this.props.uuid === 'id_44cd90f124abc2427428ee2285222628953f'){
    //   console.log('我去调接口查枚举了');
    //
    // }
    if (this.dataFilter.includes(json.comName) || json.comName === 'TableSelect') {
      const obj2 = {
        ...obj,
        ...props.defaultValues[this.props.formKey],
        ...props.form.getFieldsValue(),
      };
      this.getData(json, dataColumn, obj2);
    }
    if (!!json.formula && !json.isFormulaOnce) {
      this.getFunctionValue(json.formula, dataColumn, json);
    }
  }

  dataFilter = ['Select', 'Radio', 'Checkbox', 'Cascader', 'TreeSelect'];

  queryModal = () => {
    const {sqlKey,allValues} =this.state
    const {json} =this.props
    const isOpenPage = json?.isOpenPage
    const params = {
      sqlKey,
      allValues,
      isCache: this.otherProps?.isCache || false,
    }
            // 分页走PageTable
            if(isOpenPage) {
              return
            }
                getServicesNomal(getSqlDataApi, params).then(list => {
                  const x = {
                    list: list,
                    pagination: false,
                  }
              this.setState({ dataSource: x });
            });
  }

  getData = (json, dataColumn, obj, init) => {
    const { formKey, uuid } = this.props;
    let jsonStatic = json;
    json = {
      ...jsonStatic,
      ...getActiveJson(formKey, uuid),
    };
    let allValues = deepCopy(obj);
    preHandle(allValues);
    allValues = JSON.stringify(allValues);
    if (json.comName === 'TableSelect') {
      const { sqlKey, optionType } = json;
      if (optionType === 'sql') {
        getServicesNomal(findApi, { sqlKey }).then(sqlModel => {
          this.setState({ sqlModel });
          if (sqlModel.dataObjId) {
            getServicesNomal(getHeaderListApi, { dataObjId: sqlModel.dataObjId }).then(datas => {
              if (datas) {
                const columns = [];
                for (var i = 0; i < datas.length; i++) {
                  if (i <= json.colNum ? json.colNum : 10) {
                    let column = {};
                    column.title = datas[i].title;
                    column.dataIndex = datas[i].name;
                    if (
                      ['DATE', 'DATETIME', 'TIME', 'TIMESTAMP', 'YEAR'].includes(datas[i].type)
                    ) {
                      column.render = val => moment(val).format('YYYY-MM-DD HH:mm:ss');
                    }

                    column = giveRender(column);

                    columns.push(column);
                  } else {
                    break;
                  }
                }
                this.setState({ columns });
              }
            });
          } else {
            const cols = sqlModel.cols;
            if (cols != null || cols.length > 0) {
              const columns = [];
              const cll = JSON.parse(cols);
              for (var k in cll) {
                let column = {};
                column.title = cll[k].title;
                column.dataIndex = cll[k].name;
                if (['DATE', 'DATETIME', 'TIME', 'TIMESTAMP', 'YEAR'].includes(cll[k].type)) {
                  var ff = 'YYYY-MM-DD HH:mm:ss';
                  switch (cll[k].type) {
                    case 'DATE':
                      ff = 'YYYY-MM-DD';
                      break;
                    case 'YEAR':
                      ff = 'YYYY';
                      break;
                    case 'TIME':
                      ff = 'HH:mm:ss';
                      break;
                  }

                  column.render = val => moment(parseInt(val)).format(ff);
                }
                // console.log("🚀 ~ file:index method: line:546 -----", this.props, "this.props");
                if (cll[k].isQuery && this.props.isEdit) { // 2024年8月14日 10:32:32 姚鑫国钉钉说的 非编辑模式不需要加查询条件
                  column = {
                    ...this.getColumnSearchProps(cll[k].name, cll[k].title),
                    ...column,
                    isQuery: cll[k].isQuery,
                  };
                }

                column = giveRender(column);

                columns.push(column);
              }
              this.setState({ columns });
            }
            this.setState({
              sqlKey,
              allValues,
            })
            this.queryModal()
          }
        });
      } else if (optionType == 'reference' && dataColumn.referenceObjId) {
        getServicesNomal(getHeaderListApi, { dataObjId: dataColumn.referenceObjId }).then(datas => {
          if (datas) {
            const columns = [];
            for (var i = 0; i < datas.length; i++) {
              if (i <= json.colNum ? json.colNum : 10) {
                let column = {};
                column.title = datas[i].title;
                column.dataIndex = datas[i].name;
                if (['DATE', 'DATETIME', 'TIME', 'TIMESTAMP', 'YEAR'].includes(datas[i].type)) {
                  column.render = val => moment(val).format('YYYY-MM-DD HH:mm:ss');
                }
                column = giveRender(column);
                columns.push(column);
              } else {
                break;
              }
            }
            this.setState({ columns });
          }
        });
      }
    }

    if (json.optionType != null && this.dataFilter.includes(json.comName)) {
      // 获取 下拉枚举值
      switch (json.optionType) {
        case 'reference':
          if (dataColumn.referenceObjId != null) {
            this.fetchData(obj, dataColumn, init, json.filterSql, allValues);
          }
          break;
        case 'enum':
          if (json.enums != null && json.enums != '') {
            var enu;
            try {
              enu = JSON.parse(json.enums);
            } catch (e) {
              message.error('枚举json格式存在问题');
              enu = [];
            }

            this.changeEnum(obj, dataColumn, enu);
          }
          break;
        case 'sql':
          if (json.sqlKey != null && !!json.sqlKey) {
            this.fetchData3(obj, dataColumn, init, json, allValues);
          }
          break;
        case 'func':
          if (json.funcs != null && json.funcs != '') {
            if (json.comName == 'Cascader') {
              try {
                this.getFunctionValue(json.funcs, { base52: this.props.uuid }, json, () => {
                  if (init != null && Object.keys(init).length > 0) {
                    let base52 = dataColumn.base52;
                    let vlu = this.props.form.getFieldsValue()[base52];
                    const labs = [];
                    this.searchJson(vlu, this.state.options, 0, labs);

                    this.setState({ labels: labs });
                  } else if (!this.props.isEdit && Object.keys(obj).length > 0) {
                    let base52 = dataColumn.base52;

                    const vlu = obj[base52];

                    const labs = [];
                    this.searchJson(vlu, this.state.options, 0, labs);
                    this.setState({ labels: labs });
                  }
                });
              } catch (e) {
                message.error('公式选项配置存在问题');
              }
            } else {
              try {
                this.getFunctionValue(json.funcs, { base52: this.props.uuid }, json, () => {
                  if (init != null && Object.keys(init).length > 0) {
                    let base52 = dataColumn.base52;
                    let vlu = this.props.form.getFieldsValue()[base52];
                    const labs = [];
                    if (vlu instanceof Array) {
                      for (var i = 0; i < this.state.options.length; i++) {
                        if (vlu.includes(this.state.options[i].value)) {
                          labs.push(this.state.options[i].label);
                        }
                      }
                    } else {
                      for (var i = 0; i < this.state.options.length; i++) {
                        if (vlu == this.state.options[i].value) {
                          labs.push(this.state.options[i].label);
                          break;
                        }
                      }
                    }

                    this.setState({ labels: labs });
                  } else if (!this.props.isEdit && Object.keys(obj).length > 0) {
                    let base52 = dataColumn.base52;

                    const vlu = obj[base52];

                    const labs = [];
                    if (vlu instanceof Array) {
                      for (var i = 0; i < this.state.options.length; i++) {
                        if (vlu.includes(this.state.options[i].value)) {
                          labs.push(this.state.options[i].label);
                        }
                      }
                    } else {
                      for (var i = 0; i < this.state.options.length; i++) {
                        if (vlu == this.state.options[i].value) {
                          labs.push(this.state.options[i].label);
                          break;
                        }
                      }
                    }

                    this.setState({ labels: labs });
                  }
                });
              } catch (e) {
                message.error('公式选项配置存在问题');
              }
            }
          }
          break;
      }
    }
  };

  setValues = (base52, json, values) => {
    try {
      this.props.form.setFieldsValue(values);
    } catch (e) {
      console.log(
        `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this.props.i +
        1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
        e,
      );
    }
    if (!this.props.isEdit) {
      if (this.props.setRealTimeValues) {
        this.props.setRealTimeValues(values);
      }
    }
  };
  reqUtil = (base52, json, orgCallback, url, method, params, callback, options = {}) => {
    //查缓存
    var isChange = true;
    if (url.indexOf('http') === -1) {
      url = config.httpServer + url;
    }
    const { reqUrls } = this.state;
    if (reqUrls[url] != null) {
      const ps = reqUrls[url].params;

      if (Object.keys(params).length != Object.keys(ps).length) {
        isChange = true;
      } else {
        for (var key in params) {
          if (params[key] == null && ps[key] != null) {
            isChange = true;
            break;
          } else if (params[key] != null && ps[key] == null) {
            isChange = true;
            break;
          } else {
            if (params[key] != ps[key]) {
              isChange = true;
              break;
            }
          }
        }
      }
    } else {
      reqUrls[url] = { params: params };
      isChange = true;
    }

    if (!isChange) {
      if (callback) {
        const data = reqUrls[url].data;

        if (json.optionType && json.optionType === 'func') {
          const res = callback(data);

          if (res != null && !(typeof res === 'function')) {
            this.setState(
              {
                options: res,
                selectDis: false,
              },
              () => {
                if (orgCallback) orgCallback();
              },
            );
          }
        } else if (json.comName === 'Button') {
          try {
            callback(data);
          } catch (e) {
            console.log(
              `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
              e,
            );
            //message.error(`页面${this.props.formKey}第${this.props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误${e}`, 10)
          }
        } else if (['Echart', 'QRCode', 'Graph', 'Tabs', 'Tree'].includes(json.comName)) {
          try {
            const x = callback(data);
            if (x != null) {
              this.setState({ option: x });
            }
          } catch (e) {
            console.log(
              `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
              e,
            );
          }
        } else {
          if (base52) {
            try {
              const x = callback(data);

              if (x == null || x != 'NaN') this.props.form.setFieldsValue({ [base52]: x });
            } catch (e) {
              console.log(
                `页面${this.props.formKey} ${json.comName}第${this.props.i + 1}行,第${this.props.j +
                1}列:公式配置有误,回调函数内部错误,`,
                e,
              );
            }
          }
        }
      }
      return 'norefeshxxxxxxxxxxxxxxxxxxxx';
    }

    for (let i in params) {
      if (params[i] == null) {
        delete params[i];
      }
    }
    noPrefixRequest(url, params).then(data => {
      // if (!data || !Array.isArray(data)) {
      // 	data = [];
      // }
      const { reqUrls } = this.state;
      if (reqUrls && reqUrls[url]) {
        reqUrls[url].data = data;
      }
      this.setState(
        {
          res: data,
          reqUrls,
        },
        () => {
          if (callback) {
            if (json.optionType && json.optionType == 'func') {
              const res = callback(data);
              if (res != null && !(typeof res === 'function')) {
                this.setState(
                  {
                    options: res,
                    selectDis: false,
                  },
                  () => {
                    if (orgCallback) orgCallback();
                  },
                );
              }
            } else if (json.comName == 'Button') {
              try {
                callback(data);
              } catch (e) {
                console.log(
                  `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                    .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
                  e,
                );
              }
            } else if (['Echart', 'QRCode', 'Graph', 'Tabs', 'Tree'].includes(json.comName)) {
              try {
                const x = callback(data);
                if (x != null) {
                  this.setState({ option: x });
                }
              } catch (e) {
                console.log(
                  `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                    .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
                  e,
                );
              }
            } else {
              if (base52) {
                try {
                  const x = callback(data);

                  if (x == null || x != 'NaN') this.props.form.setFieldsValue({ [base52]: x });
                } catch (e) {
                  console.log(
                    `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName
                    }第${this.props.i + 1}行,第${this.props.j +
                    1}列:公式配置有误,回调函数内部错误,`,
                    e,
                  );
                }
              }
            }
          }
        },
      );
    });

    return 'norefeshxxxxxxxxxxxxxxxxxxxx';
  };
  sqlUtil = (base52, json, orgCallback, sqlKey, params, p1, p2, p3) => {
    let callback = p1;
    let options = typeof p2 === 'undefined' ? {} : p2;
    let otherParams = {};
    if (p1 && typeof p1 === 'object') {
      callback = p2;
      otherParams = p1;
      options = p3 || {};
    }
    // console.log(otherParams);
    //查缓存

    var isChange = false;
    const { sqlKeys } = this.state;
    if (sqlKeys[sqlKey] != null) {
      const ps = sqlKeys[sqlKey].params;

      if (params.length != ps.length) { // 数组参数个数变化时 调用接口
        isChange = true;
      } else {
        for (var i = 0; i < params.length; i++) {
          if (params[i] != ps[i]) { // 数组参数某一个变化时 调用接口
            isChange = true;
            break;
          }
        }
      }
      if (!isChange) {
        const os = sqlKeys[sqlKey].options;
        if (JSON.stringify(options) !== JSON.stringify(os)) { // options 参数改变时调用接口
          sqlKeys[sqlKey].options = options;
          isChange = true;
        }else if(otherParams && JSON.stringify(sqlKeys[sqlKey].otherParams) !== JSON.stringify(otherParams)){
          // 2024年8月27日 17:22:11
          // 姚鑫国说的 jsParams参数变了没调接口
          isChange = true;
        } else {
          for (var k in options) {
            if (os[k] == null || options[k] != os[k]) {
              isChange = true;
              break;
            }
          }
        }
      }
    } else {
      sqlKeys[sqlKey] = {
        params: params,
        options: options,
        otherParams: otherParams,
      };
      isChange = true;
    }
    if (!isChange && typeof sqlKeys[sqlKey].data !== 'undefined') {
      // typeof sqlKeys[sqlKey].data !== 'undefined' 解决此函数多次调用第一次还没返回结果又调用第二次导致data为undefined的问题 3665 【1.0组件优化】列表组件优化

      // 姚鑫国说的 jsParams参数变了没调接口
      if (callback) {
        const data = sqlKeys[sqlKey].data;
        if (json.optionType && json.optionType === 'func') {
          const res = callback(data);
          if (res != null && !(typeof res === 'function')) {
            this.setState(
              {
                options: res,
                selectDis: false,
              },
              () => {
                if (orgCallback) orgCallback();
              },
            );
          }
        } else if (json.comName === 'Button') {
          try {
            callback(data);
          } catch (e) {
            console.log(
              `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
              e,
            );
          }
        } else if (['Echart', 'QRCode', 'Graph', 'Tabs', 'Tree'].includes(json.comName)) {
          try {
            const x = callback(data);
            if (x != null) {
              this.setState({ option: x });
            }
          } catch (e) {
            console.log(
              `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
              e,
            );
          }
        } else {
          if (base52) {
            try {
              const x = callback(data);

              if (x == null || x != 'NaN') this.props.form.setFieldsValue({ [base52]: x });
            } catch (e) {
              console.log(
                `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                  .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
                e,
              );
            }
          }
        }
      }
      return 'norefeshxxxxxxxxxxxxxxxxxxxx';
    }

    const url = '/DataColumnApi/getSqlData';
    this.setState({ sqlKeys }, () => {
      const allValues = JSON.stringify({
        ...this.props.obj,
        ...this.props.form.getFieldsValue(),
        ...this.props.defaultValues[this.props.formKey],
        ...options,
      });

      let pp = {
        sqlKey,
        params,
        allValues,
        ...otherParams,
      };
      if (getToken() != null) {
        pp.token = getToken();
      }
      uaaRequest(url, pp).then(data => {
        const { sqlKeys } = this.state;
        sqlKeys[sqlKey].data = data;
        this.setState({ sqlKeys });
        if (data == null) {
          return;
        }

        if (callback) {
          if (json.optionType && json.optionType === 'func') {
            const res = callback(data);

            if (res != null && !(typeof res === 'function')) {
              this.setState(
                {
                  options: res,
                  selectDis: false,
                },
                () => {
                  if (orgCallback) orgCallback();
                },
              );
            }
          } else if (['Button', 'MobileCard'].includes(json.comName)) {
            try {
              callback(data);
            } catch (e) {
              console.log(
                `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                  .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
                e,
              );
            }
          } else if (['Echart', 'QRCode', 'Graph', 'Tabs', 'Tree'].includes(json.comName)) {
            try {
              const x = callback(data);
              if (x != null) {
                this.setState({ option: x });
              }
            } catch (e) {
              console.log(
                `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                  .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
                e,
              );
            }
          } else {
            if (base52) {
              try {
                const x = callback(data);
                // console.log(x, 938);
                if (x == null || x != 'NaN') this.props.form.setFieldsValue({ [base52]: x });
              } catch (e) {
                console.log(
                  `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                    .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,回调函数内部错误,`,
                  e,
                );
              }
            }
          }
        }
      });
    });

    return 'norefeshxxxxxxxxxxxxxxxxxxxx';
  };

  getObjValues = () => {
    const { isEdit, fatherObj, defaultValues, formKey, form, fatherCode } = this.props;
    let obj = {};
    if (!isEdit && fatherCode) {
      obj = {
        ...fatherObj,
        ...defaultValues[formKey],
        ...form.getFieldsValue(),
      };
    } else {
      obj = {
        ...(fatherObj ? fatherObj : {}),
        ...this.props.obj,
        ...defaultValues[formKey],
        ...form.getFieldsValue(),
      };
    }
    return obj;
  };

  functionArguments = (column, callback) => {
    const base52 = column.base52;
    const {
      json: jsonStatic,
      isEdit,
      fatherCode,
      form,
      defaultValues,
      formKey,
      fatherObj,
      init,
      modalInit,
      get,
      formCode,
      taskAssignee,
      formId,
      userId,
      taskId,
      index,
      uuid,
      importExcel,
      routerState,
      messageData,
      concealModel,
    } = this.props;
    let json = jsonStatic;
    if (json) {
      json = {
        ...jsonStatic,
        ...getActiveJson(formKey, uuid),
      };
    }

    let obj = this.getObjValues();

    /**
     * 中台函数库注入
     * 动态生成表单配置函数所使用
     */
    let functionObj = {};
    formulaList.map(item => {
      item.children.map(arr => {
        functionObj[arr.callKey] = arr.function;
      });
    });
    /**
     * 中台函数库注入
     * 动态生成表单配置函数所使用
     */

    return {
      obj: obj,
      init: init,
      modalInit: modalInit,
      defaultValues: defaultValues,
      env: {
        clientType: get,
        formCode: formCode,
        formId: formId,
        isEdit: isEdit,
        taskAssignee: taskAssignee,
        userId: userId,
        taskId: taskId,
      },
      index,
      fatherCode: fatherCode,
      utils: {
        moment,
        sql: this.sqlUtil.bind(this, base52, json, callback), // utils.sql xxx
        message,
        importExcel: importExcel,
        router: router,
        uuid: UUID,
        setValues: this.setValues.bind(this, base52, json),
        req: this.reqUtil.bind(this, base52, json, callback),
        md5,
        showModal: this.showModal,
        closeModal: this.closeModal,
        render: getRender,
        base64: getBase64,
        form: form,
        preHandle,
      },
      functionObj,
      routerState,
      messageData,
      concealModel,
    };
  };

  getFunctionValue = (fun, column, json, callback) => {
    if (this.props.safe) return;
    const base52 = column.base52;

    try {
      var fun1 = new Function(
        'obj',
        'init',
        'modalInit',
        'defaultValues',
        'env',
        'index',
        'fatherCode',
        'utils',
        '$',
        'routerState',
        'shareData',
        'sceneRouter',
        fun,
      );
      const {
        obj,
        init,
        modalInit,
        defaultValues,
        env,
        index,
        fatherCode,
        utils,
        routerState,
        concealModel,
        messageData,
        functionObj,
      } = this.functionArguments(column, callback);
      // console.log(obj.id_4f1c72d949e7, 'getFunctionValue');
      const value = fun1(
        obj,
        init,
        modalInit,
        defaultValues,
        env,
        index,
        fatherCode,
        utils,
        functionObj,
        routerState,
        messageData,
        concealModel,
      );
      if (base52) {
        if (value != null && value == 'norefeshxxxxxxxxxxxxxxxxxxxx') {
        } else {
          /**
           * 会出现重复调用2次,然后NAN造成无限循环
           */
          if (isNaN(value)) {
            return;
          }
          if (json.comName == 'Button') {
            return value;
          } else if (json.optionType && json.optionType == 'func') {
            if (value != null && !(typeof value === 'function')) {
              this.setState(
                {
                  options: value,
                  selectDis: false,
                },
                () => {
                  if (callback) callback();
                },
              );
            }
          } else if (['Echart', 'QRCode', 'Graph', 'Tabs', 'Tree'].includes(json.comName)) {
            this.setState({ option: value });
          } else {
            try {
              this.props.form.setFieldsValue({ [base52]: value });
            } catch {
              console.log(
                `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this
                  .props.i + 1}行,第${this.props.j + 1}列:公式配置有误,函数内部错误,`,
                e,
              );
            }
          }
        }
      }
    } catch (e) {
      console.log(
        `页面${this.props.currentFormTitle} ${this.props.formKey} ${json.comName}第${this.props.i +
        1}行,第${this.props.j + 1}列:公式配置有误,暂存失败,`,
        e,
      );
    }
  };

  componentDidMount() {
    const { json, mapData, obj, init } = this.props;
    if (json == null) {
      return;
    }
    if (json.sqlKey != null && json.sqlKey !== '') {
      getServicesNomal(findApi, { sqlKey: json.sqlKey }).then(res => {
        this.setState({ sqlContent: res.sql });
      })
    }

    const bindObj = this.getColumn('c1');

    let dataColumn =
      this.props.fatherCode != null
        ? bindObj
          ? {
            ...bindObj,
            base52: `${this.props.fatherCode}.[${this.props.index}].${bindObj.base52}`,
          }
          : { base52: `${this.props.fatherCode}.[${this.props.index}].${this.props.uuid}` }
        : bindObj;
    if (this.props.fatherCode == null && dataColumn == null) {
      dataColumn = { base52: this.props.uuid };
    }

    if (!this.props.isEdit && this.props.fatherCode) {
      if (bindObj != null) {
        dataColumn.base52 = bindObj.base52;
      } else {
        dataColumn.base52 = this.props.uuid;
      }
    }

    const obj2 = {
      ...obj,
      ...this.props.form.getFieldsValue(),
      ...this.props.defaultValues[this.props.formKey],
    };
    // console.log(obj.id_4f1c72d949e7, 'tableCom-1295',);

    this.getData(json, dataColumn, obj2);
    if (json.formula != null && json.formula != '' && !this.props.safe) {
      this.getFunctionValue(json.formula, dataColumn, json);
    }
  }

  fetchData3 = (obj, dataColumn, init, json, allValues) => {
    const { sqlKey, labelName, valueName, isMeta, filterSql } = json;

    // debugger;
    if (isMeta) {
      // 2022年7月5日 2022 姚鑫国说的 如果是元数据 不需要传这个allValues
      // 解决禅道bug 28017
      allValues = {};
    }
    if (init != null && Object.keys(init).length > 0) {
      const params = {
        sqlKey,
        allValues,
        isMeta,
        filterSql: isMeta ? filterSql || '' : undefined,
      };
      let getSqlOptionsCache = JSON.stringify(params);
      if (isMeta && getSqlOptionsCache === this.state.getSqlOptionsCache) {
        // 当上次的请求参数和这次的相同时 不再发起请求
        return false;
      }
      if(this.serviceJSONParams !== JSON.stringify(params)){
        this.serviceJSONParams = JSON.stringify(params);
      }else{
        return false;
      }
      getServicesNomal(getSqlOptionsApi, params).then(options => {
        const optionsx = [];
        let base52 = dataColumn.base52;
        let vl = this.props.form.getFieldsValue()[base52];
        let isExist = false;
        for (var i = 0; i < options.length; i++) {
          if (vl == options[i][valueName] && !isExist) {
            isExist = true;
          }
          optionsx.push({
            label: options[i][labelName],
            value: options[i][valueName],
          });
        }

        if (!isExist && vl != null && options.length > 0) {
          // console.log(base52, 1144);
          this.props.form.setFieldsValue({ [base52]: null });
        }
        this.setState({
          getSqlOptionsCache,
          options: optionsx,
          selectDis: false,
        });
      });
    } else if (!this.props.isEdit && Object.keys(obj).length > 0) {
      let base52 = dataColumn.base52;
      if (this.props.fatherCode) {
        const x = base52.split('.');
        base52 = x[x.length - 1];
      }

      const params = {
        sqlKey,
        values: obj[base52],
        labelName,
        valueName,
        allValues,
        isMeta,
      };

      let getSqlOptionsCache = JSON.stringify(params);
      if (isMeta && getSqlOptionsCache === this.state.getSqlOptionsCache) {
        // 当上次的请求参数和这次的相同时 不再发起请求
        return false;
      }
      if(this.serviceJSONParams !== JSON.stringify(params)){
        this.serviceJSONParams = JSON.stringify(params);
      }else{
        return false;
      }
      if (obj[base52]) {
        getServicesNomal(getSqlLabelsApi, params).then(labels => {
          this.setState({
            getSqlOptionsCache,
            labels,
            selectDis: false,
          });
        })
      }
    } else {
      const params = {
        sqlKey,
        allValues,
        isMeta,
        filterSql: isMeta ? filterSql || '' : undefined,
      };
      // console.log('1332', this.state.getSqlOptionsCache, JSON.stringify(params));
      let getSqlOptionsCache = JSON.stringify(params);
      if (isMeta && getSqlOptionsCache === this.state.getSqlOptionsCache) {
        // 当上次的请求参数和这次的相同时 不再发起请求
        return false;
      }

      if(this.serviceJSONParams !== JSON.stringify(params)){
        this.serviceJSONParams = JSON.stringify(params);
      }else{
        return false;
      }
      getServicesNomal(getSqlOptionsApi, params).then(options => {
        let base52 = dataColumn.base52;
        let vl = this.props.form.getFieldsValue()[base52];
        const optionsx = [];
        let isExist = false;
        for (var i = 0; i < options.length; i++) {
          if (vl == options[i][valueName] && !isExist) {
            isExist = true;
          }
          if (Array.isArray(vl) && vl.length && vl.includes(options[i][valueName]) && !isExist) {
            // 钟是志 2021年9月28日 16:19:46 解决 checkbox 多选负值不上的bug
            isExist = true;
          }
          optionsx.push({
            label: options[i][labelName],
            value: options[i][valueName],
          });
        }

        if (!isExist && vl != null && options.length > 0) {
          this.props.form.setFieldsValue({ [base52]: null });
        }

        this.setState({
          getSqlOptionsCache,
          options: optionsx,
          selectDis: false,
        });
      })
    }
  };
  changeEnum = (obj, dataColumn, options) => {
    if (!this.props.isEdit && Object.keys(obj).length > 0) {
      let values = obj[dataColumn.base52];
      if (typeof values === 'string' && isJSON(values)) {
        values = JSON.parse(values);
      }
      // console.log('select组件的labels对应的', values);
      const labels = [];
      if (values != null) {
        if (values instanceof Array) {
          for (var i = 0; i < options.length; i++) {
            if (values.includes(options[i].value)) {
              labels.push(options[i].label);
              // break;
            }
          }
        } else {
          for (var i = 0; i < options.length; i++) {
            if (values == options[i].value) {
              labels.push(options[i].label);
              // break;
            }
          }
        }
      }

      this.setState({
        labels: labels,
        selectDis: false,
      });
    } else {
      this.setState({
        options: options,
        selectDis: false,
      });
    }
  };
  fetchData = (obj, dataColumn, init, filterSql, allValues) => {

    if (init != null && Object.keys(init).length > 0) {
      getServicesNomal(getSqlOptionsApi, {
        id: dataColumn.id,
        filterSql,
        allValues,
      }).then(options => {
        const optionsx = [];
        for (var i = 0; i < options.length; i++) {
          optionsx.push({
            label: options[i][dataColumn.referenceNameName],
            value: options[i][dataColumn.referenceCodeName],
          });
        }
        this.setState({
          options: optionsx,
          selectDis: false,
        });
      });
    } else if (!this.props.isEdit && Object.keys(obj).length > 0) {
      if (obj[dataColumn.base52]) {
        getServicesNomal(getLabelsApi, {
          id: dataColumn.id,
          values: obj[dataColumn.base52],
          filterSql,
          allValues,
        }).then(labels => {
          this.setState({
            labels,
            selectDis: false,
          });
        });
      }
    } else {
      getServicesNomal(getOptionsApi, {
        id: dataColumn.id,
        filterSql,
        allValues,
      }).then(options => {
        const optionsx = [];
        for (var i = 0; i < options.length; i++) {
          optionsx.push({
            label: options[i][dataColumn.referenceNameName],
            value: options[i][dataColumn.referenceCodeName],
          });
        }
        this.setState({
          options: optionsx,
          selectDis: false,
        });
      });
    }
  };
  getColumn = key => {
    let { mapData, json } = this.props;

    const columnIds = json?.columnIds;

    if (
      columnIds == null ||
      Object.keys(columnIds).length == 0 ||
      columnIds[key] == null ||
      mapData == null
    ) {
      return null;
    }

    const dataColumn = mapData[columnIds[key][columnIds[key].length - 1]];

    return dataColumn;
  };

  render() {
    /**
     * json为申请表单
     * obj为查看详情用户输入值
     */
    let {
      json: jsonStatic,
      obj,
      mapData,
      init,
      sqlData,
      defaultValues,
      get,
      formKey,
      isEdit,
      datas,
      taskAssignee,
      userId,
      i,
      j,
      isPreview,
      currentFormTitle,
      getCellValue,
      uuid,
    } = this.props;

    // 27282 双选会报名后管理员修改举办时间 但是单位申请信息么有随着更新
    let json = jsonStatic;

    if (json) {
      json = {
        ...jsonStatic,
        ...getActiveJson(formKey, uuid),
      };
    }
    // if(uuid === 'violation_type_id'){
    //   console.log(formKey, json);
    // }

    const { options, labels, selectDis, modalCode, modalTitle, modalInit, modalProps } = this.state;
    const { getFieldDecorator, getFieldError, getFieldProps } = this.props.form;
    const disabled = json != null ? json.disabled : false;
    const permRank = json != null ? (json.permRank != null ? json.permRank : 0) : 0;
    if (json?.label === '账号') {
      // console.log(json);
    }
    if (json == null) {
      return <></>;
    }
    let otherProps = {};

    //私有
    if (!isEdit && permRank == 1 && taskAssignee != userId) {
      return <></>;
    }
    if (json.comName == 'QRCode') {
      if (
        this.state.option == null ||
        this.state.option.value == null ||
        this.state.option.value == null
      ) {
        return <></>;
      }
      return <QRCode {...this.state.option} key={uuid} />;
    }
    if (json.comName === 'Echart') {
      return this.props.form.getFieldDecorator(uuid, {
        initialValue: '',
      })(
        <EchartsDiy json={json} uuid={uuid} option={this.state.option} />
      )
    }
    if (json.comName === 'Graph') {
      return <Neo4jD3Com key={uuid} json={json} option={this.state.option || []} />;
    }
    if (['PartForm', 'Steps'].includes(json.comName)) {
      this.partFormProps = {
        taskId: this.props.taskId,
        importExcel: this.props.importExcel,
        setRealTimeValues: this.props.setRealTimeValues,
        hfInstance: this.props.hfInstance,
        getCellValue: getCellValue,
        taskAssignee: taskAssignee,
        isWebPrint: this.props.isWebPrint || false,
        userId: userId,
        isPreview: isPreview,
        modalInit: modalInit,
        datas: datas,
        trees: this.props.trees,
        get: get,
        isChild: true,
        isEdit: isEdit,
        obj: obj,
        init: init,
        formCode: this.props.formCode,
        formId: this.props.formId,
        mapData: mapData,
        sqlData: sqlData,
        defaultValues: defaultValues,
      };
    }

    if (json.comName === 'PartForm') {
      const fk = this.props.form.getFieldsValue()[uuid] || json.childFormKey;
      if (fk == null) {
        return <></>;
      }
      if (formKey === fk) {
        return <>片段表单key不能和自身相同</>;
      }
      return (
        <>
          {this.props.form.getFieldDecorator(uuid, {
            initialValue: fk,
          })(<Input type="hidden" />)}
          {json.isLabel ? (<Form.Item
            labelCol={{ span: json.labelSpan }}
            wrapperCol={{ span: json.wrapperSpan }}
            label={json.label}
          >
            <ZdyTable
              {...this.partFormProps}
              currentFormTitle={
                this.props.getCurrentFormTitle ? this.props.getCurrentFormTitle(fk) : null
              }
              key={fk}
              currentFormKey={fk}
              {...datas[fk]}
              form={this.props.form}
            />
          </Form.Item>) : (<ZdyTable
            {...this.partFormProps}
            currentFormTitle={
              this.props.getCurrentFormTitle ? this.props.getCurrentFormTitle(fk) : null
            }
            key={fk}
            currentFormKey={fk}
            {...datas[fk]}
            form={this.props.form}
          />)}

        </>
      );
    }

    if (json.comName === 'CustomLayout') {
      if (json?.otherProps) {
        otherProps = json?.otherProps;
        try {
          otherProps = new Function(otherProps)();
        } catch (e) {
          otherProps = {};
        }
      }
      const xx = (
        <div id={uuid} style={{ ...otherProps?.style }}>
          {Array.isArray(otherProps?.data) && otherProps.data.map(r => {
            return (
              <ZdyTable
                changedValues={this.props.changedValues}
                setRealTimeValues={this.props.setRealTimeValues}
                trees={this.props.trees}
                taskId={this.props.taskId}
                taskAssignee={taskAssignee}
                userId={userId}
                modalInit={modalInit}
                key={r.key}
                datas={datas}
                get={get}
                isChild={true} // 是否为子表单
                currentFormKey={r.key}
                currentFormStyle={r?.style}
                currentFormTitle={r?.title}
                isEdit={isEdit}
                obj={obj}
                init={init}
                form={this.props.form}
                mapData={mapData}
                sqlData={sqlData}
                {...datas[r.key]}
                defaultValues={defaultValues}
              />
            );
          })}
        </div>
      );
      return xx;
    }

    if (json.comName === 'Tree') {
      return this.props.form.getFieldDecorator(uuid, {
        initialValue: '',
      })(
        <TreeDiy json={this.props.json}/>
      )
    }

    if (json.comName === 'Excel') {
      const value = getCellValue(i, j, currentFormTitle);
      const xx = (
        <div
          style={{
            textAlign: 'center',
            height: value == null ? 20 : null,
          }}
        >
          {value}
        </div>
      );
      return xx;
    }
    if (json.comName === 'Label') {
      let uid;
      if (this.props.fatherCode != null) {
        uid = `${this.props.fatherCode}.[${this.props.index}].${uuid}`;
      } else {
        uid = uuid;
      }
      if (!isEdit) {
        return obj[uuid] || json.initialValue || '';
      } else {
        if (this.props.fatherCode != null) {
          return (
            <>
              {this.props.form.getFieldDecorator(uid, {
                initialValue: obj[uuid] || json.initialValue,
              })(<Input type="hidden" />)}
              <span
                style={{
                  fontWeight: get === 'mobile' ? 'bold' : '',
                  marginRight: get === 'mobile' ? 12 : '',
                }}
                {...json.props}
              >
                {obj[uuid] || json.initialValue}
              </span>
            </>
          );
        } else {
          return (
            <>
              {this.props.form.getFieldDecorator(uid, {
                initialValue: this.props.form.getFieldsValue()[uid] || json.initialValue,
              })(<Input type="hidden" />)}
              <span
                style={{
                  fontWeight: get === 'mobile' ? 'bold' : '',
                  marginRight: get === 'mobile' ? 12 : '',
                }}
                {...json.props}
              >
                {this.props.form.getFieldsValue()[uid]}
              </span>
            </>
          );
        }
      }
    }

    if (json.comName === 'Description') {
      const key = json.sqls[json.sqls.length - 1];
      var cm = '';
      var value;
      if (obj != null && obj.defaultValues) {
        let defaultValuesNew = {};
        for (let i in obj.defaultValues) {
          let oneFormKey = obj.defaultValues[i];
          if (oneFormKey && typeof oneFormKey === 'object') {
            for (let g in oneFormKey) {
              defaultValuesNew[g] = oneFormKey[g];
            }
          }
        }
        value = defaultValuesNew[key] || defaultValues[key];
        /** 2022年3月4日 15点15分 姚鑫国说的 这里面的key 不会有重复的 所以直接遍历后赋值到 value 上
         *  解决 移动端渲染的表单和web端渲染的不同 导致获取不到默认值的bug
         *  禅道bug 24669 学生事务/请假管理/请假审核,2018010347 辅导员审核时 在表中 学生的个人信息没出来
         *  **/
        // if (obj.defaultValues[formKey]) {
        //   value = obj.defaultValues[formKey][key];
        // } else if (defaultValues) {
        //   value = defaultValues[key];
        // }
      } else if (defaultValues) {
        value = defaultValues[key];
      }

      switch (json.viewName) {
        case 'TextArea':
          cm = (
            <span style={{ paddingRight: get === 'mobile' ? 8 : '' }}>
              {value}
              {get === 'mobile' ? <br /> : ''}
            </span>
          );
          break;
        case 'Switch':
          cm = (
            <span>
              {value}
              {get === 'mobile' ? <br /> : ''}
            </span>
          );

          break;
        case 'Input':
          cm = (
            <span style={{ paddingRight: get === 'mobile' ? 8 : '' }} data-com-name={'input'}>
              {value}
              {get === 'mobile' ? '' : ''}
            </span>
          );

          break;
        case 'Cron':
          cm = (
            <span style={{ paddingRight: get == 'mobile' ? 8 : '' }}>
              {value}
              {get === 'mobile' ? <br /> : ''}
            </span>
          );

          break;
        case 'InputNumber':
          cm = (
            <span>
              {value}
              {get === 'mobile' ? <br /> : ''}
            </span>
          );

          break;
        case 'DatePicker':
          cm = value ? (
            <span>
              {moment(parseInt(value)).format('YYYY-MM-DD HH:mm:ss')}
              {get === 'mobile' ? <br /> : ''}
            </span>
          ) : (
            ''
          );

          break;
        case 'PictureSignature': //只读模式
          const filesX = value.files || [];
          cm = (
            <>
              <ul>
                {filesX.map((f, index2) => {
                  return (
                    <li key={index2}>
                      <a target="_blank" key={f.path} href={queryFileUrl(f.path)}>
                        {f.name}
                      </a>
                    </li>
                  );
                })}
              </ul>
              {get === 'mobile' ? <br /> : ''}
            </>
          );

          break;
        case 'UploadCom':
          const files = value.files || [];
          cm = (
            <>
              <ul>
                {files.map((f, index2) => {
                  return (
                    <li key={index2}>
                      <a target="_blank" key={f.path} href={queryFileUrl(f.path)}>
                        {f.name}
                      </a>
                    </li>
                  );
                })}
              </ul>
              {get === 'mobile' ? <br /> : ''}
            </>
          );

          break;
        case 'ImgUploadCom': // 图片上传组件
          if (value == null || value == '') {
            cm = (
              <div
                style={{
                  width: json.width,
                  height: json.height,
                }}
              />
            );
          } else {
            cm = (
              <>
                <img
                  src={queryFileUrl(value)}
                  style={{
                    width: json.width,
                    height: json.height,
                  }}
                />
                {get === 'mobile' ? <br /> : ''}
              </>
            );
          }

          break;
        case 'VideoUploadCom':
          if (value == null || value == '') {
            cm = (
              <div
                style={{
                  width: json.width,
                  height: json.height,
                }}
              />
            );
          } else {
            cm = (
              <>
                <img
                  src={queryFileUrl(value)}
                  style={{
                    width: json.width,
                    height: json.height,
                  }}
                />
                {get === 'mobile' ? <br /> : ''}
              </>
            );
          }
          break;
      }
      if (get === 'mobile') {
        if (
          (json.isMobileLabel != null && json.isMobileLabel) ||
          (json.isMobileLabel == null && json.isLabel)
        ) {
          if (obj && obj.defaultValues && obj.defaultValues[formKey]) {
            return (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={json.label ? json.label : sqlData[key] ? sqlData[key].title : ''}
              >
                {cm}
              </MobileItem>
            );
          } else {
            return (
              <>
                <MobileItem
                  isPreview={isPreview}
                  labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                  wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                  label={json.label ? json.label : sqlData[key] ? sqlData[key].title : ''}
                >
                  {cm}
                </MobileItem>
                {this.props.form.getFieldDecorator(`defaultValues.${formKey}.${key}`, {
                  initialValue: value,
                })(<Input type="hidden" />)}
              </>
            );
          }
        } else {
          if (!isEdit && obj.defaultValues && obj.defaultValues[formKey]) {
            return cm;
          } else {
            return (
              <>
                {cm}
                {this.props.form.getFieldDecorator(`defaultValues.${formKey}.${key}`, {
                  initialValue: value,
                })(<Input type="hidden" />)}
              </>
            );
          }
        }
      } else {
        if (json.isLabel) {
          if (obj && obj.defaultValues && obj.defaultValues[formKey]) {
            if (!isEdit) {
              return (
                <Row
                  style={{
                    minHeight: 40,
                    lineHeight: '40px',
                  }}
                >
                  <Col
                    className={json.label ? json.label : sqlData[key] ? styles.row_col_div : ''}
                    span={json.labelSpan}
                    style={{
                      textAlign: json.labelSpan === 24 ? 'left' : 'right',
                      lineHeight: '40px',
                      whiteSpace: 'nowrap',
                      overflow: 'hidden',
                      fontSize: 14,
                      color: 'rgba(0,0,0,0.85)',
                    }}
                  >
                    {json.label ? (
                      <>
                        {json.label}
                        <span
                          style={{
                            position: 'relative',
                            top: '-0.5px',
                            margin: '0 8px 0 2px',
                          }}
                        >
                          :
                        </span>
                      </>
                    ) : sqlData[key] ? (
                      <>
                        {sqlData[key].title}
                        <span
                          style={{
                            position: 'relative',
                            top: '-0.5px',
                            margin: '0 8px 0 2px',
                          }}
                        >
                          :
                        </span>
                      </>
                    ) : (
                      ''
                    )}
                  </Col>
                  <Col
                    span={json.wrapperSpan}
                    style={{
                      position: 'relative',
                      lineHeight: '40px',
                      zoom: 1,
                      fontSize: 14,
                    }}
                  >
                    {cm}
                  </Col>
                </Row>
              );
            } else {
              return (
                <Form.Item
                  labelCol={{ span: json.labelSpan }}
                  wrapperCol={{ span: json.wrapperSpan }}
                  label={json.label ? json.label : sqlData[key] ? sqlData[key].title : ''}
                >
                  {cm}
                </Form.Item>
              );
            }
          } else {
            return (
              <>
                <Form.Item
                  labelCol={{ span: json.labelSpan }}
                  wrapperCol={{ span: json.wrapperSpan }}
                  label={json.label ? json.label : sqlData[key] ? sqlData[key].title : ''}
                >
                  {cm}
                </Form.Item>
                {this.props.form.getFieldDecorator(`defaultValues.${formKey}.${key}`, {
                  initialValue: value,
                })(<Input type="hidden" />)}
              </>
            );
          }
        } else {
          if (!isEdit && obj.defaultValues && obj.defaultValues[formKey]) {
            return cm;
          } else {
            return (
              <>
                {cm}
                {this.props.form.getFieldDecorator(`defaultValues.${formKey}.${key}`, {
                  initialValue: value,
                })(<Input type="hidden" />)}
              </>
            );
          }
        }
      }
    }

    var cm;
    var required = false;
    const bindObj = this.getColumn('c1');

    let dataColumn =
      this.props.fatherCode != null
        ? bindObj
          ? {
            ...bindObj,
            base52: `${this.props.fatherCode}.[${this.props.index}].${bindObj.base52}`,
          }
          : { base52: `${this.props.fatherCode}.[${this.props.index}].${uuid}` }
        : bindObj;

    if (this.props.fatherCode == null && dataColumn == null) {
      dataColumn = { base52: uuid };
    }
    if (dataColumn.isNull != null && !dataColumn.isNull) {
      required = true;
    }
    if (Array.isArray(json.vlds)) {
      for (let item of json.vlds) {
        if (item.required) {
          required = true; // 验证里面填了必填 则必填
        }
      }
    }


    var title = json.label || (dataColumn && dataColumn.title);
    var initValue;
    const objinit = { ...init, ...obj };

    if (objinit !== null && Object.keys(objinit).length > 0) {
      if (this.props.fatherCode != null) {
        initValue =
          objinit[this.props.index] != null
            ? objinit[this.props.index][bindObj ? bindObj.base52 : uuid]
            : null;
      } else {
        initValue = objinit[dataColumn.base52];
      }
    } else {
      if (json.initialValue != null) {
        try {
          initValue = JSON.parse(json.initialValue);
        } catch (e) {
          initValue = null;
        }
      }
    }

    if (!isEdit) {
      if (this.props.fatherCode) {
        if (bindObj != null) {
          dataColumn.base52 = bindObj.base52;
        } else {
          dataColumn.base52 = uuid;
        }
      }

      switch (json.comName) {
        case 'RichText':
          cm = (
            <Editor
              key={dataColumn.base52}
              readOnly={true}
              blockRendererFn={MyBlockRenderer.bind(this, true, null, null, null)}
              editorState={changeToDraftState(obj[dataColumn.base52])}
            />
          );
          break;
        case 'MobileCard':
          let value = obj[dataColumn.base52];
          if (!value || value === 'null') {
            return <div />;
          }
          cm = (
            <MobileCard
              value={value}
              json={json}
              getArguments={this.functionArguments}
              tableComProps={this.props}
              dataColumn={dataColumn}
            />
          );
          break;
        case 'WangEditor':
          let textV = obj[dataColumn.base52];
          if (!textV || textV === 'null') {
            return <div />;
          }
          cm = (
            <div
              dangerouslySetInnerHTML={{
                __html: `<div class='wangEditorHtml'>
${obj[dataColumn.base52]}
</div>`,
              }}
            />
          );
          break;
        case 'TextArea':
          cm = (
            <span
              style={{
                wordBreak: 'break-all',
              }}
            >
              {obj[dataColumn.base52]}
            </span>
          );
          break;
        case 'Switch':
          cm = <span>{obj[dataColumn.base52]}</span>;

          break;
        case 'Input':
          cm = (
            <span
              data-obj-base52={dataColumn.base52}
              data-obj-comname={'Input'}
              style={{
                wordBreak: 'break-all',
              }}
            >
              {obj[dataColumn.base52]}
            </span>
          );

          break;
        case 'InputHidden':
          cm = <></>;

          break;
        case 'InputNumber':
          cm = <span>{obj[dataColumn.base52]}</span>;

          break;
        /**
         * 为Radio为单选
         */
        case 'Radio':
          cm = <span>{labels != null && labels.length > 0 ? Object.values(labels[0]) : ''}</span>;

          break;
        /**
         * 为Checked为多选
         * 该组件需要调用请求
         */
        case 'Checkbox':
          cm = (
            <span>
              {labels != null
                ? labels.map((r, i) =>
                  i == 0 ? (
                    typeof r == 'string' ? (
                      <span>{r}</span>
                    ) : (
                      Object.values(r)
                    )
                  ) : typeof r == 'string' ? (
                    <span style={{ marginLeft: 12 }}>{r}</span>
                  ) : (
                    ',' + Object.values(r)
                  ),
                )
                : ''}
            </span>
          );

          break;
        case 'TreeSelect':
          cm = (
            <span>
              {labels != null
                ? labels.map((r, i) =>
                  i == 0 ? (
                    typeof r == 'string' ? (
                      <span>{r}</span>
                    ) : (
                      Object.values(r)
                    )
                  ) : typeof r == 'string' ? (
                    <span style={{ marginLeft: 12 }}>{r}</span>
                  ) : (
                    ',' + Object.values(r)
                  ),
                )
                : ''}
            </span>
          );

          break;
        case 'Select':
          let stringLabels = labels != null && labels.length > 0 ? labels.join(' ') : '';
          if (Array.isArray(labels) && labels.length && typeof labels[0] === 'object') {
            stringLabels = '';
            let vLabels = [];
            for (let item of labels) { // 解决禅道 32141 如果存在其他问题 估计要从otherProps中获取是否是多选 如果不是多选只取一个值
              if (Object.values(item)) {
                vLabels.push(Object.values(item));
              }
            }
            stringLabels = [...new Set(vLabels)].join(', '); //
          }
          cm = <span>{stringLabels}</span>;

          break;
        case 'Cascader':
          cm = <span>{labels != null ? labels.join(json.spliter ? json.spliter : '') : ''}</span>;
          break;
        case 'TableSelect':
          const ds =
            obj[dataColumn.base52] && obj[dataColumn.base52].selects
              ? Object.values(obj[dataColumn.base52].selects)
              : [];
          if (json.showTable) {
            cm = (
              <Table
                columns={this.state.columns}
                size="small"
                dataSource={ds}
                pagination={false}
              />
            );
          } else {
            cm = (
              <span>
                {ds.map((r, i) => (i == 0 ? r[json.labelName] : ',' + r[json.labelName]))}
              </span>
            );
          }

          break;
        case 'RangePicker':
          const begin = dataColumn;
          const end = this.getColumn('c2');
          const ivs = [];
          if (initValue != null && init != null) {
            ivs.push(moment(parseInt(initValue)));
            if (end != null && init[end.base52]) {
              ivs.push(moment(parseInt(init[end.base52])));
            } else {
              ivs.push(moment());
            }
          }
          if (begin != null && end != null) {
            if (!obj[begin.base52]) {
              cm = <span>暂无</span>;
            } else {
              cm = (
                <span>
                  {moment(parseInt(obj[begin.base52])).format(
                    json.format ? json.format : 'YYYY-MM-DD HH:mm:ss',
                  )}{' '}
                  至{' '}
                  {moment(parseInt(obj[end.base52])).format(
                    json.format ? json.format : 'YYYY-MM-DD HH:mm:ss',
                  )}
                </span>
              );
            }
          } else {
            cm = '';
          }
          title = title ? title : '起止时间';
          break;
        case 'DatePicker':
          const vTime = obj[dataColumn.base52];
          if (vTime && typeof vTime === 'string' && vTime.indexOf('-') <= -1) {
            cm = (
              <span>
                {moment(parseInt(vTime)).format(json.format ? json.format : 'YYYY-MM-DD HH:mm:ss')}
              </span>
            );
          } else {
            cm = (
              <span>
                {vTime
                  ? moment(+new Date(vTime)).format(
                    json.format ? json.format : 'YYYY-MM-DD HH:mm:ss',
                  )
                  : ''}
              </span>
            );
          }

          break;
        case 'PictureSignature': // 非编辑模式 直接渲染成图片
          if (!isEmpty(obj[dataColumn.base52])) {
            // 首先判断是否为空对象
            let ary;
            /**
             * 判断返回值是否为JSON字符串,不是则直接使用
             */
            if (isJSON(obj[dataColumn.base52])) {
              ary = JSON.parse(obj[dataColumn.base52]);
            } else {
              ary = obj[dataColumn.base52];
            }
            if (!!ary.files) {
              // 然后判断存在多个附件的数组是否存在
              const files = !isEmpty(ary) ? ary.files : [];
              cm = (
                <ul className={styles.imageUl}>
                  {files.map((f, index2) => {
                    return (
                      <li key={f.path}>
                        <PictureSignature
                          json={json}
                          disabled={true} // 只读模式
                          basicUrl={queryApiActionPath()}
                          fileInfo={f}
                        />
                      </li>
                    );
                  })}
                </ul>
              );
            } else {
              const files = !isEmpty(ary) ? ary : [];
              cm = (
                <ul className={styles.imageUl}>
                  {Array.isArray(files) &&
                    files.map((f, index2) => {
                      return (
                        <li key={f.path}>
                          <PictureSignature
                            json={json}
                            disabled={true} // 只读模式
                            basicUrl={queryApiActionPath()}
                            fileInfo={f}
                          />
                        </li>
                      );
                    })}
                </ul>
              );
            }
          } else {
            cm = (
              <span
                style={{
                  display: 'inline-block',
                  width: '100%',
                  textAlign: 'center',
                }}
              />
            );
          }

          break;
          // 文件预览 a标签
        case 'UploadCom':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              // mode = multiple 就支持下拉多选了
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          cm = <UploadComReadOnly get={get}
            obj={obj}
            dataColumn={dataColumn}
            isPrint={this.props.isPrint}
            otherProps={otherProps}
          />
          break;
        case 'ImgUploadCom':
          if (obj[dataColumn.base52] == null || obj[dataColumn.base52] == '') {
            cm = (
              <div
                style={{
                  width: json.width,
                  height: json.height,
                }}
              />
            );
          } else {
            cm = FilePreview ? (
              <FilePreview
                path={queryFileUrl(obj[dataColumn.base52])}
                pathName={typeof obj[dataColumn.base52] !== 'string' ? '' : obj[dataColumn.base52]}
                width={json.width}
                height={json.height}
              />
            ) : (
              <img
                src={queryFileUrl(obj[dataColumn.base52])}
                style={{
                  width: json.width,
                  height: json.height,
                }}
              />
            );
          }

          break;
        case 'VideoUploadCom':
          if (obj[dataColumn.base52] == null || obj[dataColumn.base52] == '') {
            cm = (
              <div
                style={{
                  width: json.width,
                  height: json.height,
                }}
              />
            );
          } else {
            cm = FilePreview ? (
              <FilePreview
                path={queryFileUrl(obj[dataColumn.base52])}
                pathName={obj[dataColumn.base52]}
                width={json.width}
                height={json.height}
              />
            ) : (
              <img
                src={queryFileUrl(obj[dataColumn.base52])}
                style={{
                  width: json.width,
                  height: json.height,
                }}
              />
            );
          }

          break;
        case 'Signature':
          if (!obj[dataColumn.base52]) {
            console.log('签名组件没有获取到图片地址', dataColumn.base52);
            cm = '';
          } else {
            const filePath = queryFileUrl(obj[dataColumn.base52]);
            if (!filePath) {
              cm = '';
            } else {
              cm = (
                <img
                  data-cell-component={'Signature'}
                  data-cell-base52={dataColumn.base52}
                  src={filePath}
                  style={{
                    marginLeft: 5,
                    minHeight: get === 'mobile' ? '200px' : 'auto',
                    width: get === 'mobile' ? 'auto' : json.width,
                    height: get === 'mobile' ? '' : json.height,
                  }}
                />
              );
            }
          }

          break;
        case 'ChildForm':
          const xxxxx = obj[dataColumn.base52];
          if (xxxxx == null) {
            cm = <></>;
            // Chil;
            break;
          }
          if (Object.keys(xxxxx).length > 0) {
            delete xxxxx[''];
          }
          cm = (
            <ChildForm
              taskId={this.props.taskId}
              setRealTimeValues={this.props.setRealTimeValues}
              modalInit={modalInit}
              trees={this.props.trees}
              isPreview={isPreview}
              hfInstance={this.props.hfInstance}
              getCurrentFormTitle={this.props.getCurrentFormTitle}
              getCellValue={getCellValue}
              fatherObj={obj}
              json={json}
              rights={json.rights || []}
              isMobile={get === 'mobile'}
              value={xxxxx}
              deleteName={json.deleteName}
              addName={json.addName}
              isEdit={isEdit}
              formCode={this.props.formCode}
              formId={this.props.formId}
              base52={dataColumn.base52}
              mapData={mapData}
              datas={datas ? datas[json.childFormKey] : null}
              datasAll={datas}
              defaultValues={defaultValues}
              sqlData={sqlData}
              form={this.props.form}
            />
          );
          break;
        case 'Button':
          let events = {};

          if (json.events != null) {
            events = this.getFunctionValue(json.events, { base52: uuid }, json);
          }
          if (events && events.dom) {
            cm = events.dom;
          } else {
            const ev = {
              children: json.initialValue,
              ...events,
            };
            if (json.isLink) {
              cm = <a {...ev} />;
            } else {
              cm = <ButtonDiy loading={this.props.loading} type="primary" {...ev} form={this.props.form}/>;
            }
          }

          break;
        case 'LocationCom':
          let v = obj[dataColumn.base52];
          if (typeof v !== 'object') {
            console.log('定位组件未获取到对象', '进行了数据转换', v, typeof v, isJSON(v));
            if (isJSON(v)) {
              v = JSON.parse(v);
            } else {
              v = {};
            }
          }
          cm = <span>{v.address || ''}</span>;
          break;

        case 'Table':
          if (json.objCode == null || json.objCode == '') {
            cm = <></>;
          }
          cm = (
            <TableList
              get={get}
              uuid={uuid}
              isTree={json.isTree}
              json={json}
              loading={this.props.loading}
              showHeader={json.showHeader}
              isHiddenPage={json.isHiddenPage}
              pageSize={json.pageSize}
              value={obj[dataColumn.base52 || uuid] || {}}
              objCode={json.objCode}
              sql={json.filterSql}
              rights={json.rights}
              obj={this.getObjValues()}
            />
          );
          break;
        default:
          cm = (
            <span>
              缺乏字段
              {json.comName}
              的匹配项
            </span>
          );
          break;
      }
    } else {
      //编辑模式
      if (json.vlds && json.vlds.length > 0) {
        for (let i in json.vlds) {
          if (json.vlds[i].validatorFunc && json.vlds[i].validatorFunc != '') {
            try {
              let fn = new Function('rule', 'value', 'callback', json.vlds[i].validatorFunc);
              json.vlds[i].validator = fn;
            } catch (e) {
              console.log(e);
            }
          }
        }
      }
      switch (json.comName) {
        case 'Button':
          let events = {};

          if (json.events != null) {
            events = this.getFunctionValue(json.events, { base52: uuid }, json);
          }
          if (events && events.dom) {
            cm = events.dom;
          } else {
            const ev = {
              children: json.initialValue,
              ...events,
            };
            if (json.isLink) {
              cm = <a {...ev} />;
            } else {
              cm = <ButtonDiy loading={this.props.loading} type="primary" {...ev} form={this.props.form}/>;
            }
          }

          break;
        case 'Switch':
          if (initValue === 'true' || initValue === true) {
            initValue = true;
          } else {
            initValue = false;
          }
          if (get === 'mobile') {
            if (dataColumn == null || json.formula != null) {
              cm = this.props.form.getFieldsValue()[uuid];
              break;
            }
            cm = (
              <MobileList.Item
                extra={
                  <MobileSwitch
                    {...getFieldProps(dataColumn.base52, {
                      initialValue: initValue,
                      rules:
                        json.vlds && json.vlds.length > 0
                          ? json.vlds
                          : [
                            {
                              required: required,
                              message: '请选择' + title,
                            },
                          ],
                    })}
                    disabled={disabled}
                    onClick={checked => {
                      // set new value
                      this.props.form.setFieldsValue({
                        [dataColumn.base52]: checked,
                      });
                    }}
                  />
                }
              >
                {(json.isMobileLabel != null && json.isMobileLabel) ||
                  (json.isMobileLabel == null && json.isLabel)
                  ? title
                  : ''}
              </MobileList.Item>
            );
            break;
          }
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            valuePropName: 'checked',
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请选择' + title,
                  },
                ],
          })(<SwitchWeb json={json} disabled={disabled} />);

          break;
        case 'TextArea':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              // mode = multiple 就支持下拉多选了
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          if (get === 'mobile') {
            cm = getFieldDecorator(dataColumn.base52, {
              initialValue: initValue,
              rules: giveVarcharRules({
                dataColumn,
                json,
                required,
                title,
              }),
            })(
              <TextArea
                autoSize={{ minRows: 4 }}
                disabled={disabled}
                placeholder={json.placeholder}
                {...otherProps}
              />,
            );
            cm = <div>{cm}</div>;
            if (
              ((json.isMobileLabel != null && json.isMobileLabel) ||
                (json.isMobileLabel == null && json.isLabel)) &&
              title
            ) {
              cm = (
                <MobileItem
                  isPreview={isPreview}
                  labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                  wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                  label={title}
                >
                  {cm}
                </MobileItem>
              );
            }
          } else {

            cm = getFieldDecorator(dataColumn.base52, {
              initialValue: initValue,
              rules: giveVarcharRules({
                dataColumn,
                json,
                required,
                title,
              }),
            })(
              <TextArea
                autoSize={{ minRows: 4 }}
                disabled={disabled}
                rows={4}
                placeholder={json.placeholder}
                {...otherProps}
              />,
            );
          }
          break;
        case 'Input':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              // mode = multiple 就支持下拉多选了
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          const { disabledInputStyle = {}, addonAfter } = otherProps;
          let inputStyle = {
            width: json.width,
          };
          if (disabled) {
            inputStyle = {
              ...inputStyle,
              ...disabledInputStyle,
            };
          }
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules: giveVarcharRules({
              dataColumn,
              json,
              required,
              title,
            }),
          })(
            <Input
              disabled={disabled}
              style={inputStyle}
              placeholder={json.placeholder}
              addonAfter={addonAfter}
            />,
          );

          if (get === 'mobile') {
            cm = <div>{cm}</div>;
            if (
              ((json.isMobileLabel != null && json.isMobileLabel) ||
                (json.isMobileLabel == null && json.isLabel)) &&
              title
            ) {
              cm = (
                <MobileItem
                  isPreview={isPreview}
                  labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                  wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                  label={title}
                >
                  {cm}
                </MobileItem>
              );
            }
          }
          break;
        case 'InputHidden':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
          })(<Input type="hidden" />);
          break;
        case 'InputNumber':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请输入' + title,
                  },
                ],
          })(
            <InputNumber
              disabled={disabled}
              placeholder={json.placeholder}
              max={json.max}
              min={json.min}
              addonAfter={otherProps?.addonAfter} //3.0ant 不支持
              precision={json.precision}
              step={json.step}
            />,
          );
          if (get == 'mobile') {
            cm = <div>{cm}</div>;
            if (
              ((json.isMobileLabel != null && json.isMobileLabel) ||
                (json.isMobileLabel == null && json.isLabel)) &&
              title
            ) {
              cm = (
                <MobileItem
                  isPreview={isPreview}
                  labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                  wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                  label={title}
                >
                  {cm}
                </MobileItem>
              );
            }
          }
          break;
        case 'Tabs':
          let configOption = this.state.option;
          if (
            !configOption ||
            !configOption.data ||
            !Array.isArray(configOption.data) ||
            !configOption.data.length
          ) {
            return null;
          }
          const tabsProps = configOption.tabsProps || {};
          const tabPaneProps = configOption.tabPaneProps || {};
          let activeKey = this.state.activeKey || configOption.data[0].key;
          cm = (
            <Tabs onChange={this.changeTabsActiveKey} activeKey={activeKey} {...tabsProps}>
              {configOption.data.map(r => {
                return (
                  <Tabs.TabPane tab={r.title} key={r.key} {...tabPaneProps}>
                    {activeKey === r.key ? (
                      <ZdyTable
                        changedValues={this.props.changedValues}
                        setRealTimeValues={this.props.setRealTimeValues}
                        trees={this.props.trees}
                        taskId={this.props.taskId}
                        taskAssignee={taskAssignee}
                        userId={userId}
                        modalInit={modalInit}
                        key={r.key}
                        datas={datas}
                        get={get}
                        isChild={true}
                        currentFormKey={r.key}
                        isEdit={isEdit}
                        obj={obj}
                        init={init}
                        form={this.props.form}
                        mapData={mapData}
                        sqlData={sqlData}
                        {...datas[r.key]}
                        defaultValues={defaultValues}
                      />
                    ) : /**
                       <ZdyTable
                       key={r}
                       modalInit={modalInit}
                       hfInstance={hfInstance}
                       currentFormTitle={
                            getCurrentFormTitle ? getCurrentFormTitle(json.childFormKey) : null
                          }
                       getCellValue={getCellValue}
                       formCode={this.props.formCode}
                       formId={this.props.formId}
                       isPreview={isPreview}
                       currentFormKey={json.childFormKey}
                       formConfig={datas}
                       get="mobile"
                       fatherCode={base52}
                       isEdit={isEdit}
                       index={r}
                       obj={objs[r]}
                       fatherObj={this.props.fatherObj}
                       init={objs}
                       isChild={true}
                       form={form}
                       mapData={mapData}
                       sqlData={sqlData}
                       datas={datasAll}
                       {...datas}
                       defaultValues={defaultValues}
                       />
                       * */
                      null}
                  </Tabs.TabPane>
                );
              })}
            </Tabs>
          );
          break;
        /**
         * 为Radio为单选
         */
        case 'Radio':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请选择' + dataColumn.title,
                  },
                ],
          })(<Radio.Group options={options} disabled={disabled} />);
          if (get == 'mobile') {
            cm = <div>{cm}</div>;
            if (
              ((json.isMobileLabel != null && json.isMobileLabel) ||
                (json.isMobileLabel == null && json.isLabel)) &&
              title
            ) {
              cm = (
                <MobileItem
                  isPreview={isPreview}
                  labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                  wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                  label={title}
                >
                  {cm}
                </MobileItem>
              );
            }
          }
          break;
        /**
         * 为Checked为多选
         * 该组件需要调用请求
         */
        case 'Checkbox':
          if (get === 'mobile') {
            cm = (
              <Flex direction="column" align="start">
                {getFieldDecorator(dataColumn.base52, {
                  initialValue: initValue, // 默认值
                  rules:
                    json.vlds && json.vlds.length > 0
                      ? json.vlds
                      : [
                        {
                          required: required,
                          message: '请选择' + dataColumn.title,
                        },
                      ],
                })(<Checkbox.Group options={options} disabled={disabled} />)}
              </Flex>
            );

            if (
              ((json.isMobileLabel != null && json.isMobileLabel) ||
                (json.isMobileLabel == null && json.isLabel)) &&
              title
            ) {
              cm = (
                <MobileItem
                  isPreview={isPreview}
                  labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                  wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                  label={title}
                >
                  {cm}
                </MobileItem>
              );
            }

            break;
          }
          // console.log(dataColumn.base52);
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请选择' + dataColumn.title,
                  },
                ],
          })(
            <Checkbox.Group
              options={options}
              disabled={disabled}
              data-base52={dataColumn.base52}
            />,
          );
          break;
        case 'TreeSelect':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请选择' + dataColumn.title,
                  },
                ],
          })(
            <TreeSelectDiy
              value={this.props.form.getFieldsValue()[dataColumn.base52]}
              treeData={options}
              json={json}
              disabled={disabled}
              data-base52={dataColumn.base52}
              uuid={uuid}
            />
          );
          break;
        case 'Select':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              // mode = multiple 就支持下拉多选了
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }

          const optDiy = Array.isArray(json?.options)
            ? json.options
            : Array.isArray(options)
              ? options
              : [];
          // if(uuid  === 'violation_type_id'){
          //   console.log(json);
          // }
          if (dataColumn.base52 === 'KjWXQFIprRc') {
            // console.log(json, required, dataColumn, optDiy);
          }

          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: !initValue && otherProps?.mode === 'multiple' ? undefined : initValue,
            rules:
              Array.isArray(json.vlds) && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请选择' + dataColumn.title,
                  },
                ],
          })(
            !optDiy.length ? (
              <Input disabled={true} style={{ width: json.width }} />
            ) : (
              <Select
                allowClear
                showSearch
                disabled={selectDis || disabled}
                placeholder={json.placeholder}
                style={{ width: json.width }}
                optionFilterProp="children"
                getPopupContainer={getPopupContainer(this.props.isDynamic, uuid)}
                onFocus={() => {
                  get === 'mobile' // 移动端取消输入键盘弹出
                    ? setTimeout(() => {
                      if (document.querySelectorAll(`.ant-select-search__field`).length > 0) {
                        let ary = [...document.querySelectorAll(`.ant-select-search__field`)];
                        ary.map(item => {
                          item.setAttribute('readonly', 'readonly');
                          // setTimeout(() => {
                          //   ary.map(arr => {
                          //     arr.removeAttribute('readonly');
                          //   })
                          // });
                        });
                      }
                    })
                    : null;
                }}
                filterOption={(input, option) =>
                  option
                    ? option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
                    : false
                }
                {...otherProps}
              >
                {optDiy.map(r => {
                  return (
                    <Option key={r.value} value={r.value}>
                      {r.label}
                    </Option>
                  );
                })}
              </Select>
            ),
          );
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          } else if (get === 'mobile') {
            cm = <div>{cm}</div>;
          }

          break;

        case 'Cascader':
          //zsz
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              // mode = multiple 就支持下拉多选了
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          const filterF = function filter(inputValue, path) {
            return path.some(
              option => option?.label?.toLowerCase()?.indexOf(inputValue.toLowerCase()) > -1,
            );
          };
          // if(this.props.uuid === 'id_32691685234912400529714267d34dc585a2'){
          //   console.log(initValue,
          //     dataColumn.base52,
          //     // options,
          //     // otherProps,
          //   );
          //   console.log(this.props.form.getFieldsValue())
          // }
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请选择' + dataColumn.title,
                  },
                ],
          })(
            <Cascader // 这里的options 获取方式存在bug 公式会重复调用
              options={options}
              allowClear
              data-cell-uuid-cascader={uuid}
              showSearch={{ filter: filterF }}
              disabled={disabled}
              getPopupContainer={getPopupContainer(this.props.isDynamic, uuid)}
              placeholder={json.placeholder}
              style={{ width: json.width }}
              {...otherProps}
            />,
          );
          if (get === 'mobile') {
            // console.log(json.vlds);
            cm = getFieldDecorator(dataColumn.base52, {
              initialValue: initValue,
              rules:
                json.vlds && json.vlds.length > 0
                  ? json.vlds
                  : [
                    {
                      required: required,
                      message: '请选择' + dataColumn.title,
                    },
                  ],
            })(<MobileCascader options={options} label={title} disabled={disabled} json={json} />);
          }

          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          } else if (get === 'mobile') {
            cm = <div>{cm}</div>;
          }

          break;
        case 'TableSelect':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue || {},

            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    validator: (rule, value, callback) => {
                      let errors = [];
                      if (
                        (Object.keys(value).length == 0 ||
                          Object.keys(value.selects).length == 0) &&
                        required != null &&
                        required
                      ) {
                        errors.push(new Error('请选择至少一个', rule.field));
                      }
                      callback(errors);
                    },
                    required: required,
                  },
                ],
          })(
              <TableSelect
                get={get}
                json={json}
                disabled={!isEdit}
                dataColumn={dataColumn}
                columns={this.state.columns}
                dataSource={this.state.dataSource}
                sqlModel={this.state.sqlModel}
                resetSearchText={this.resetSearchText}
                setPagination={this.setPagination}
                sqlKey={this.state.sqlKey}
                allValues={this.state.allValues}
              />
          );
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'RangePicker':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              // mode = multiple 就支持下拉多选了
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          const begin = dataColumn;
          var end = this.getColumn('c2');
          if (end == null) {
            end = { base52: uuid + '_2' };
          }
          const ivs = getMomentArr({
            begin,
            end,
            initValue,
            init,
            obj,
          });

          if (!isEdit) {
            cm = (
              <span>
                {moment(parseInt(obj[begin.base52])).format(
                  json.format ? json.format : 'YYYY-MM-DD HH:mm:ss',
                )}{' '}
                至{' '}
                {moment(parseInt(obj[end.base52])).format(
                  json.format ? json.format : 'YYYY-MM-DD HH:mm:ss',
                )}
              </span>
            );
          } else {
            if (get === 'mobile') {
              cm = getFieldDecorator(begin.base52 + '$' + end.base52, {
                initialValue: ivs,
                rules:
                  json.vlds && json.vlds.length > 0
                    ? json.vlds
                    : [
                      {
                        required: required,
                        message: '请选择起止时间',
                        validator: (rule, value, callback) => {
                          let errors = [];
                          if ((!value || !Array.isArray(value) || value.length !== 2) && required) {
                            // 移动端起止时间必须是个数组 且 length = 2
                            errors.push(new Error('请选择', rule.field));
                          }

                          callback(errors);
                        },
                      },
                    ],
              })(
                // 移动端起止时间组件
                <MobileDate
                  disabled={disabled}
                  required={required}
                  format={json.format}
                  showTime={json.showTime}
                  otherProps={otherProps}
                />,
              );
              if (
                ((json.isMobileLabel != null && json.isMobileLabel) ||
                  (json.isMobileLabel == null && json.isLabel)) &&
                title
              ) {
                cm = (
                  <MobileItem
                    isPreview={isPreview}
                    labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                    wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                    label={title}
                    required={required}
                  >
                    {cm}
                  </MobileItem>
                );
              }
              break;
            }
            cm = getFieldDecorator(begin.base52 + '$' + end.base52, {
              initialValue: ivs,
              rules:
                json.vlds && json.vlds.length > 0
                  ? json.vlds
                  : [
                    {
                      required: required,
                      message: '请选择起止时间',
                    },
                  ],
            })(<RangePickerDiy json={json} disabled={disabled} uuid={uuid} />);
          }
          if (json.label == null) title = '起止时间';
          break;
        case 'DatePicker':
          if (json?.otherProps) {
            otherProps = json?.otherProps;
            try {
              otherProps = new Function(otherProps)();
            } catch (e) {
              otherProps = {};
            }
          }
          const Component = otherProps.mode === 'time' ? TimePicker : DatePicker;
          var iv = null;
          if (initValue != null) {
            iv = moment(typeof initValue === 'string' ? +initValue : initValue);
          }
          // console.log(iv,json.format)
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: iv,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请选择起止时间',
                  },
                ],
          })(
            <Component
              disabled={disabled}
              showTime={json.showTime != null ? json.showTime : true}
              getCalendarContainer={getPopupContainer(false, uuid)}
              onOpenChange={
                get === 'mobile'
                  ? () => {
                    // 取消唤起移动端小键盘
                    setTimeout(() => {
                      if (document.querySelector('.ant-calendar-input ')) {
                        document
                          .querySelector('.ant-calendar-input ')
                          .setAttribute('readonly', 'readonly');
                        setTimeout(() => {
                          document
                            .querySelector('.ant-calendar-input ')
                            .removeAttribute('readonly');
                        });
                      }
                    });
                  }
                  : () => { }
              }
              format={json.format ? json.format : 'YYYY-MM-DD HH:mm:ss'}
              {...otherProps}
            />,
          );
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'PictureSignature': // 签章组件
          let filesPictureSignature = [];
          if (initValue != null && !isEmpty(initValue.files)) {
            filesPictureSignature = initValue.files;
          }
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: { files: filesPictureSignature },
            rules:
              json?.vlds && json?.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required,
                    message: '请进行签章',
                  },
                ],
          })(
            <SignArray // 签章组件 编辑模式
              json={json}
              disabled={disabled || isPreview}
              basicUrl={queryApiActionPath()}
              form={this.props.form}
            />,
          );
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'UploadCom':
          let files = [];
          // if (initValue != null) {
          if (initValue != null && !isEmpty(initValue.files)) {
            files = initValue.files;
          }
          // console.log(dataColumn.base52);
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: { files },
            rules: [
              {
                required,
                message: '请选择附件',
                validator: (rule, valueUploadCom, callback) => {
                  let errors = [];
                  if ((!valueUploadCom || valueUploadCom?.files?.length === 0) && required) {
                    errors.push(new Error('至少上传一个', rule.field));
                  }
                  callback(errors);
                },
              },
            ],
          })(
            <UploadCom
              isMultiple={json.isMultiple}
              accept={json.accept}
              btnName={json.btnName}
              json={json}
              dataKey={dataColumn.base52}
              disabled={disabled || isPreview}
            />,
          );
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'WangEditor':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请输入',
                  },
                ],
          })(<WangEditor json={json} dataColumn={dataColumn} disabled={disabled} uuid={uuid} />);
          break;
        case 'Steps':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
          })(
            <StepDiy
              json={json}
              dataColumn={dataColumn}
              disabled={disabled}
              uuid={uuid}
              partFormProps={this.partFormProps}
              form={this.props.form}
            />,
          );
          break;
        case 'MobileCard':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
          })(
            <MobileCard
              json={json}
              uuid={uuid}
              getArguments={this.functionArguments}
              tableComProps={this.props}
              dataColumn={dataColumn}
            />,
          );
          break;
        case 'RichText':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请输入',
                  },
                ],
          })(<DraftEditorCom placeholder={json.placeholder} disabled={json.disabled} />);
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'Cron':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请输入' + title,
                  },
                ],
          })(<CronEditorDiy />);
          break;
        case 'LocationCom':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: {},
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required,
                    message: '请获取定位信息',
                    validator: (rule, valueThis, callback) => {
                      let errors = [];
                      console.log(valueThis);
                      if (
                        (!valueThis || !JSON.stringify(valueThis).includes('address')) &&
                        required
                      ) {
                        errors.push(new Error('请获取定位信息', rule.field));
                      }
                      callback(errors);
                    },
                  },
                ],
          })(
            <LocationCom
              get={get}
              json={json}
              btnName={json.btnName}
              btnSucName={json.btnSucName}
              width={json.width}
              showMap={json.showMap}
            />,
          );
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'ChildForm':
          // console.log(datas, json);
          cm = getFieldDecorator(dataColumn.base52, { initialValue: initValue || {} })(
            <ChildForm
              taskId={this.props.taskId}
              setRealTimeValues={this.props.setRealTimeValues}
              rights={json.rights || []}
              hfInstance={this.props.hfInstance}
              getCurrentFormTitle={this.props.getCurrentFormTitle}
              getCellValue={getCellValue}
              isMobile={get === 'mobile'}
              trees={this.props.trees}
              fatherObj={obj}
              isPreview={isPreview}
              num={json.num}
              min={json.min}
              max={json.max}
              json={json}
              deleteName={json.deleteName}
              addName={json.addName}
              isEdit={isEdit}
              base52={dataColumn.base52}
              mapData={mapData}
              datas={datas ? datas[json.childFormKey] : null}
              datasAll={datas}
              // datas={datas}
              defaultValues={defaultValues}
              sqlData={sqlData}
              form={this.props.form}
            />,
          );

          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'ImgUploadCom':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请上传图片',
                  },
                ],
          })(<ImgUploadCom json={json} disabled={disabled} otherProps={this.otherProps} />);
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'VideoUploadCom':
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请上传视频',
                  },
                ],
          })(<VideoUploadCom json={json} disabled={disabled} />);
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'Signature': // 签名组件
          cm = getFieldDecorator(dataColumn.base52, {
            initialValue: initValue,
            rules:
              json.vlds && json.vlds.length > 0
                ? json.vlds
                : [
                  {
                    required: required,
                    message: '请进行签名',
                  },
                ],
          })(<Signature width={json.width} height={json.height} get={get} />);
          if (
            get === 'mobile' &&
            ((json.isMobileLabel != null && json.isMobileLabel) ||
              (json.isMobileLabel == null && json.isLabel)) &&
            title
          ) {
            cm = (
              <MobileItem
                isPreview={isPreview}
                labelCol={{ span: json.mLabelSpan || json.labelSpan }}
                wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
                label={title}
              >
                {cm}
              </MobileItem>
            );
          }
          break;
        case 'Table':
          if (json.objCode == null || json.objCode == '') {
            cm = <></>;
          } else {
            cm = (
              <>
                {getFieldDecorator(dataColumn.base52 || uuid, {
                  initialValue: initValue || {},
                })(
                  <TableList
                    json={json}
                    uuid={uuid}
                    isTree={json.isTree}
                    isHiddenPage={json.isHiddenPage}
                    showHeader={json.showHeader}
                    loading={this.props.loading}
                    pageSize={json.pageSize}
                    objCode={json.objCode}
                    sql={json.filterSql}
                    rights={json.rights}
                    get={get}
                    obj={this.getObjValues()}
                  />,
                )}
              </>
            );
          }
          break;
      }
    }

    if (json.isLabel) {
      if (get === 'mobile' && !this.props.isEdit) {
        return (
          <List
            style={{
              margin: 5,
              border: '1px solid #ccc',
            }}
            className={styles.mobileList}
          >
            {modalCode ? (
              <FormModal
                {...modalProps}
                modalCode={modalCode}
                handleCancel={this.closeModal.bind(this, modalCode)}
                title={modalTitle}
              >
                <ZdyTable
                  taskId={this.props.taskId}
                  taskAssignee={taskAssignee}
                  userId={userId}
                  trees={this.props.trees}
                  modalInit={modalInit}
                  key={modalCode}
                  datas={datas}
                  get={get}
                  isChild={true}
                  currentFormKey={modalCode}
                  isEdit={isEdit}
                  obj={obj}
                  init={init}
                  form={this.props.form}
                  mapData={mapData}
                  sqlData={sqlData}
                  {...datas[modalCode]}
                  defaultValues={defaultValues}
                />
              </FormModal>
            ) : (
              ''
            )}
            <List.Item extra={cm} multipleLine={true}>
              {title}
            </List.Item>
            {/*<Card.Header title={<span style={{ fontSize: 14 }}>{title}: {cm}</span>} />*/}
            {/*移动端只读模式 组件修改*/}
            {/*<Card.Body>{cm}</Card.Body>*/}
          </List>
        );
      }
      if (get === 'web') {
        if (!isEdit) {
          return (
            <Row
              style={{
                minHeight: 40,
                lineHeight: '40px',
              }}
            >
              <Col
                className={title ? styles.row_col_div : ''}
                span={json.labelSpan}
                style={{
                  textAlign: json.labelSpan === 24 ? 'left' : 'right',
                  lineHeight: '40px',
                  whiteSpace: 'nowrap',
                  overflow: 'hidden',
                  fontSize: 14,
                  color: 'rgba(0,0,0,0.85)',
                }}
              >
                {title}
                {title && (
                  <span
                    data-cell-component-name={json.comName || 'no_com'}
                    data-tag={'/tableCompon/index.jsx-4121'}
                    style={{
                      position: 'relative',
                      top: '-0.5px',
                      margin: '0 8px 0 2px',
                    }}
                  >
                    :
                  </span>
                )}
              </Col>
              <Col
                span={json.wrapperSpan}
                style={{
                  position: 'relative',
                  lineHeight: '40px',
                  zoom: 1,
                  fontSize: 14,
                }}
              >
                {cm}
              </Col>
              {modalCode ? (
                <FormModal
                  {...modalProps}
                  modalCode={modalCode}
                  handleCancel={this.closeModal.bind(this, modalCode)}
                  title={modalTitle}
                >
                  <ZdyTable
                    taskId={this.props.taskId}
                    taskAssignee={taskAssignee}
                    userId={userId}
                    trees={this.props.trees}
                    modalInit={modalInit}
                    key={modalCode}
                    datas={datas}
                    get={get}
                    isChild={true}
                    currentFormKey={modalCode}
                    isEdit={isEdit}
                    obj={obj}
                    init={init}
                    form={this.props.form}
                    mapData={mapData}
                    sqlData={sqlData}
                    {...datas[modalCode]}
                    defaultValues={defaultValues}
                  />
                </FormModal>
              ) : (
                ''
              )}
            </Row>
          );
        } else {
          // console.log(datas);

          return (
            <>
              {modalCode ? (
                <FormModal
                  {...modalProps}
                  modalCode={modalCode}
                  handleCancel={this.closeModal.bind(this, modalCode)}
                  title={modalTitle}
                >
                  <ZdyTable
                    taskId={this.props.taskId}
                    taskAssignee={taskAssignee}
                    userId={userId}
                    trees={this.props.trees}
                    modalInit={modalInit}
                    key={modalCode}
                    datas={datas}
                    get={get}
                    isChild={true}
                    currentFormKey={modalCode}
                    isEdit={isEdit}
                    obj={obj}
                    init={init}
                    form={this.props.form}
                    mapData={mapData}
                    sqlData={sqlData}
                    {...datas[modalCode]}
                    // items={}
                    defaultValues={defaultValues}
                  />
                </FormModal>
              ) : (
                ''
              )}
              <Form.Item
                labelCol={{ span: json.labelSpan }}
                wrapperCol={{ span: json.wrapperSpan }}
                label={title}
                data-cell-component-name={json.comName || 'no_com'}
              >
                <ShowComName json={json} />
                {cm}
              </Form.Item>
            </>
          );
        }
      } else {
        return (
          <>
            {modalCode ? (
              <FormModal
                {...modalProps}
                modalCode={modalCode}
                handleCancel={this.closeModal.bind(this, modalCode)}
                title={modalTitle}
              >
                <ZdyTable
                  taskId={this.props.taskId}
                  taskAssignee={taskAssignee}
                  userId={userId}
                  modalInit={modalInit}
                  trees={this.props.trees}
                  key={modalCode}
                  datas={datas}
                  get={get}
                  isChild={true}
                  currentFormKey={modalCode}
                  isEdit={isEdit}
                  obj={obj}
                  init={init}
                  form={this.props.form}
                  mapData={mapData}
                  sqlData={sqlData}
                  {...datas[modalCode]}
                  defaultValues={defaultValues}
                />
              </FormModal>
            ) : (
              ''
            )}
            {cm}
          </>
        );
      }
    } else {
      // console.log(datas[modalCode]);

      return (
        <>
          {modalCode ? (
            <FormModal
              {...modalProps}
              modalCode={modalCode}
              handleCancel={this.closeModal.bind(this, modalCode)}
              title={modalTitle}
            >
              <ZdyTable
                taskId={this.props.taskId}
                taskAssignee={taskAssignee}
                userId={userId}
                trees={this.props.trees}
                modalInit={modalInit}
                key={modalCode}
                datas={datas}
                get={get}
                isChild={true}
                currentFormKey={modalCode}
                isEdit={isEdit}
                obj={obj}
                init={init}
                form={this.props.form}
                mapData={mapData}
                sqlData={sqlData}
                {...datas[modalCode]}
                defaultValues={defaultValues}
              />
            </FormModal>
          ) : (
            ''
          )}
          {json.isMobileLabel && !isEdit && get == 'mobile' ? (
            <MobileItem
              isPreview={isPreview}
              labelCol={{ span: json.mLabelSpan || json.labelSpan }}
              wrapperCol={{ span: json.mWrapperSpan || json.wrapperSpan }}
              label={title}
            >
              {cm}
            </MobileItem>
          ) : isEdit && get == 'web' ? (
            json.isLabel ? (
              <Form.Item
                labelCol={{ span: json.labelSpan }}
                wrapperCol={{ span: json.wrapperSpan }}
                label={title}
              >
                <ShowComName json={json} />
                {cm}
              </Form.Item>
            ) : (
              <Form.Item>
                <ShowComName json={json} />
                {cm}
              </Form.Item>
            )
          ) : (
            cm
          )}
        </>
      );
    }
  }
}
