import { message, Modal } from 'antd';
import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';
import { isJSON } from '@/webPublic/one_stop_public/tableCompon/Split_Index/staticInfo';

export default function beforeApplySubmit(params) {
	if (params && window.beforeApplySubmit && typeof window.beforeApplySubmit === 'function') {
		console.log('beforeApplySubmit函数开始执行');
		const content = params.content && isJSON(params.content) ? JSON.parse(params.content) : {};
		return window
			.beforeApplySubmit({
				message,
				Modal,
				uaaRequest: (url, data) => {
					return uaaRequest(url, data);
				},
				userNowInfo: localStorage.getItem('user') ? JSON.parse(localStorage.getItem('user')) : '',
				submitParams: params,
				content,
			})
			.then((res) => {
				return res;
			})
			.catch((err) => {
				return false;
			});
	} else {
		return new Promise((resolve, reject) => {
			resolve(params);
		});
	}
}



