import { message, Modal } from 'antd';
import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';

export default function beforeAuditSubmit(params) {
  if (
    params &&
    window.beforeAuditSubmit &&
    typeof window.beforeAuditSubmit === 'function'
  ) {
    console.log('beforeAuditSubmit函数开始执行');
    // const content = params.content && isJSON(params.content) ? JSON.parse(params.content) : {};

    return window
      .beforeAuditSubmit({
        message,
        Modal,
        uaaRequest: (url, data) => {
          return uaaRequest(url, data);
        },
        userNowInfo: localStorage.getItem('user') ? JSON.parse(localStorage.getItem('user')) : '',
        submitParams: params,
      })
      .then((res) => {
        return res;
      })
      .catch((err) => {
        return false;
      });
  } else {
    return new Promise((resolve, reject) => {
      resolve(params);
    });
  }
}



