/**
 * 设置token
 * */
import { isJSON } from '@/webPublic/one_stop_public/copy';
import { getOneStopMyInfo } from '@/webPublic/one_stop_public/utils/utils';
import { delCookie, setCookie } from '@/webPublic/one_stop_public/utils/cookie';
import { getToken } from './getToken';

export { getToken } from './getToken';

export function setToken(value, time) {
  if (getToken() !== value) {
    // setCookie('token', value, 1);
    sessionStorage.removeItem('cacheMobile');
    localStorage.setItem('antd-pro-token-onestop', value);
    localStorage.setItem('antd-pro-token', value);
    localStorage.setItem('wisdom-school-token', value);
    return getOneStopMyInfo();
  } else {
    if (value && value.length > 10) {
      setCookie('token', value, 1);
    }
    return new Promise((resolve, reject) => {
      resolve(true);
    });
  }
}

/**
 * 删除token
 * */
export const delToken = () => {
  delCookie('token');
  localStorage.removeItem('antd-pro-type');
  localStorage.removeItem('antd-pro-token-onestop');
  localStorage.removeItem('antd-pro-token');
  localStorage.removeItem('wisdom-school-token');
  localStorage.removeItem('user');
  sessionStorage.removeItem('cacheMobile');
};

export const getUserInfo = () => {
  let x = localStorage.getItem('user');
  if (isJSON(x)) {
    x = JSON.parse(x);
    if (!x.groupsId) {
      x.groupsId = 'pub';
      x.differenceBetweenServerAndClientTime = 0;
    }
    if(!x.tenantCode){
      x.tenantCode = window.specialImportantSystemConfig.tenant || undefined;
    }
    return x;
  } else {
    return {
      groupsId: 'pub',
      differenceBetweenServerAndClientTime: 0,
      tenantCode: window.specialImportantSystemConfig.tenant || undefined,
    };
  }
};

export function setFetchUrl(data) {
  return localStorage.setItem('fetch-url-data', data);
}

export function getFetchUrl() {
  return localStorage.getItem('fetch-url-data');
}

export function getType() {
  if(window.location.href.indexOf('/sg/') > -1){
    return '/sg/';
  }
  return localStorage.getItem('antd-pro-type') || '';
}

export function setType(type) {
  return localStorage.setItem('antd-pro-type', type);
}

export function getCurrentUser() {
  const d = sessionStorage.getItem('currentUser');
  if (d && isJSON(d)) {
    return JSON.parse(d);
  } else {
    return {};
  }
}

export function setCurrentUser(v) {
  if (v && typeof v === 'object') {
    v.token = getToken();
    sessionStorage.setItem('currentUser', JSON.stringify(v));
  }
}

export function getVersion() {
  if(window.CONFIG.VERSION){
    return window.CONFIG.VERSION;
  }
  const version =
    localStorage.getItem('version') && localStorage.getItem('version') !== 'undefined'
      ? JSON.parse(localStorage.getItem('version'))
      : '';
  return version;
}

export function getSassSysCode(){
  return localStorage.getItem('sassSysCode');
}
export function setSassSysCode(v){
  localStorage.setItem('sassSysCode', v);
}
