/* eslint no-useless-escape:0 import/prefer-default-export:0 */
import { Modal, Popconfirm, message } from 'antd';
import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';
import { getTime } from '@/webPublic/zyd_public/utils/queryCurrent';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';
import { getUiaInfo } from '@/webPublic/one_stop_public/2023yunshangguizhou/request2.0';
import { getToken } from '@/webPublic/one_stop_public/utils/token';


const reg = /(((^https?:(?:\/\/)?)(?:[-;:&=\+\$,\w]+@)?[A-Za-z0-9.-]+(?::\d+)?|(?:www.|[-;:&=\+\$,\w]+@)[A-Za-z0-9.-]+)((?:\/[\+~%\/.\w-_]*)?\??(?:[-\+=&;%@.\w_]*)#?(?:[\w]*))?)$/;

const isUrl = (path) => reg.test(path);

const isAntDesignPro = () => {
	if (ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION === 'site') {
		return true;
	}

	return window.location.hostname === 'preview.pro.ant.design';
}; // 给官方演示站点用，用于关闭真实开发环境不需要使用的特性

const isAntDesignProOrDev = () => {
	const { NODE_ENV } = process.env;

	if (NODE_ENV === 'development') {
		return true;
	}

	return isAntDesignPro();
};

export { isAntDesignProOrDev, isAntDesignPro, isUrl };

export const dispatch = (type, payload, callback) => {
	window.g_app._store.dispatch({
		type,
		payload,
		callback,
	});
};

export const isFromIframe = () => {
	// 判断是否来自iframe 嵌入页面 暂时放弃使用
	return false;
	let isFromIframe = window.frames.length !== parent.frames.length;
	if (window.location.origin.indexOf('localhost') > -1) {
		return false;
	}
	return isFromIframe;
};

export const getModal = () => {
	return isFromIframe() ? window?.parent?.iframeParentComponent?.Modal : Modal;
};

export const getPopconfirm = () => {
	return isFromIframe() ? window?.parent?.iframeParentComponent?.Popconfirm : Popconfirm;
};

export const getMessage = () => {
	return isFromIframe() ? window?.parent?.iframeParentComponent?.message : message;
};

export const getOneStopMyInfo = (params = {}) => {
  let urlInfo = getUrlInfo();
  if(urlInfo.tenantCode){ // 如果是sass 系统 存在租户 则调用2.0的接口获取
    getUiaInfo({}, '/userApi/getMyInfo').then((res) => {
      if(res){
        localStorage.setItem('user', JSON.stringify(res));
      }
    })
  }else{
    return uaaRequest('/UserApi/getMy', params).then((res) => {
      if (res) {
        if (!res.groupsId) {
          res.groupsId = 'pub';
        }
        res.differenceBetweenServerAndClientTime = -50;
        res.token = getToken();
        localStorage.setItem('user', JSON.stringify(res));
        return res;
      }
    });
  }
};

export function filterSearchParams(data) {
  if(data && typeof data === 'object'){
    for(let key in data){
      if(data[key] === '' || typeof data[key] === 'undefined'){
        delete data[key];
      }
    }
  }
  return data;
}
