# 编辑日期

2020-4-20

#依赖资源

```js
antd
antd-mobile
echarts-for-reac
qrcode.react
js-md5
moment
lodash
react-highlight-words
base-x
react-native-uuid
brace
react-ace
draft-js
reqwest
xlsx-oc
react-native-uuid
path-to-regexp
prop-types
react-signature-canvas
react-file-viewer
```

##抽离注意

文件依赖的utils和config都抽离到了one_stop_public

## Model层注意

将**webPublic/Models**下文件放入src下的Models中

**modileHome**:该接口用于请求事务详细数据和表单数据

**affair**:该接口用于请求当前事务的待办已办和事务提交

**新建流程提交模板**

```js
dispatch({
          type: 'affair/startProcess',
          payload: {
            content: JSON.stringify(values), // form表单控件拿取整个的数据
            level: radioValue, // 紧急度配置
            appId: this.state.appId, // 事务ID
            id: !!this.state.draftId ? this.state.draftId : null // 如果为草稿则传入ID进行修改
          },
          callback: val => {

          },
        });
```



## 生成新表单入口文件



```js
import Entrance from '@/webPublic/Entrance'
<Entrance
	id=''//传入事务Id
    form={form} // antd表单控件
    get={'web'} // 'web'或 'mobile'
   />
```

## 生成历史表单入口文件

### 引入

```js
import HistoryForm from '@/webPublic/one_stop_public/Entrance/historyForm';
```

### 使用

```js
<HistoryForm 
        data={this.state.data} // 'affair/getIdFormDetail' 接口返回数据
        form={this.props.form} // form控件
        isNewForm // 是否渲染需要当前用户填写的审核表单 为false只会渲染历史回显表单 
/>
```



## 新增routerState

单个页面配置项如果需要使用**router路由参数**传值,则需要外部传入routerState

以下为示例

```js
let routerState = {
            history: this.props?.history,
            location: this.props?.location,
            match: this.props?.match,
            computedMatch: this.props?.computedMatch,
            route: this.props?.route
        } // 注 可选链运算符不兼容TS
```

```js
<ZdyTable
            get="web"
            height={config.height}
            postData={data}
            form={form}
            routerState={this.props.router}
            />
```



