import lsz from "@/assets/time.gif";
import React from "react";
import config from "@/config/config";
import { formatMessage } from "umi/locale";
import { getSysConfig } from "../utils/basiclayout";
import { isJSON } from "@/webPublic/zyd_public/utils/utils";
import { getYunShangGuiZhouSyStemConfig } from '@/webPublic/one_stop_public/2023yunshangguizhou/utils';

const query = {
  "screen-xs": {
    maxWidth: 575
  },
  "screen-sm": {
    minWidth: 576,
    maxWidth: 767
  },
  "screen-md": {
    minWidth: 768,
    maxWidth: 991
  },
  "screen-lg": {
    minWidth: 992,
    maxWidth: 1199
  },
  "screen-xl": {
    minWidth: 1200,
    maxWidth: 1599
  },
  "screen-xxl": {
    minWidth: 1600
  }
};



const getSystemConfig = () => {
  const urlParams = new URL(window.location.href);
  const systemList = ["/xg/", "/yx/", "/jy/", "/lx/", "/sg/", "/xl/", "/zs/", "/uaa/", "/tw/", "/ytw/", "/wzb/", "/szcp/", "/bysx/"];
  let findSystem = systemList.find((g) => {
    return urlParams.href.indexOf(g) > 0;
  });
  if (findSystem) {
    let systemX = findSystem.replace(/[/]/g, "");
    let res = config.systems[systemX];
    let systemDiyName = localStorage.getItem('systemDiyName');
    res.name = systemDiyName || res.name;
    return res;
  }
  return config.systems["jc"];
};

const antIcon =
  <div style={
    {
      position: "absolute",
      zIndex: 999999,
      width: 32,
      left: "48%"
    }}>
    <img src={lsz}
         style={{ width: 32, height: 32 }} />
  </div>;

const formatter = (data, parentPath = "", parentAuthority, parentName) => {
  return data.map(item => {
    if (config.checkPath) {
      item.authority = [item.path];
    }
    let locale = "menu";
    if (parentName && item.name) {
      locale = `${parentName}.${item.name}`;
    } else if (item.name) {
      locale = `menu.${item.name}`;
    } else if (parentName) {
      locale = parentName;
    }

    const result = {
      ...item,
      locale,
      authority: item.authority || parentAuthority
    };
    if (item.routes) {

      const children = formatter(item.routes, `${parentPath}${item.path}/`, item.authority, locale);
      // Reduce memory usage
      result.children = children;
    }
    delete result.routes;
    return result;
  });
};

const getMenuData = (routes) => {
  const newRoutes = formatter(routes);
  return newRoutes;
};


// 插入动态菜单
const insertActiveMenus = (routes = [], insertRoutes = []) => {
  let deleteIndex = [];
  if (!insertRoutes || !insertRoutes.length) {
    return routes;
  }
  for (let i = 0; i < routes.length; i++) {
    let item = routes[i];
    for (let g = 0; g < insertRoutes.length; g++) {
      let targetItem = insertRoutes[g];
      if (targetItem.oldBrotherPath && targetItem.oldBrotherPath === item.path) { // 发现哥哥节点 插入
        // console.log(targetItem);
        routes.splice(i + 1, 0, targetItem);
        deleteIndex.push(g);
      }
      if (targetItem.parentPath === item.path && !targetItem.oldBrotherPath) { // 没有哥哥节点的路由 插入
        if (item.children) {
          item.children.unshift(targetItem);
        } else {
          item.children = [targetItem];
        }
        deleteIndex.push(g);
      }

    }

    if (deleteIndex.length) {
      for(let i = 0; i < insertRoutes.length; i++){
        if(deleteIndex.includes(i)){
          insertRoutes[i].isDelete = true;
        }
      }
      insertRoutes = insertRoutes.filter((g) =>{
        return !g.isDelete;
      });
      deleteIndex = []; // 每次循环完 要清空这个 才行. 不然递归里面会删除多的
    }
    if (Array.isArray(item.children) && item.children.length) {

      insertActiveMenus(item.children, insertRoutes);
    }
  }
  return routes;
};
export { antIcon, query, getSystemConfig, formatter, getMenuData, insertActiveMenus, getYunShangGuiZhouSyStemConfig };

export const getDiyChineseMenus = () => {
  const menuChineseConfig = getSysConfig().menuChineseConfig;
  const menusList = isJSON(menuChineseConfig) && JSON.parse(menuChineseConfig) || {};
  return menusList;
}

export const getChineseName = (item) => { // 获取菜单名字
  if(!item){
    return '';
  }
  const menusList = getDiyChineseMenus();
  if (menusList[item.path]) {
    return menusList[item.path];
  }
  const menuName = item.chineseLocale || formatMessage({ id: item.locale });
  return menuName;
};


export const insertDetailPath = (res = []) => { // 插入详情路由
  for(let item of res){
    if(item.from === 'onestopApp'
      && (item.component.indexOf('Audit') > -1 || item.component.indexOf('Apply') > -1)
    ){ // 插入详情路由
      const pathSplit = item.path.split('/');
      pathSplit[pathSplit.length -1] = 'Detail';
      const pathDetail = pathSplit.join('/');
      // console.log(pathDetail);

      let checkHaveDetail = res.find((g) => {
        return g.path === pathDetail;
      });
      if(!checkHaveDetail){
        // console.log(item);
        res.push({
          ...item,
          chineseLocale: '详情',
          name: '详情',
          component: 'Detail',
          path: pathDetail,
          id: Math.random(),
          hideInMenu: '1',
        });
      }
    }
  }
  return res;
}

export const giveAuthority = (res = []) => {
  for(let item of res){
    item.authority = [item.path];
    item.hideInMenu = item.hideInMenu === '1';
    item.exact = true;
    if(item.component === 'Parent'){
      item.children = [];
    }
  }
  return res;
}
