import React, { Fragment, useEffect, useState } from 'react';
import { Input, Tree } from 'antd';
import Shell from '@/baseComponent/Shell';
import BlockTitle from '@/baseComponent/BlockTitle';
import { getListByTreeList } from '@/webPublic/Services';

const { TreeNode } = Tree;


const renderTreeNodes = data =>
  data.map(item => {
    if (item.children) {
      return (
        <TreeNode title={item.title} key={item.key} dataRef={item}>
          {renderTreeNodes(item.children)}
        </TreeNode>
      );
    }
    return <TreeNode key={item.id} {...item} dataRef={item} />;
  });

export default function AppTypeTreeAsyncLoad(props) {
	const { groupId, changeSearch, selectKey } = props;
	const [treeData, setTreeData] = useState([]);
	const [loading, setLoading] = useState(false);
	const [name, setName] = useState(''); // 搜索应用

  // useEffect(() => {
  //   if(groupId){
  //     setName('');
  //   }
  // }, [groupId]);

	useEffect(
		() => {
			if (groupId) {
			  setLoading(true);
				getListByTreeList({
					groupId,
					name,
				}).then((res) => {
          setLoading(false);
          if (res && res.length) {
						setTreeData(res);
						changeSearch({
							selectKey: res[0].id + '',
						});
					} else {
						setTreeData([]);
						changeSearch({
							selectKey: '',
						});
					}
				});
			}
		},
		[groupId, name],
	);

	const onSelect = (selectedKeys, info) => {
    changeSearch({
      selectKey: selectedKeys[0],
    });
  };

	const inputList = () => {
    return (
      <Input.Search
        placeholder={'应用名称搜索'}
        onSearch={(value) => {
          setName(value);
        }}
        style={{ marginLeft: '10px', width: '150px' }}
      />
    );
  };

	const onLoadData = treeNode =>
    new Promise(resolve => {
      if (treeNode.props.children || !treeNode.props.pos) {
        resolve();
        return;
      }
      getListByTreeList({
        groupId,
        name,
        parentId: treeNode.props.id,
      }).then((res) => {
        if(res && res.length){
          treeNode.props.dataRef.children = res.map((g) => {
            return {
              title: g.title,
              key: g.id,
              isLeaf: g.isLeaf,
              id: g.id,
            };
          });
        }
        setTreeData([...treeData]);
        resolve();
      });
    });

	return (
    <Fragment>
      <Shell
        styleShell={{
          borderRight: '1px solid rgba(210,210,210,1)',
          minHeight: document.body.clientHeight - 150,
          backgroundColor: '#fff',
          overflowX: 'auto',
          marginTop: 0,
        }}>
        <BlockTitle title={'应用'} isSmall={true} dom={inputList()} />
        <Tree
          onSelect={onSelect}
          selectedKeys={[selectKey]}
          style={{ minHeight: '400px,' }}
          loadData={onLoadData}
          disabled={loading}>
          {renderTreeNodes(treeData)}
        </Tree>
      </Shell>
    </Fragment>
  )
}
