/**
 * 钟是志
 * 2020年5月13日 17:38:51
 * 一站式应用 学工角色授权
 * */

import pageSetting from './pageSetting';
import pageSearch from './pageSearch';
import pageButton from './pageButton';
import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import { Row, Col } from 'antd';
import React from 'react';
import List from '@/highOrderComponent/List';
import AppTypeTree from './AppTypeTree';
import AppTypeTreeAsyncLoad from './AppTypeTreeAsyncLoad';
import { getAppTypeList } from '@/webPublic/Services';
import { getInfo } from '@/highOrderComponent/Service';

const Index = (WrappedComponent) =>
	class extends WrappedComponent {
		constructor(props) {
			super(props);
			this.state = {
				search: {
					selectKey: '',
				},
				formValues: {
					applyType: 'role',
					sysCode: 'xg',
				},
				typeList: [],
			};
		}

		changeFormValues = (formValues) => {
			this.setState({
				formValues,
			});
		};

		changeSearch = (search) => {
			this.setState(
				{
					search,
				},
				() => {
					if (search && search.selectKey) {
						this.instanceComponent.getPage();
					}
				},
			);
		};

		componentDidMount() {
			const { formValues } = this.state;
			getAppTypeList().then((treeListData) => {
				if (!treeListData) {
					return false;
				}
				const data = treeListData
					.filter((y) => {
						return y.appNum > 0;
					})
					.map((x) => {
						return {
							key: x.id,
							name: x.name + `(${x.appNum})`,
						};
					});
				this.setState(
					{
						typeList: data,
					},
					() => {
						this.setState({
							formValues: {
								...formValues,
								groupId: this.state.typeList[0].key,
							},
						});
					},
				);
			});
			return true;
		}

		render() {
			const { search, typeList, formValues } = this.state;
			if (!typeList.length || !formValues.groupId) {
				return null;
			}
			const pageS = pageSearch({
				typeList,
				selectKey: search.selectKey,
				changeFormValues: this.changeFormValues,
			});
			const pageB = pageButton({
				selectKey: search.selectKey,
				formValues,
			});
			return (
				<PageHeaderWrapper title="">
					<Row>
						<Col xl={6} xxl={5}>
							<AppTypeTreeAsyncLoad
								changeSearch={this.changeSearch}
								selectKey={search.selectKey}
								year={search.year}
								groupId={formValues.groupId}
							/>
						</Col>
						{search.selectKey ? (
							<Col xl={18} xxl={19}>
								<WrappedComponent
									listConfig={pageSetting.listConfig}
									pageButton={pageB}
									ref={(instanceComponent) => (this.instanceComponent = instanceComponent)}
									pageSearch={pageS}
								/>
							</Col>
						) : null}
					</Row>
				</PageHeaderWrapper>
			);
		}
	};

export default Index(List); // 高阶组件
