import React from 'react';
import { message } from 'antd';
import { getInfo } from '@/highOrderComponent/Service';

const submitData = (selectRows, formValues, appId) => {
	if (!selectRows.length) {
		message.warning('请先选择一个应用');
		return false;
	} else {
		let content = selectRows.map((x) => {
			return {
				appId,
				bizId: x.id,
				applyType: formValues.applyType,
				sysCode: formValues.sysCode,
			};
		});
		content = JSON.stringify(content);
		const data = {
			// roleId,
			op: 'add',
			content,
		};
		return getInfo(data, '/CommonApi/configApply');
	}
};

const deleteData = (ids) => {
	const data = {
		ids,
		op: 'delete',
	};
	return getInfo(data, '/CommonApi/configApply');
};

const handleButton = (props) => {
	const buttonConfig = [
		{
			name: '批量授权',
			type: 'Normal',
			component: 'Normal',
			handleClick: (selectRows, formValues, getPage, search) => {
				submitData(selectRows, formValues, props.selectKey).then((x) => {
					if (x) {
						getPage();
					}
				});
			},
		},
		{
			name: '批量取消授权',
			type: 'Normal222',
			component: 'Normal',
			handleClick: (selectRows, formValues, getPage, search) => {
				if (!selectRows.length) {
					message.warning('请先选择一个应用');
					return false;
				}
				const deleteIds = selectRows.map((x) => x.authId);
				deleteData(deleteIds.join(',')).then((x) => {
					if (x) {
						getPage();
					}
				});
			},
		},
	];
	return buttonConfig;
};

export default handleButton;
