import React, { Fragment } from 'react';
import { redText } from '@/pages/zydxg/CheckManage/PiciSetting/publicFunc';
import { getInfo } from '@/highOrderComponent/Service';

const width = 110;
const deleteChildren = (response) => {
	if (response && response.length) {
		for (let item of response) {
			if (item.children && !item.children.length) {
				delete item.children;
			} else if (item.children) {
				deleteChildren(item.children);
			}
		}
		return response;
	} else {
		return [];
	}
};

const handlePageSearch = (props) => {
	const pageSearch = {
		search: {
			url: '/asdasd/asdgggki',
			field: {
				groupId: {
					//
					required: true,
					defaultValue: props.typeList[0].key,
				},
				sysCode: {
					required: true,
					defaultValue: 'xg',
				},
				applyType: {
					required: true,
					defaultValue: 'role',
				},
			},
			getInfo: (data, url) => {
				return getInfo(
					{
						appId: props.selectKey,
						applyType: data.applyType,
						sysCode: data.sysCode,
					},
					'/CommonApi/queryApplyTarget',
				);
			},
			giveFieldsToFormValues: true,
			afterFormValuesChange: (key, oldValue, getPage) => {
				getPage();
				props.changeFormValues(oldValue);
			},
			responseCallBack: (response) => {
				return deleteChildren(response);
			},
			condition: [
				{
					key: 'groupId',
					name: '类别',
					type: 'select',
					options: props.typeList,
					required: true,
				},
				{
					key: 'sysCode',
					type: 'select',
					required: true,
					options: [
						{ key: 'xg', name: '学工' },
						{ key: 'sg', name: '宿管' },
						{ key: 'jy', name: '就业' },
						{ key: 'yx', name: '迎新' },
            { key: 'zs', name: '招生' },
            { key: 'wzb', name: '武装部' },
						{ key: 'xl', name: '心理健康xl' },
						{ key: 'xljk', name: '心理健康xljk' },
						{ key: 'uaa', name: '认证系统' },
						{ key: 'lx', name: '离校' },
						{ key: 'tw', name: '团委' },
						{ key: 'szxf', name: '素质学分' },
						{ key: 'szcp', name: '素质测评' },
					],
					name: '系统',
				},

				{
					key: 'applyType',
					type: 'radioGroup',
					required: true,
					name: '权限分类',
					options: [
						{
							key: 'role',
							name: '角色',
						},
						{
							key: 'group',
							name: '分组',
						},
					],
				},
			],
			nameSpan: { big: 6, small: 7 },
			fileSpan: { big: 4, small: 4 },
			noNeedReset: true, // 不需要重置按钮
		},
		tableRowKey: 'id',
		columns: [
			{
				dataIndex: 'groupName',
				title: '类别',
				width,
			},
			{
				dataIndex: 'title',
				title: '角色/分组',
				width: width + 150,
			},
			{
				dataIndex: 'hasAuth',
				title: '是否已授权',
				render: (text, record) => {
					return text ? redText('已授权') : '未授权';
				},
			},
		],
	};
	return pageSearch;
};

export default handlePageSearch;
