/**
 * 钟是志
 * 2019年3月29日
 * 一个年份加上校区-学院-专业的树
 * */

import { Tree } from 'antd';
import React, { Component, Fragment } from 'react';
import Shell from '@/baseComponent/Shell';
import { getAppTypeList } from '@/webPublic/Services';
import { getPermInfo } from '@/highOrderComponent/Service';
import { connect } from 'dva';

const { TreeNode } = Tree;

@connect(({ global }) => ({
	sysCode: global.system.sysCode,
}))
export default class AppTypeTree extends Component {
	constructor() {
		super();
		this.state = {
			treeListData: [],
			initYear: 0,
		};
	}

	handleChange = (newSearch) => {
		this.props.changeSearch(newSearch);
	};

	getList = () => {
		getPermInfo(
			{
				sysCode: this.props.sysCode,
			},
			'/PermApi/getRoleList',
		).then((treeListData) => {
			if (!treeListData || !treeListData.length) {
				this.setState({
					treeListData: [],
					loading: false,
				});
				this.handleChange({
					selectKey: '',
				});
			} else {
				this.handleChange({
					selectKey: treeListData[0].id + '',
				});
				this.handleChange({
					selectKey: treeListData[0].id + '',
				});
				this.setState({
					treeListData,
					loading: false,
				});
			}
		});
	};

	componentDidMount() {
		this.getList();
		setTimeout(() => {
			if (document.getElementById('list-table-dom')) {
				let tableDom = document.getElementById('list-table-dom');
				this.setState({
					heightSet:
						document.body.clientHeight - 150 > tableDom.offsetHeight + 164
							? document.body.clientHeight - 150
							: tableDom.offsetHeight + 164,
				});
			}
		}, 1000);
	}

	onSelect = (selectedKeys, info) => {
		this.handleChange({
			year: this.props.year,
			selectKey: selectedKeys[0],
		});
	};

	treeNodeList = (data) => {
		let dom = data.map((item) => {
			return <TreeNode title={item.title} key={item.id} />;
		});
		return dom;
	};

	render() {
		const { treeListData, loading, heightSet } = this.state;
		const { selectKey } = this.props;
		return (
			<Fragment>
				<Shell
					styleShell={{
						borderRight: '1px solid rgba(210,210,210,1)',
						minHeight: heightSet || document.body.clientHeight - 150,
						backgroundColor: '#fff',
						overflowX: 'auto',
						marginTop: 0,
					}}>
					<Tree
						onSelect={this.onSelect}
						selectedKeys={[selectKey]}
						style={{ minHeight: '400px,' }}
						disabled={loading}>
						{this.treeNodeList(treeListData)}
					</Tree>
				</Shell>
			</Fragment>
		);
	}
}
