/**
 * 钟是志
 * 2020年5月13日 17:38:51
 * 一站式应用 学工角色授权
 * */

import pageSetting from './pageSetting';
import pageSearch from './pageSearch';
import pageButton from './pageButton';
import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import { Row, Col } from 'antd';
import React from 'react';
import List from '@/highOrderComponent/List';
import AppTypeTree from './AppTypeTree';
import { getAppTypeList } from '@/webPublic/Services';
import { getInfo } from '@/highOrderComponent/Service';

const Index = (WrappedComponent) =>
	class extends WrappedComponent {
		constructor(props) {
			super(props);
			this.state = {
				search: {
					selectKey: '',
				},
				typeList: [],
				authorizedApp: [],
			};
		}

		getAuthorizedApp = () => {
			const { selectKey } = this.state.search;
			if (selectKey) {
				getInfo(
					{
						roleId: selectKey,
						cacheKey: Math.random(),
					},
					'/CommonApi/queryRoleApply',
				).then((x) => {
					if (x) {
						this.setState({
							authorizedApp: x,
						});
					}
				});
				this.instanceComponent.getPage();
			}
		};

		changeSearch = (search) => {
			this.setState(
				{
					search,
				},
				() => {
					this.getAuthorizedApp();
				},
			);
		};

		componentDidMount() {
			getAppTypeList().then((treeListData) => {
				if (!treeListData) {
					return false;
				}
				this.setState({
					typeList: treeListData.map((x) => {
						return {
							key: x.id,
							name: x.name + `(${x.appNum})`,
						};
					}),
				});
			});
			return true;
		}

		render() {
			const { search, typeList, authorizedApp } = this.state;
			if (!typeList.length) {
				return null;
			}
			const pageS = pageSearch({ typeList, authorizedApp });
			const pageB = pageButton({
				roleId: search.selectKey,
				authorizedApp,
				getAuthorizedApp: this.getAuthorizedApp,
			});
			return (
				<PageHeaderWrapper title="">
					<Row>
						<Col xl={5} xxl={4}>
							<AppTypeTree
								changeSearch={this.changeSearch}
								selectKey={search.selectKey}
								year={search.year}
							/>
						</Col>
						<Col xl={19} xxl={20}>
							<WrappedComponent
								listConfig={pageSetting.listConfig}
								pageButton={pageB}
								ref={(instanceComponent) => (this.instanceComponent = instanceComponent)}
								pageSearch={pageS}
							/>
						</Col>
					</Row>
				</PageHeaderWrapper>
			);
		}
	};

export default Index(List); // 高阶组件
